/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.socialawareness.service;

import com.infinite.focus.server.assessment.model.AssessmentOccurrence;
import com.infinite.focus.server.assessment.model.CategoryAndScore;
import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.data.model.OccurrenceAndOccurrenceAverage;
import com.infinite.focus.server.dataset.entity.DataSet;
import com.infinite.focus.server.dataset.service.DataSetService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.responsibledecisionmaking.model.AssessmentOccurrenceByStandards;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.socialawareness.dto.SocialAwarenessUpdateDTO;
import com.infinite.focus.server.socialawareness.entity.SocialAwarenessUpdate;
import com.infinite.focus.server.socialawareness.repository.SocialAwarenessUpdateCriteriaRepository;
import com.infinite.focus.server.socialawareness.repository.SocialAwarenessUpdateRepository;
import com.infinite.focus.server.socialawareness.service.SocialAwarenessUpdateService;
import com.infinite.focus.server.socialawareness.wrapper.SocialAwarenessUpdateWrapper;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class SocialAwarenessUpdateServiceImpl
implements SocialAwarenessUpdateService {
    private final EntityManager entityManager;
    private final SocialAwarenessUpdateRepository socialAwarenessUpdateRepository;
    private final SocialAwarenessUpdateCriteriaRepository socialAwarenessUpdateCriteriaRepository;
    private final DataSetService dataService;
    private final MessageService messageService;
    private final RestComponent restComponent;

    public SocialAwarenessUpdateServiceImpl(EntityManager entityManager, SocialAwarenessUpdateRepository socialAwarenessUpdateRepository, SocialAwarenessUpdateCriteriaRepository socialAwarenessUpdateCriteriaRepository, DataSetService dataService, MessageService messageService, RestComponent restComponent) {
        this.entityManager = entityManager;
        this.socialAwarenessUpdateRepository = socialAwarenessUpdateRepository;
        this.socialAwarenessUpdateCriteriaRepository = socialAwarenessUpdateCriteriaRepository;
        this.dataService = dataService;
        this.messageService = messageService;
        this.restComponent = restComponent;
    }

    public SocialAwarenessUpdate createSocialAwarenessUpdate(SocialAwarenessUpdate socialAwarenessUpdate) {
        DataSet dataSet = this.dataService.getDataSetById(socialAwarenessUpdate.getData_set_id());
        if (dataSet == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.data.set.is.not.found"));
        }
        socialAwarenessUpdate.setScore(dataSet.getScore());
        return (SocialAwarenessUpdate)this.socialAwarenessUpdateRepository.save((Object)socialAwarenessUpdate);
    }

    public Page<SocialAwarenessUpdateWrapper> getSocialAwarenessUpdateLogByStudentId(long student_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.socialAwarenessUpdateRepository.findByStudentId(student_id, (Pageable)paging);
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(log -> {
            SocialAwarenessUpdateWrapper wrapper = new SocialAwarenessUpdateWrapper();
            DataSet dataSet = this.dataService.getDataSetById(log.getData_set_id());
            this.dataService.addDataSetImages(dataSet);
            wrapper.setSocial_awareness_update_id(log.getSocial_awareness_update_id());
            wrapper.setStudent_id(log.getStudent_id());
            wrapper.setData_set_id(log.getData_set_id());
            wrapper.setText(log.getText());
            wrapper.setText_es(log.getText_es());
            wrapper.setImage(dataSet.getImage());
            wrapper.setColor(dataSet.getColor());
            wrapper.setCreatedAt(log.getCreatedAt());
            return wrapper;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public SocialAwarenessUpdate getSocialAwarenessUpdateById(long social_awareness_update_id) {
        return this.socialAwarenessUpdateRepository.findBySocialAwarenessUpdateId(Long.valueOf(social_awareness_update_id));
    }

    public CategoryAndScore getCategoryAndScoreBySocialAwarenessUpdateIdAndScore(long social_awareness_update_id, double score) {
        SocialAwarenessUpdate socialAwarenessUpdate = this.getSocialAwarenessUpdateById(social_awareness_update_id);
        CategoryDTO category = this.dataService.getCategoryByDataSetId(socialAwarenessUpdate.getData_set_id());
        CategoryAndScore categoryAndScore = new CategoryAndScore();
        categoryAndScore.setCategory(category);
        categoryAndScore.setScore(score);
        return categoryAndScore;
    }

    public List<String[]> getTextList() {
        List list = this.socialAwarenessUpdateRepository.getTextListOrderByDataSetId();
        ArrayList<String[]> texts = new ArrayList<String[]>();
        for (Object[] item : list) {
            texts.add(new String[]{(String)item[0], (String)item[1]});
        }
        return texts;
    }

    public List<SocialAwarenessUpdate> findByStudentIdAndBetweenFromDateAndEndDate(Long student_id, String fromDate, String toDate) {
        return this.socialAwarenessUpdateRepository.findByStudentIdAndBetweenFromDateAndEndDate(student_id, fromDate, toDate);
    }

    public List<SocialAwarenessUpdate> getSocialAwarenessUpdateByStudentIds(List<Long> student_ids, Date fromDate, Date toDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(SocialAwarenessUpdate.class);
        Root root = query.from(SocialAwarenessUpdate.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!AppUtils.isNotNullOrEmpty(student_ids)) {
            return new ArrayList<SocialAwarenessUpdate>();
        }
        CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student_id")).value(student_ids);
        predicates.add(genderPredicate);
        if (fromDate != null && toDate != null) {
            System.out.println("getSocialAwarenessUpdateByStudentIds FromDate " + DateUtils.dailyDateFormat.format(fromDate) + " - ToDate " + DateUtils.dailyDateFormat.format(toDate));
            predicates.add(criteriaBuilder.between((Expression)root.get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        }
        query.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("createdAt"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List socialAwarenessUpdateList = typedQuery.getResultList();
        System.out.println("SocialAwarenessUpdate Count = " + socialAwarenessUpdateList.size());
        return socialAwarenessUpdateList;
    }

    public AssessmentOccurrenceByStandards getByStudentIdsAndFromDateAndToDate(Set<Long> student_ids, Date from_date, Date to_date) {
        List socialAwarenessUpdateDTOS = this.socialAwarenessUpdateCriteriaRepository.findByStudentIdsAndBetweenFromDateAndToDate2(student_ids, from_date, to_date);
        AssessmentOccurrenceByStandards byStandards = AssessmentOccurrenceByStandards.builder()._3_5(new ArrayList(this.socialAwarenessUpdateCriteriaRepository.getTextToDisplay2()))._6_12(new ArrayList(this.socialAwarenessUpdateCriteriaRepository.getTextToDisplay2())).build();
        Set _3_5_standard_ids = this.restComponent.get3_5StandardIds();
        Set _6_12_standard_ids = this.restComponent.get6_12StandardIds();
        this.setSocialAwarenessByStandard(student_ids, _3_5_standard_ids, byStandards.get_3_5(), socialAwarenessUpdateDTOS);
        this.setSocialAwarenessByStandard(student_ids, _6_12_standard_ids, byStandards.get_6_12(), socialAwarenessUpdateDTOS);
        return byStandards;
    }

    public SocialAwarenessUpdateDTO getById(long social_awareness_update_id) {
        return this.socialAwarenessUpdateCriteriaRepository.findById(social_awareness_update_id);
    }

    public List<OccurrenceAndOccurrenceAverage> getOccurrenceAndOccurrenceAverageByStudentIdsAndFromDateAndToDate(Set<Long> student_ids, Date fromDate, Date toDate) {
        List socialAwarenessUpdateDTOS = this.socialAwarenessUpdateCriteriaRepository.findByStudentIdsAndBetweenFromDateAndToDate2(student_ids, fromDate, toDate);
        List occurrenceAndOccurrenceAverages = this.setSocialAwareness(student_ids, this.socialAwarenessUpdateCriteriaRepository.getTextToDisplay3(), socialAwarenessUpdateDTOS);
        return occurrenceAndOccurrenceAverages;
    }

    private void setSocialAwarenessByStandard(Set<Long> student_ids, Set<Long> standardIds, List<AssessmentOccurrence> assessmentOccurrences, List<SocialAwarenessUpdateDTO> socialAwarenessUpdateDTOS) {
        Set byStandards = socialAwarenessUpdateDTOS.stream().filter(r -> standardIds.contains(r.getStandard_id())).collect(Collectors.toSet());
        for (AssessmentOccurrence assessmentOccurrence : assessmentOccurrences) {
            for (SocialAwarenessUpdateDTO dto : byStandards) {
                if (!dto.getText().equalsIgnoreCase(assessmentOccurrence.getText_to_display()) || !dto.getText_es().equalsIgnoreCase(assessmentOccurrence.getText_to_display_es())) continue;
                assessmentOccurrence.setOccurrence(assessmentOccurrence.getOccurrence() + 1L);
            }
            try {
                assessmentOccurrence.setCount(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)assessmentOccurrence.getOccurrence() / (double)student_ids.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (AssessmentOccurrence assessmentOccurrence : assessmentOccurrences) {
            try {
                assessmentOccurrence.setOccurrence_average(DigitUtils.getPercentageInTwoDigit((Long)assessmentOccurrence.getOccurrence(), (Long)Long.valueOf(byStandards.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<OccurrenceAndOccurrenceAverage> setSocialAwareness(Set<Long> student_ids, List<OccurrenceAndOccurrenceAverage> occurrenceAndOccurrenceAverages, List<SocialAwarenessUpdateDTO> socialAwarenessUpdateDTOS) {
        for (OccurrenceAndOccurrenceAverage occurrenceAndOccurrenceAverage : occurrenceAndOccurrenceAverages) {
            for (SocialAwarenessUpdateDTO dto : socialAwarenessUpdateDTOS) {
                if (!dto.getText().equalsIgnoreCase(occurrenceAndOccurrenceAverage.getText_to_display()) || !dto.getText_es().equalsIgnoreCase(occurrenceAndOccurrenceAverage.getText_to_display_es())) continue;
                occurrenceAndOccurrenceAverage.setOccurrence(occurrenceAndOccurrenceAverage.getOccurrence() + 1L);
            }
            try {
                occurrenceAndOccurrenceAverage.setCount(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)occurrenceAndOccurrenceAverage.getOccurrence() / (double)student_ids.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (OccurrenceAndOccurrenceAverage occurrenceAndOccurrenceAverage : occurrenceAndOccurrenceAverages) {
            try {
                occurrenceAndOccurrenceAverage.setOccurrence_average(DigitUtils.getPercentageInTwoDigit((Long)occurrenceAndOccurrenceAverage.getOccurrence(), (Long)Long.valueOf(socialAwarenessUpdateDTOS.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return occurrenceAndOccurrenceAverages;
    }
}

