/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.standard.service;

import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.standard.dto.StandardDTO;
import com.infinite.focus.server.standard.entity.Standard;
import com.infinite.focus.server.standard.repository.StandardJPARepository;
import com.infinite.focus.server.standard.repository.StandardRepository;
import com.infinite.focus.server.standard.service.StandardService;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.utils.AppUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class StandardServiceImpl
implements StandardService {
    @Autowired
    StandardJPARepository standardJPARepository;
    @Autowired
    private StandardRepository standardRepository;
    @Autowired
    private RestComponent restComponent;
    @Autowired
    StudentService studentService;
    @Autowired
    MessageService messageService;

    public Standard findByStandardId(long standard_id) {
        return this.standardJPARepository.findByStandardId(Long.valueOf(standard_id));
    }

    public Standard getStandardById(long standard_id) {
        return this.standardJPARepository.findByStandardId(Long.valueOf(standard_id));
    }

    public void changeStandard(long instructor_id, long standard_id, long student_id) {
        Standard standard = this.findByStandardId(standard_id);
        if (standard == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("standard.is.not.found"));
        }
        Student student = this.studentService.getStudentById(student_id);
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.student.is.not.found"));
        }
        if (student.getInstructor_id() != instructor_id) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.student.is.not.belong.to.this.instructor"));
        }
        this.studentService.updateStandardIdAndGradeIdByStudentId(standard.getStandard_id(), standard.getGrade_id(), student.getStudent_id());
    }

    public void changeStandard(long instructor_id, long standard_id, List<Long> student_ids) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.student.s.id.list.should.not.be.empty.or.null"));
        }
        for (long student_id : student_ids) {
            this.changeStandard(instructor_id, standard_id, student_id);
        }
    }

    public Standard isValidStandard(long standard_id) {
        Standard standard = this.getStandardById(standard_id);
        if (standard == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("standard.is.not.found"));
        }
        return standard;
    }

    public Standard getStandardByStandardName(String standard_name) {
        return this.standardJPARepository.findByStandardName(standard_name);
    }

    public List<Standard> getAllStandardsOrderByStandardIdAsc() {
        return this.standardJPARepository.findAllOrderByStandardIdASC();
    }

    public List<StandardDTO> getAll() {
        return this.standardRepository.findAll();
    }

    public List<StandardDTO> getByIds(Set<Long> ids) {
        return this.standardRepository.findByIds(ids);
    }

    public StandardDTO getById(long id) {
        return this.standardRepository.findById(id);
    }

    public Set<Long> getK_2StandardIds() {
        HashSet<Long> _k_2_standard_ids = new HashSet<Long>();
        _k_2_standard_ids.add(1L);
        _k_2_standard_ids.add(2L);
        _k_2_standard_ids.add(3L);
        return _k_2_standard_ids;
    }

    public Set<Long> get3_5StandardIds() {
        HashSet<Long> _3_5_standard_ids = new HashSet<Long>();
        _3_5_standard_ids.add(4L);
        _3_5_standard_ids.add(5L);
        _3_5_standard_ids.add(6L);
        return _3_5_standard_ids;
    }

    public Set<Long> get6_12StandardIds() {
        HashSet<Long> _6_12_standard_ids = new HashSet<Long>();
        _6_12_standard_ids.add(7L);
        _6_12_standard_ids.add(8L);
        _6_12_standard_ids.add(9L);
        _6_12_standard_ids.add(10L);
        _6_12_standard_ids.add(11L);
        _6_12_standard_ids.add(12L);
        _6_12_standard_ids.add(13L);
        return _6_12_standard_ids;
    }
}

