/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.toppicks.service;

import com.infinite.focus.server.toppicks.dto.TopPicksDTO;
import com.infinite.focus.server.toppicks.repository.TopPicksCoreRepository;
import com.infinite.focus.server.toppicks.service.TopPicksService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TopPicksServiceImpl
implements TopPicksService {
    @Autowired
    private TopPicksCoreRepository topPicksCoreRepository;

    public TopPicksDTO getDailyTopPicks() {
        return this.topPicksCoreRepository.findDailyTopPicks();
    }

    public TopPicksDTO getById(long id) {
        return this.topPicksCoreRepository.findById(id);
    }

    public void deleteById(long id) {
        this.topPicksCoreRepository.deleteById(id);
    }

    public List<TopPicksDTO> getAll() {
        return this.topPicksCoreRepository.findAllOrderById();
    }

    public TopPicksDTO update(long id, String quote, String quote_es) {
        this.topPicksCoreRepository.update(id, quote, quote_es);
        return this.getById(id);
    }

    public void updateAllIsDailyTopPicksToFalse() {
        this.topPicksCoreRepository.updateAllIsDailyTopPicksToFalse();
    }

    public TopPicksDTO getRandomTopPicks() {
        return this.topPicksCoreRepository.findRandomTopPicks();
    }

    public TopPicksDTO updateIsDailyTopPicks(long id, Boolean isDailyTopPicks) {
        this.topPicksCoreRepository.updateIsDailyTopPicks(id, isDailyTopPicks);
        return this.getById(id);
    }

    public TopPicksDTO create(String quote, String quote_es) {
        return this.topPicksCoreRepository.create(quote, quote_es);
    }
}

