/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.selfmanagement.repository;

import com.infinite.focus.server.selfmanagement.entity.SelfManagementUpdate;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface SelfManagementUpdateRepository
extends JpaRepository<SelfManagementUpdate, Long> {
    @Query(value="SELECT * FROM self_management_update WHERE student_id = ?1 ORDER BY created_at DESC", nativeQuery=true)
    public List<SelfManagementUpdate> findByStudentIdOrderByCreatedAtDesc(Long var1);

    @Query(value="SELECT * FROM self_management_update WHERE self_management_update_id = ?1", nativeQuery=true)
    public SelfManagementUpdate findBySelfManagementUpdateId(Long var1);

    @Query(value="SELECT text FROM self_management_update group by text", nativeQuery=true)
    public List<String> getTextList();

    @Query(value="SELECT DISTINCT text, text_es, data_set_id FROM self_management_update ORDER BY data_set_id ASC", nativeQuery=true)
    public List<Object[]> getTextListOrderByDataSetId();

    @Query(value="SELECT * FROM self_management_update WHERE student_id = ?1 AND created_at BETWEEN ?2  AND ?3 ORDER BY created_at desc", nativeQuery=true)
    public List<SelfManagementUpdate> findByStudentIdAndBetweenFromDateAndEndDate(Long var1, String var2, String var3);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM self_management_update WHERE student_id = ?1", nativeQuery=true)
    public void deleteByStudentId(long var1);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM self_management_update WHERE student_id IN(?1)", nativeQuery=true)
    public void deleteByStudentIds(List<Long> var1);

    @Query(value="SELECT * FROM self_management_update WHERE student_id = ?1", nativeQuery=true)
    public Page<SelfManagementUpdate> findByStudentId(long var1, Pageable var3);
}

