/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosoption.repository;

import com.infinite.focus.server.sosoption.dto.SOSOptionDTO;
import com.infinite.focus.server.sosoption.repository.SOSOptionRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

@Repository
public class SOSOptionRepositoryImpl
implements SOSOptionRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static SOSOptionDTO mapRow(ResultSet rs, int i) throws SQLException {
        return SOSOptionDTO.builder().sos_option_id(rs.getLong("sos_option_id")).sos_question_id(rs.getLong("sos_question_id")).sos_option(rs.getString("sos_option")).sos_option_es(rs.getString("sos_option_es")).sort_index(rs.getInt("sort_index")).build();
    }

    public SOSOptionDTO create(long sos_question_id, String sos_option, String sos_option_es, int sort_index) {
        String INSERT_SQL = "INSERT INTO sosoption (sos_question_id, sos_option, sos_option_es, active, sort_index, created_at, updated_at) VALUES (?,?,?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO sosoption (sos_question_id, sos_option, sos_option_es, active, sort_index, created_at, updated_at) VALUES (?,?,?,?,?,?,?)", 1);
            ps.setLong(1, sos_question_id);
            ps.setString(2, sos_option);
            ps.setString(3, sos_option_es);
            ps.setBoolean(4, true);
            ps.setInt(6, sort_index);
            ps.setTimestamp(6, Timestamp.valueOf(LocalDateTime.now()));
            ps.setTimestamp(7, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int sos_option_id = Objects.requireNonNull(holder.getKey()).intValue();
        return SOSOptionDTO.builder().sos_option_id((long)sos_option_id).sos_question_id(sos_question_id).sos_option(sos_option).sos_option_es(sos_option_es).sort_index(sort_index).build();
    }

    @Transactional
    public ArrayList<Long> createOptions(List<SOSOptionDTO> options) {
        List optionsThatNeedToInsert;
        ArrayList<Long> createdAndUpdateIds = new ArrayList<Long>();
        List optionsThatNeedToUpdate = options.stream().filter(option -> option.getSos_option_id() > 0L).collect(Collectors.toList());
        if (!AppUtils.isNullOrEmpty(optionsThatNeedToUpdate)) {
            for (SOSOptionDTO option2 : optionsThatNeedToUpdate) {
                this.makeOptionsInactiveByQuestionId(option2.getSos_question_id());
            }
            String UPDATE_SQL = "UPDATE sosoption SET sos_question_id = ?, sos_option = ?, sos_option_es = ?, active = 1, sort_index = ?, updated_at = ? WHERE sos_option_id = ?";
            Integer updatedCount = (Integer)this.jdbcTemplate.execute(connection -> connection.prepareStatement("UPDATE sosoption SET sos_question_id = ?, sos_option = ?, sos_option_es = ?, active = 1, sort_index = ?, updated_at = ? WHERE sos_option_id = ?"), ps -> {
                for (SOSOptionDTO option : optionsThatNeedToUpdate) {
                    ps.setLong(1, option.getSos_question_id());
                    ps.setString(2, option.getSos_option());
                    ps.setString(3, option.getSos_option_es());
                    ps.setInt(4, option.getSort_index());
                    ps.setTimestamp(5, Timestamp.valueOf(LocalDateTime.now()));
                    ps.setLong(6, option.getSos_option_id());
                    ps.addBatch();
                }
                ps.executeBatch();
                return ps.getUpdateCount();
            });
            List updatedOptionIds = optionsThatNeedToUpdate.stream().map(SOSOptionDTO::getSos_option_id).collect(Collectors.toList());
            if (updatedCount == 1) {
                createdAndUpdateIds.addAll(updatedOptionIds);
            } else {
                throw new ResponseStatusException(HttpStatus.CONFLICT, "Not updated!!!");
            }
        }
        if (!AppUtils.isNullOrEmpty(optionsThatNeedToInsert = options.stream().filter(option -> option.getSos_option_id() == 0L).collect(Collectors.toList()))) {
            String INSERT_SQL = "INSERT INTO sosoption (sos_question_id, sos_option, sos_option_es, active, sort_index, created_at, updated_at) VALUES (?,?,?,?,?,?,?)";
            ArrayList insertedIds = (ArrayList)this.jdbcTemplate.execute(connection -> connection.prepareStatement("INSERT INTO sosoption (sos_question_id, sos_option, sos_option_es, active, sort_index, created_at, updated_at) VALUES (?,?,?,?,?,?,?)", 1), ps -> {
                for (SOSOptionDTO option : optionsThatNeedToInsert) {
                    ps.setLong(1, option.getSos_question_id());
                    ps.setString(2, option.getSos_option());
                    ps.setString(3, option.getSos_option_es());
                    ps.setBoolean(4, true);
                    ps.setInt(5, option.getSort_index());
                    ps.setTimestamp(6, Timestamp.valueOf(LocalDateTime.now()));
                    ps.setTimestamp(7, Timestamp.valueOf(LocalDateTime.now()));
                    ps.addBatch();
                }
                ps.executeBatch();
                ResultSet resultSet = ps.getGeneratedKeys();
                ArrayList<Long> ids = new ArrayList<Long>();
                while (resultSet.next()) {
                    ids.add(resultSet.getLong(1));
                }
                return ids;
            });
            createdAndUpdateIds.addAll(insertedIds);
        }
        return createdAndUpdateIds;
    }

    public List<SOSOptionDTO> findByIds(Set<Long> sos_option_ids) {
        if (AppUtils.isNullOrEmpty(sos_option_ids)) {
            return new ArrayList<SOSOptionDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(sos_option_ids.size(), "?"));
        String SQL = "SELECT * FROM sosoption WHERE sos_option_id IN(%s) ORDER BY sort_index ASC";
        List sosOptionDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), sos_option_ids.toArray(), SOSOptionRepositoryImpl::mapRow);
        return sosOptionDTOS;
    }

    public List<SOSOptionDTO> findActiveByIds(List<Long> sos_option_ids) {
        if (AppUtils.isNullOrEmpty(sos_option_ids)) {
            return new ArrayList<SOSOptionDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(sos_option_ids.size(), "?"));
        String SQL = "SELECT * FROM sosoption WHERE active = 1 AND sos_option_id IN(%s) ORDER BY sort_index ASC";
        List sosOptionDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), sos_option_ids.toArray(), SOSOptionRepositoryImpl::mapRow);
        return sosOptionDTOS;
    }

    public List<SOSOptionDTO> getOptionsByQuestionId(long sos_question_id) {
        String SQL = "SELECT * FROM sosoption WHERE active = 1 AND sos_question_id = ? ORDER BY sort_index ASC";
        List sosOptionDTOS = this.jdbcTemplate.query(SQL, new Object[]{sos_question_id}, SOSOptionRepositoryImpl::mapRow);
        return sosOptionDTOS;
    }

    public void makeOptionsInactiveByQuestionId(long sos_question_id) {
        String SQL = "UPDATE sosoption SET active = 0, updated_at = ? WHERE sos_question_id = ?";
        this.jdbcTemplate.update("UPDATE sosoption SET active = 0, updated_at = ? WHERE sos_question_id = ?", new Object[]{Timestamp.valueOf(LocalDateTime.now()), sos_question_id});
    }
}

