/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.student.service;

import com.infinite.focus.server.accesscode.dto.AccessCodeDTO;
import com.infinite.focus.server.account.dto.AccountDTO;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.account.view.AccountView;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.avatar.dto.AvatarDTO;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.group.view.ClassView;
import com.infinite.focus.server.instructor.dto.InstructorDTO;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.parent.dto.ParentCoreDTO;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.standard.dto.StandardDTO;
import com.infinite.focus.server.standard.repository.StandardJPARepository;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentCoreRepository;
import com.infinite.focus.server.student.repository.StudentCriteriaRepository;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.request.SearchStudentRequest;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.student.wrapper.InstructorDetailWrapper;
import com.infinite.focus.server.student.wrapper.ParentDetailWrapper;
import com.infinite.focus.server.student.wrapper.StudentClassWrapper;
import com.infinite.focus.server.student.wrapper.StudentDetailWrapper;
import com.infinite.focus.server.student.wrapper.StudentIdAndStandardIdWrapper;
import com.infinite.focus.server.student.wrapper.StudentProfileWrapper;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class StudentServiceImpl
implements StudentService {
    private final EntityManager entityManager;
    private final AccountRepository accountRepository;
    private final MessageService messageService;
    private final StandardJPARepository standardJPARepository;
    private final StudentRepository studentRepository;
    private final StudentCriteriaRepository studentCriteriaRepository;
    private final ClassRepository classRepository;
    private final RestComponent restComponent;
    private final StudentCoreRepository studentCoreRepository;

    public StudentServiceImpl(EntityManager entityManager, AccountRepository accountRepository, MessageService messageService, StandardJPARepository standardJPARepository, StudentRepository studentRepository, StudentCriteriaRepository studentCriteriaRepository, ClassRepository classRepository, RestComponent restComponent, StudentCoreRepository studentCoreRepository) {
        this.entityManager = entityManager;
        this.accountRepository = accountRepository;
        this.messageService = messageService;
        this.standardJPARepository = standardJPARepository;
        this.studentRepository = studentRepository;
        this.studentCriteriaRepository = studentCriteriaRepository;
        this.classRepository = classRepository;
        this.restComponent = restComponent;
        this.studentCoreRepository = studentCoreRepository;
    }

    public StudentCoreDTO getByToken(String token) {
        AccountDTO accountDTO = this.restComponent.getAccountByToken(token);
        if (accountDTO == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        return this.studentCoreRepository.findByAccountId(accountDTO.getAccount_id());
    }

    public StudentDetailWrapper getDetailByToken(String token) {
        AccountDTO accountDTO = this.restComponent.getAccountByToken(token);
        if (accountDTO == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        return StudentDetailWrapper.builder().account(accountDTO).student(this.studentCoreRepository.findByAccountId(accountDTO.getAccount_id())).build();
    }

    public void setLanguage(long student_id, String language) {
        this.studentCoreRepository.setLanguage(student_id, language);
    }

    public void setOSAndBrowser(long student_id, String os, String browser) {
        this.studentCoreRepository.setOSAndBrowser(student_id, os, browser);
    }

    public StudentCoreDTO getByCleverId(String clever_id) {
        return this.studentCoreRepository.findByCleverId(clever_id);
    }

    public StudentProfileWrapper getProfile(long student_id) {
        ParentCoreDTO parentDTO;
        StudentProfileWrapper studentProfileWrapper = new StudentProfileWrapper();
        StudentCoreDTO student = this.studentCoreRepository.findById(student_id);
        studentProfileWrapper.setStudent(student);
        AccountDTO account = this.restComponent.getAccountById(student.getAccount_id());
        studentProfileWrapper.setAccount(account);
        StandardDTO standardDTO = this.restComponent.getStandardById(student.getStandard_id());
        studentProfileWrapper.setStandard(standardDTO);
        InstructorDTO instructorDTO = this.restComponent.getInstructorDTOById(student.getInstructor_id());
        if (instructorDTO != null) {
            studentProfileWrapper.setInstructor(InstructorDetailWrapper.builder().instructor_id(instructorDTO.getInstructor_id()).first_name(instructorDTO.getFirst_name()).last_name(instructorDTO.getLast_name()).registration_code(instructorDTO.getRegistration_code()).build());
        }
        if ((parentDTO = this.restComponent.getParentCoreDTOById(student.getParent_id())) != null) {
            studentProfileWrapper.setParent(ParentDetailWrapper.builder().parent_id(parentDTO.getParent_id()).first_name(parentDTO.getFirst_name()).last_name(parentDTO.getLast_name()).registration_code(parentDTO.getRegistration_code()).build());
        }
        return studentProfileWrapper;
    }

    public StudentCoreDTO saveProfile(long student_id, long school_id, long avatar_id, Date date_of_birth, String gender, String ethnicity, long standard_id, long instructor_id, long parent_id, boolean share_your_success) {
        StudentCoreDTO studentCoreDTO;
        InstructorDTO instructor;
        if (instructor_id == 0L && parent_id == 0L) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("please.provide.a.valid.parent.or.instructor"));
        }
        if (date_of_birth != null) {
            DateUtils.isAgeInRange((java.util.Date)date_of_birth, (int)4, (int)19);
        }
        if ((instructor = this.restComponent.getInstructorDTOById(instructor_id)) != null) {
            if (school_id != instructor.getSchool_id()) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("instructor.s.school.and.student.s.school.must.be.same"));
            }
        } else {
            instructor_id = 0L;
        }
        if ((studentCoreDTO = this.studentCoreRepository.saveProfile(student_id, school_id, avatar_id, date_of_birth, gender, ethnicity, standard_id, instructor_id, parent_id, share_your_success)) == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("student.detail.is.not.updated"));
        }
        try {
            this.restComponent.updateAccessCodeInstructorIdAndParentIdByStudentId(instructor_id, parent_id, student_id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.restComponent.syncWallPostRequests(student_id, instructor_id, parent_id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return studentCoreDTO;
    }

    public List<StudentCoreDTO> getAll() {
        return this.studentCoreRepository.findAll();
    }

    public Student getStudentById(long student_id) {
        return this.studentRepository.findByStudentId(Long.valueOf(student_id));
    }

    public void setNewNotifications(List<Long> student_ids, boolean new_notifications) {
        this.studentCoreRepository.setNewNotifications(student_ids, new_notifications);
    }

    public Student getStudentByCleverId(String clever_id) {
        return this.studentRepository.findByStudentCleverId(clever_id);
    }

    public Student getStudentByAccountId(long account_id) {
        return this.studentRepository.findByAccountId(Long.valueOf(account_id));
    }

    public List<Student> getStudentsByFirstNameAndLastName(String first_name, String last_name) {
        return this.studentRepository.findStudentByFirstNameAndLastName(first_name, last_name);
    }

    public Page<Object> searchStudentByInstructorAndDemographic(Instructor instructor, SearchStudentRequest request) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Long.class);
        Root s = query.from(Student.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        CriteriaBuilder.In statusPredicate = qb.in((Expression)s.get("accessCode").get("status")).value(Arrays.asList(Status.ACCEPTED, Status.REJECTED));
        predicates.add(statusPredicate);
        if (instructor != null) {
            Predicate genderPredicate = qb.equal((Expression)s.get("instructor").get("instructor_id"), (Object)instructor.getInstructor_id());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getFirst_name())) {
            Predicate firstNamePredicate = qb.like((Expression)s.get("first_name"), "%" + request.getFirst_name() + "%");
            predicates.add(firstNamePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getLast_name())) {
            Predicate lastNamePredicate = qb.like((Expression)s.get("last_name"), "%" + request.getLast_name() + "%");
            predicates.add(lastNamePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getEmail())) {
            Predicate emailPredicate = qb.like((Expression)s.get("account").get("username"), "%" + request.getEmail() + "%");
            predicates.add(emailPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getClass_name())) {
            List classIds = this.classRepository.findClassIdsWhereClassNameLike(request.getClass_name());
            if (AppUtils.isNotNullOrEmpty((List)classIds)) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (int i = 0; i < classIds.size(); ++i) {
                    ids.add(((BigInteger)classIds.get(i)).longValue());
                }
                Subquery sq = query.subquery(Long.class).select(qb.literal((Object)1L));
                Root sqRoot = sq.correlate(s);
                Join sqJoin = sqRoot.join("classes");
                sq.where((Expression)sqJoin.get("class_id").in(ids));
                predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
            } else {
                Subquery sq = query.subquery(Long.class).select(qb.literal((Object)1L));
                Root sqRoot = sq.correlate(s);
                Join sqJoin = sqRoot.join("classes");
                sq.where((Expression)sqJoin.get("class_id").in(new Object[]{-1}));
                predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
            }
        }
        query.select((Selection)s.get("student_id")).where(predicates.toArray(new Predicate[0]));
        PageRequest pageable = null;
        if (request.getOrderBy().equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)s.get(request.getSortBy())), qb.desc((Expression)s.get("student_id"))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)s.get(request.getSortBy())), qb.asc((Expression)s.get("student_id"))});
        }
        pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        TypedQuery result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root studentRootCount = countQuery.from(Student.class);
        countQuery.select((Selection)qb.count((Expression)studentRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result.getResultList(), (Pageable)pageable, count.longValue());
        System.out.println("Student Count = " + pagedResult.getContent().size());
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(student_id -> {
            LinkedList classViews;
            AccountView accountView;
            AccessCodeDTO accessCodeDTO;
            LinkedHashMap<String, Object> wrapper = new LinkedHashMap<String, Object>();
            StudentCoreDTO studentDTO = this.studentCoreRepository.findById(student_id.longValue());
            wrapper.put("student_id", studentDTO.getStudent_id());
            wrapper.put("instructor_id", studentDTO.getInstructor_id());
            wrapper.put("standard_id", studentDTO.getStandard_id());
            wrapper.put("first_name", studentDTO.getFirst_name());
            wrapper.put("last_name", studentDTO.getLast_name());
            wrapper.put("avatar_id", studentDTO.getAvatar_id());
            AvatarDTO avatarDTO = this.restComponent.getAvatarById(studentDTO.getAvatar_id());
            if (avatarDTO != null) {
                wrapper.put("avatar_url", avatarDTO.getPreview_url());
            }
            if ((accessCodeDTO = this.restComponent.getAccessCodeByStudentId(studentDTO.getStudent_id())) != null) {
                wrapper.put("status", accessCodeDTO.getStatus());
            }
            if ((accountView = this.accountRepository.findAccountViewByAccountId(Long.valueOf(studentDTO.getAccount_id()))) != null) {
                wrapper.put("username", accountView.getUsername());
                wrapper.put("username2", accountView.getUsername2());
            }
            wrapper.put("parent_id", studentDTO.getParent_id());
            Parent parentView = this.restComponent.getParentById(studentDTO.getParent_id());
            if (parentView != null) {
                LinkedHashMap<String, Object> wrapperParent = new LinkedHashMap<String, Object>();
                wrapperParent.put("parent_id", parentView.getParent_id());
                AccountView accountViewParent = this.accountRepository.findAccountViewByAccountId(Long.valueOf(parentView.getAccount_id()));
                if (accountViewParent != null) {
                    wrapperParent.put("username", accountViewParent.getUsername());
                }
                wrapperParent.put("registration_code", parentView.getFirst_name());
                wrapperParent.put("first_name", parentView.getFirst_name());
                wrapperParent.put("last_name", parentView.getLast_name());
                wrapperParent.put("phone", parentView.getPhone());
                wrapperParent.put("email", parentView.getEmail());
                wrapper.put("parent", wrapperParent);
            }
            if (!AppUtils.isNullOrEmpty((List)(classViews = this.classRepository.findClassViewByStudentId(studentDTO.getStudent_id())))) {
                LinkedList classes = new LinkedList();
                for (ClassView classView : classViews) {
                    LinkedHashMap<String, Object> wrapperClass = new LinkedHashMap<String, Object>();
                    wrapperClass.put("class_id", classView.getClass_id());
                    wrapperClass.put("class_name", classView.getClass_name());
                    classes.add(wrapperClass);
                }
                wrapper.put("classes", classes);
            }
            wrapper.put("clever_id", studentDTO.getClever_id());
            wrapper.put("verified", studentDTO.isVerified());
            return wrapper;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public List<Student> searchStudentByDemographicAndIds(SearchStudentRequest request, List<Long> studentIds) {
        Predicate genderPredicate;
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Student.class);
        Root s = c.from(Student.class);
        Join ac = s.join("account", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty(studentIds)) {
            CriteriaBuilder.In classesPredicate = qb.in((Expression)s.get("student_id")).value(studentIds);
            predicates.add(classesPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getFirst_name())) {
            genderPredicate = qb.like((Expression)s.get("first_name"), "%" + request.getFirst_name() + "%");
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getLast_name())) {
            genderPredicate = qb.like((Expression)s.get("last_name"), "%" + request.getLast_name() + "%");
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getEmail())) {
            genderPredicate = qb.like((Expression)ac.get("username"), "%" + request.getEmail() + "%");
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getClass_name())) {
            List classIds = this.classRepository.findClassIdsWhereClassNameLike(request.getClass_name());
            if (AppUtils.isNotNullOrEmpty((List)classIds)) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (int i = 0; i < classIds.size(); ++i) {
                    ids.add(((BigInteger)classIds.get(i)).longValue());
                }
                Subquery sq = c.subquery(Long.class).select(qb.literal((Object)1L));
                Root sqRoot = sq.correlate(s);
                Join sqJoin = sqRoot.join("classes");
                sq.where((Expression)sqJoin.get("class_id").in(ids));
                predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
            } else {
                Subquery sq = c.subquery(Long.class).select(qb.literal((Object)1L));
                Root sqRoot = sq.correlate(s);
                Join sqJoin = sqRoot.join("classes");
                sq.where((Expression)sqJoin.get("class_id").in(new Object[]{-1}));
                predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
            }
        }
        c.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(c);
        List students = typedQuery.getResultList();
        System.out.println("Student Count = " + students.size());
        return students;
    }

    public long getStudentsCountByInstructorId(long instructor_id) {
        return this.studentRepository.getStudentsCountByInstructorId(instructor_id);
    }

    public Student setParentDetail(long student_id, String country_code, String phone, String email) {
        if (AppUtils.isNotNullOrEmpty((String)email) && !AppUtils.isValidateEmail((String)email)) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Student student = this.getStudentById(student_id);
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        Parent parent = null;
        parent = student.getParent() == null ? this.restComponent.createParent(student.getSchool() != null ? student.getSchool().getSchool_id() : 0L, country_code, phone, email) : this.restComponent.updateParent(student.getParent().getParent_id(), country_code, phone, email);
        if (student.getAccount().getUsername2() == null || student.getAccount().getUsername2().isEmpty()) {
            this.studentRepository.updateParentIdByStudentId(parent.getParent_id(), student.getStudent_id());
        } else {
            student.setParent(parent);
            this.studentRepository.save((Object)student);
        }
        return this.getStudentById(student_id);
    }

    public List<Student> getStudentsByInstructorId(long instructor_id) {
        return this.studentRepository.findFullStudentByInstructorId(Long.valueOf(instructor_id));
    }

    public List<Long> getStudentIdsByInstructorId(long instructor_id) {
        return this.studentCriteriaRepository.getStudentIdsByInstructorId(instructor_id);
    }

    public List<Long> getStudentIdsByInstructorIds(List<Long> instructor_ids) {
        return this.studentCriteriaRepository.getStudentIdsByInstructorIds(instructor_ids);
    }

    public Student save(Student student) {
        return (Student)this.studentRepository.save((Object)student);
    }

    public List<Student> saveAll(List<Student> student) {
        return this.studentRepository.saveAll(student);
    }

    public void updateClassIdByStudentId(long class_id, long student_id) {
        Student student = this.getStudentById(student_id);
        Class class_ = this.classRepository.findByClassId(class_id);
        if (class_ != null) {
            student.getClasses().add(class_);
        }
        this.save(student);
    }

    public void updateStandardIdAndGradeIdByStudentId(long standard_id, long grade_id, long student_id) {
        Student student = this.getStudentById(student_id);
        student.setStandard(this.standardJPARepository.findByStandardId(Long.valueOf(standard_id)));
        this.save(student);
    }

    public Student isValidStudent(long student_id) {
        Student student = this.getStudentById(student_id);
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        return student;
    }

    public Student setOperatingSystemAndBrowser(long student_id, String operating_system, String browser) {
        Student student = this.getStudentById(student_id);
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        student.setOperating_system(operating_system);
        student.setBrowser(browser);
        return (Student)this.studentRepository.save((Object)student);
    }

    public List<Student> getStudentsByCleverIdOrUserName(String clever_id, String username) {
        return this.studentRepository.findStudentsByCleverIdOrUserName(clever_id, username);
    }

    public Student findByRegistrationCode(String possible_code) {
        return this.studentRepository.findByRegistrationCode(possible_code);
    }

    public Student generateRegistrationCodeForStudent(Student student) {
        try {
            if (AppUtils.isNullOrEmpty((String)student.getRegistration_code())) {
                boolean isUnique = false;
                while (!isUnique) {
                    String possible_code = "ST" + KeyGenerator.generateUniqueAuthCode();
                    Student x = this.findByRegistrationCode(possible_code);
                    if (x == null) {
                        isUnique = true;
                        student.setRegistration_code(possible_code);
                        continue;
                    }
                    isUnique = false;
                }
                student = this.save(student);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return student;
    }

    public List<Student> getStudentsByCleverId(List<String> students_clever_ids) {
        return this.studentRepository.findByCleverId(students_clever_ids);
    }

    public Student shouldShareWithInstructorAndParents(long student_id, boolean share_journal_with_instructor, boolean share_journal_with_parents) {
        Student student = this.getStudentById(student_id);
        student.setShare_journal_with_instructor(share_journal_with_instructor);
        student.setShare_journal_with_parents(share_journal_with_parents);
        return this.save(student);
    }

    public long getStudentsCountBySchoolId(long school_id) {
        return this.studentRepository.getStudentsCountBySchoolId(school_id);
    }

    public List<StudentDTO> getStudentsByInstructorIdAndStudentName(Long instructor_id, String student_name) {
        return this.studentCriteriaRepository.findByInstructorIdAndStudentName(instructor_id, student_name);
    }

    public List<Long> getStudentIdsBySchoolId(long school_id) {
        return this.studentCriteriaRepository.getStudentIdsBySchoolId(school_id);
    }

    public List<StudentCoreDTO> getStudentsByIds(List<Long> ids) {
        return this.studentCoreRepository.findByIds(ids);
    }

    public List<Long> getStudentIdsByDemographics(long school_id, String name, List<String> genders, List<Integer> ages, List<String> ethnicity, List<Long> gradeIds, List<Long> classIds) {
        Set student_ids_by_class_ids = this.restComponent.getStudentIdsByClassIds(classIds);
        if (!AppUtils.isNullOrEmpty(classIds) && AppUtils.isNullOrEmpty((Set)student_ids_by_class_ids)) {
            student_ids_by_class_ids.add(-1L);
        }
        return this.studentCriteriaRepository.findStudentIdsByDemographics(school_id, name, genders, ages, ethnicity, gradeIds, student_ids_by_class_ids);
    }

    public List<StudentIdAndStandardIdWrapper> getStudentIdAndStandardIdByStudentIds(Set<Long> student_ids) {
        return this.studentCoreRepository.findStudentIdAndStandardIdByStudentIds(student_ids);
    }

    public StudentCoreDTO getByAccountId(long account_id) {
        return this.studentCoreRepository.findByAccountId(account_id);
    }

    public StudentCoreDTO getByStudentId(long student_id) {
        return this.studentCoreRepository.findById(student_id);
    }

    public List<StudentClassWrapper> getByInstructorIdAndStatus(long instructor_id, Set<String> status) {
        ArrayList<StudentClassWrapper> list = new ArrayList<StudentClassWrapper>();
        for (Student student : this.studentRepository.findIdsByInstructorIdAndStatus(instructor_id, status)) {
            StudentClassWrapper w = new StudentClassWrapper();
            w.setStudent(student);
            w.setParent(student.getParent());
            list.add(w);
        }
        return list;
    }

    public void setShouldForceSocioEmotionalAssessment(List<Long> student_ids, boolean should_force_socio_emotional_assessment) {
        this.studentCoreRepository.setShouldForceSocioEmotionalAssessment(student_ids, should_force_socio_emotional_assessment);
    }
}

