/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.service.category;

import com.infinite.focus.server.activity.entity.Activity;
import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.category.repository.CategoryRepository;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.model.PostType;
import com.infinite.focus.server.post.repository.PostRepository;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.studentstreak.helper.StreakHelper;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.studentstreak.service.category.StreakCategoryService;
import com.infinite.focus.server.utils.AppUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class StreakCategoryServiceImpl
implements StreakCategoryService {
    private final PostRepository postRepository;
    private final CategoryRepository categoryRepository;
    private final StreakRepository streakRepository;
    private final StudentStreakRepository studentStreakRepository;
    private final StreakHelper streakHelper;

    public StreakCategoryServiceImpl(PostRepository postRepository, CategoryRepository categoryRepository, StreakRepository streakRepository, StudentStreakRepository studentStreakRepository, StreakHelper streakHelper) {
        this.postRepository = postRepository;
        this.categoryRepository = categoryRepository;
        this.streakRepository = streakRepository;
        this.studentStreakRepository = studentStreakRepository;
        this.streakHelper = streakHelper;
    }

    public StreakDTO addStreakAllCompetencies(Long student_id, List<Activity> activities) {
        if (!AppUtils.isNullOrEmpty(activities)) {
            List streaks;
            List posts = activities.stream().map(activity -> this.postRepository.findById(activity.getEntity_id())).filter(post -> post.getPost_type().equals((Object)PostType.VIDEO)).collect(Collectors.toList());
            HashSet categoryIds = new HashSet();
            for (PostDTO post2 : posts) {
                categoryIds.addAll(post2.getCategories().stream().map(CategoryDTO::getCategory_id).collect(Collectors.toSet()));
            }
            Set allCategoryIds = this.categoryRepository.findAll().stream().map(CategoryDTO::getCategory_id).collect(Collectors.toSet());
            if (allCategoryIds.size() == categoryIds.size() && !AppUtils.isNullOrEmpty((List)(streaks = this.streakRepository.findByStreakType(StreakType.ALL_COMPETENCIES.name()))) && this.studentStreakRepository.findByStudentIdAndStreakId(student_id, Long.valueOf(((StreakDTO)streaks.get(0)).getStreak_id())) == null) {
                return this.streakHelper.saveStudentStreak(student_id.longValue(), (StreakDTO)streaks.get(0));
            }
        }
        return null;
    }
}

