/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.category.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.category.request.GetCategoriesByIdsRequest;
import com.infinite.focus.server.category.request.GetCategoriesRequest;
import com.infinite.focus.server.category.service.CategoryService;
import com.infinite.focus.server.message.service.MessageService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/category"})
public class CategoryController {
    @Autowired
    CategoryService categoryService;
    @Autowired
    AuthService authService;
    @Autowired
    MessageService messageService;

    @PostMapping(value={"/get/categories"})
    public ResponseEntity<Page<CategoryDTO>> getCategories(@RequestHeader(value="Authorization") String token, @RequestBody GetCategoriesRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.categoryService.getCategories(request.getCategory_name(), request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy()), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/get/all/categories"})
    public ResponseEntity<List<CategoryDTO>> getAllCategories(@RequestHeader(value="Authorization") String token) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.categoryService.getAll(), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @GetMapping(value={"/get/category/{category_id}"})
    public ResponseEntity<CategoryDTO> getCategoryById(@PathVariable(value="category_id") Long category_id) {
        CategoryDTO categoryDTO = this.categoryService.getById(category_id.longValue());
        if (categoryDTO == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.category.not.found"));
        }
        return new ResponseEntity((Object)categoryDTO, HttpStatus.OK);
    }

    @PostMapping(value={"/create/category"})
    @ResponseBody
    public ResponseEntity<CategoryDTO> createCategory(@RequestHeader(value="Authorization") String token, @RequestBody CategoryDTO request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.categoryService.create(request.getCategory_name(), request.getCategory_name_es(), request.getStatus()), HttpStatus.OK);
    }

    @PostMapping(value={"/update/category"})
    @ResponseBody
    public ResponseEntity<CategoryDTO> updateCategory(@RequestHeader(value="Authorization") String token, @RequestBody CategoryDTO request) {
        this.authService.isAuthenticated(token);
        CategoryDTO categoryDTO = this.categoryService.getById(request.getCategory_id());
        if (categoryDTO == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.category.not.found"));
        }
        return new ResponseEntity((Object)this.categoryService.update(request.getCategory_id(), request.getCategory_name(), request.getCategory_name_es(), request.getStatus()), HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/category/{category_id}"})
    public ResponseEntity<Message> deleteCategory(@RequestHeader(value="Authorization") String token, @PathVariable(value="category_id") Long category_id) {
        this.authService.isAuthenticated(token);
        CategoryDTO categoryDTO = this.categoryService.getById(category_id.longValue());
        if (categoryDTO == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.category.not.found"));
        }
        this.categoryService.deleteById(category_id.longValue());
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("the.category.is.deleted.successfully"));
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/get-categories-by-ids"})
    public ResponseEntity<List<CategoryDTO>> getCategoriesByIds(@RequestBody GetCategoriesByIdsRequest request) {
        return new ResponseEntity((Object)this.categoryService.getCategoriesByIds(request.getIds()), HttpStatus.OK);
    }
}

