/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.configuration.service;

import com.infinite.focus.server.configuration.entity.Configuration;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.configuration.wrapper.StudentConfigurationWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    @Autowired
    ConfigurationRepository configurationRepository;

    public Configuration getConfiguration() {
        return this.configurationRepository.getConfiguration();
    }

    public String getStripeApiKey() {
        if (this.getConfiguration().isStripe_Live()) {
            return this.getConfiguration().getStripe_sec_key_live();
        }
        return this.getConfiguration().getStripe_sec_key_test();
    }

    public String getStripeSignature() {
        if (this.getConfiguration().isStripe_Live()) {
            return this.getConfiguration().getStripe_wh_sec_live();
        }
        return this.getConfiguration().getStripe_wh_sec_test();
    }

    public StudentConfigurationWrapper getForStudent() {
        Configuration configuration = this.configurationRepository.getConfiguration();
        return StudentConfigurationWrapper.builder().contact(configuration.getContact()).support(configuration.getSupport()).guidelines(configuration.getClymb_community_guidelines()).build();
    }
}

