/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.clever.service.student;

import com.infinite.focus.server.clever.model.CleverInstructor;
import com.infinite.focus.server.clever.model.CleverInstructorWrapper;
import com.infinite.focus.server.clever.model.CleverMeInfo;
import com.infinite.focus.server.clever.model.CleverParent;
import com.infinite.focus.server.clever.model.CleverParentWrapper;
import com.infinite.focus.server.clever.model.CleverSection;
import com.infinite.focus.server.clever.model.CleverSectionWrapper;
import com.infinite.focus.server.clever.model.CleverStudent;
import com.infinite.focus.server.clever.model.CleverStudentWrapper;
import com.infinite.focus.server.clever.model.CleverUser;
import com.infinite.focus.server.clever.response.GetCleverInstructorsResponse;
import com.infinite.focus.server.clever.response.GetCleverParentsResponse;
import com.infinite.focus.server.clever.response.GetCleverSectionsResponse;
import com.infinite.focus.server.clever.response.GetCleverStudentsResponse;
import com.infinite.focus.server.clever.response.GetStudentByIdResponse;
import com.infinite.focus.server.clever.response.GetStudentForCodeByIdResponse;
import com.infinite.focus.server.clever.service.student.CleverStudentApiService;
import com.infinite.focus.server.clever.service.student.CleverStudentService;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Service
public class CleverStudentServiceImpl
implements CleverStudentService {
    private CleverStudentApiService service;

    public CleverStudentServiceImpl() {
        OkHttpClient OClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.clever.com/v3.0/").client(OClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.service = (CleverStudentApiService)retrofit.create(CleverStudentApiService.class);
    }

    public CleverStudent getCleverStudentByCleverId(String access_token, String clever_id) {
        try {
            Call getStudentByIdResponseCall = this.service.getCleverStudentById("Bearer " + access_token, clever_id);
            Response response = getStudentByIdResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetStudentByIdResponse)response.body()).getData() != null) {
                return ((GetStudentByIdResponse)response.body()).getData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public CleverUser getCleverStudentByIdForCleverCode(String access_token, String id) {
        try {
            Call getStudentByIdResponseCall = this.service.getCleverStudentByIdForCode("Bearer " + access_token, id);
            Response response = getStudentByIdResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetStudentForCodeByIdResponse)response.body()).getData() != null) {
                return ((GetStudentForCodeByIdResponse)response.body()).getData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Set<CleverStudent> getCleverStudents(String access_token) {
        try {
            Call getStudentByIdResponseCall = this.service.getCleverStudents("Bearer " + access_token, "student");
            Response response = getStudentByIdResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverStudentsResponse)response.body()).getData() != null) {
                return ((GetCleverStudentsResponse)response.body()).getData().stream().map(CleverStudentWrapper::getData).collect(Collectors.toSet());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public LinkedHashSet<CleverParent> getCleverParentsByCleverStudent(String access_token, String clever_student_id) {
        try {
            Call getCleverParentsResponseCall = this.service.getCleverParentsForCleverStudent("Bearer " + access_token, clever_student_id);
            Response response = getCleverParentsResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverParentsResponse)response.body()).getData() != null) {
                return ((GetCleverParentsResponse)response.body()).getData().stream().map(CleverParentWrapper::getData).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public LinkedHashSet<CleverInstructor> getCleverInstructorsByCleverStudent(String access_token, String clever_student_id) {
        try {
            Call getCleverParentsResponseCall = this.service.getCleverInstructorsForCleverStudent("Bearer " + access_token, clever_student_id);
            Response response = getCleverParentsResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverInstructorsResponse)response.body()).getData() != null) {
                return ((GetCleverInstructorsResponse)response.body()).getData().stream().map(CleverInstructorWrapper::getData).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public CleverMeInfo getCleverMeInfo(String access_token) {
        try {
            Call getCleverMeInfoCall = this.service.getCleverMeInfo("Bearer " + access_token);
            Response response = getCleverMeInfoCall.execute();
            if (response.isSuccessful() && response.body() != null && ((CleverMeInfo)response.body()).getData() != null) {
                return (CleverMeInfo)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public LinkedHashSet<CleverSection> getCleverSectionsByCleverStudent(String access_token, String clever_student_id) {
        try {
            Call getCleverSectionsResponseCall = this.service.getCleverSectionsForCleverStudent("Bearer " + access_token, clever_student_id);
            Response response = getCleverSectionsResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverSectionsResponse)response.body()).getData() != null) {
                return ((GetCleverSectionsResponse)response.body()).getData().stream().map(CleverSectionWrapper::getData).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

