/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.socialawareness.repository;

import com.infinite.focus.server.assessment.model.AssessmentOccurrence;
import com.infinite.focus.server.data.model.OccurrenceAndOccurrenceAverage;
import com.infinite.focus.server.socialawareness.dto.SocialAwarenessUpdateDTO;
import com.infinite.focus.server.socialawareness.entity.SocialAwarenessUpdate;
import com.infinite.focus.server.socialawareness.repository.SocialAwarenessUpdateCriteriaRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class SocialAwarenessUpdateCriteriaRepositoryImpl
implements SocialAwarenessUpdateCriteriaRepository {
    @Autowired
    EntityManager entityManager;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static SocialAwarenessUpdateDTO mapRow(ResultSet rs, int i) throws SQLException {
        return SocialAwarenessUpdateDTO.builder().social_awareness_update_id(rs.getLong("social_awareness_update_id")).student_id(rs.getLong("student_id")).standard_id(rs.getLong("standard_id")).data_set_id(rs.getLong("data_set_id")).score(rs.getDouble("score")).text(rs.getString("text")).text_es(rs.getString("text_es")).createdAt((Date)rs.getTimestamp("created_at")).build();
    }

    public List<AssessmentOccurrence> getFriendshipAnalysisByStudentIdsAndBetweenFromDateAndToDate(List<Long> studentIds, Date fromDate, Date toDate) {
        if (AppUtils.isNullOrEmpty(studentIds)) {
            return this.mapToAssessmentOccurance(new ArrayList());
        }
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Tuple.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        Root rootSocialAwarenessUpdate = c.from(SocialAwarenessUpdate.class);
        predicates.add(qb.in((Expression)rootSocialAwarenessUpdate.get("student_id")).value(studentIds));
        predicates.add(qb.between((Expression)rootSocialAwarenessUpdate.get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        Expression occurrence = qb.coalesce(qb.count((Expression)rootSocialAwarenessUpdate), (Object)0);
        Expression quot = qb.coalesce(qb.quot(qb.count((Expression)rootSocialAwarenessUpdate.get("social_awareness_update_id")), (Number)studentIds.size()), (Object)0.0);
        Expression roundExpression = qb.function("round", Double.class, new Expression[]{quot, qb.literal((Object)2)});
        c.multiselect(new Selection[]{rootSocialAwarenessUpdate.get("text").alias("text_to_display"), rootSocialAwarenessUpdate.get("text_es").alias("text_to_display_es"), roundExpression.alias("count"), occurrence.alias("occurrence")}).where(predicates.toArray(new Predicate[0]));
        c.groupBy(new Expression[]{rootSocialAwarenessUpdate.get("data_set_id"), rootSocialAwarenessUpdate.get("text"), rootSocialAwarenessUpdate.get("text_es")});
        c.orderBy(new Order[]{qb.asc((Expression)rootSocialAwarenessUpdate.get("data_set_id"))});
        TypedQuery typedQuery = this.entityManager.createQuery(c);
        List list = typedQuery.getResultList().stream().map(tuple -> new AssessmentOccurrence(0L, (String)tuple.get("text_to_display"), (String)tuple.get("text_to_display_es"), ((Double)tuple.get("count")).doubleValue(), ((Long)tuple.get("occurrence")).longValue(), 0.0, null)).collect(Collectors.toList());
        return this.mapToAssessmentOccurance(list);
    }

    public List<SocialAwarenessUpdateDTO> findByStudentIdsAndBetweenFromDateAndToDate2(Set<Long> student_ids, Date fromDate, Date toDate) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return new ArrayList<SocialAwarenessUpdateDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        ArrayList<Long> args = new ArrayList<Long>(student_ids);
        args.add((Long)((Object)new Timestamp(fromDate.getTime())));
        args.add((Long)((Object)new Timestamp(toDate.getTime())));
        String SQL = "SELECT * FROM social_awareness_update so_up WHERE so_up.student_id IN(%S) AND so_up.created_at BETWEEN ? AND ? ORDER BY so_up.created_at DESC ";
        List socialAwarenessUpdateDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), args.toArray(), SocialAwarenessUpdateCriteriaRepositoryImpl::mapRow);
        return socialAwarenessUpdateDTOS;
    }

    public List<AssessmentOccurrence> mapToAssessmentOccurance(List<AssessmentOccurrence> list) {
        List textToDisplayList = this.getTextToDisplay();
        if (!AppUtils.isNullOrEmpty(list)) {
            for (AssessmentOccurrence a : textToDisplayList) {
                list.stream().filter(o -> o.getText_to_display().equals(a.getText_to_display()) && o.getText_to_display_es().equals(a.getText_to_display_es())).findFirst().ifPresent(o -> {
                    a.setCount(o.getCount());
                    a.setOccurrence(o.getOccurrence());
                });
            }
        }
        long totalOccurrence = textToDisplayList.stream().map(AssessmentOccurrence::getOccurrence).reduce(0L, Long::sum);
        return textToDisplayList.stream().peek(t -> t.setOccurrence_average(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)t.getOccurrence() / (double)totalOccurrence * 100.0)).doubleValue())).collect(Collectors.toList());
    }

    public List<AssessmentOccurrence> getTextToDisplay2() {
        String SQL = "SELECT data_set_id, text, text_es FROM social_awareness_update GROUP BY data_set_id, text, text_es ORDER BY data_set_id ASC ";
        List assessmentOccurrences = this.jdbcTemplate.query(SQL, (rs, i) -> AssessmentOccurrence.builder().text_to_display(rs.getString("text")).text_to_display_es(rs.getString("text_es")).mood_id(0L).count(0.0).occurrence(0L).occurrence_average(0.0).build());
        return assessmentOccurrences;
    }

    public List<AssessmentOccurrence> getTextToDisplay() {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Tuple.class);
        ArrayList predicates = new ArrayList();
        Root rootSocialAwarenessUpdate = c.from(SocialAwarenessUpdate.class);
        c.multiselect(new Selection[]{rootSocialAwarenessUpdate.get("text").alias("text_to_display"), rootSocialAwarenessUpdate.get("text_es").alias("text_to_display_es")}).where(predicates.toArray(new Predicate[0]));
        c.groupBy(new Expression[]{rootSocialAwarenessUpdate.get("data_set_id"), rootSocialAwarenessUpdate.get("text"), rootSocialAwarenessUpdate.get("text_es")});
        c.orderBy(new Order[]{qb.asc((Expression)rootSocialAwarenessUpdate.get("data_set_id"))});
        TypedQuery typedQuery = this.entityManager.createQuery(c);
        List<AssessmentOccurrence> list = typedQuery.getResultList().stream().map(tuple -> new AssessmentOccurrence(0L, (String)tuple.get("text_to_display"), (String)tuple.get("text_to_display_es"), 0.0, 0L, 0.0, null)).collect(Collectors.toList());
        return list;
    }

    public SocialAwarenessUpdateDTO findById(long social_awareness_update_id) {
        String SQL = "SELECT * FROM social_awareness_update WHERE social_awareness_update_id = ? ";
        try {
            return (SocialAwarenessUpdateDTO)this.jdbcTemplate.queryForObject(SQL, SocialAwarenessUpdateCriteriaRepositoryImpl::mapRow, new Object[]{social_awareness_update_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<OccurrenceAndOccurrenceAverage> getTextToDisplay3() {
        String SQL = "SELECT data_set_id, text, text_es FROM social_awareness_update GROUP BY data_set_id, text, text_es ORDER BY data_set_id ASC ";
        List occurrenceAndOccurrenceAverages = this.jdbcTemplate.query(SQL, (rs, i) -> OccurrenceAndOccurrenceAverage.builder().text_to_display(rs.getString("text")).text_to_display_es(rs.getString("text_es")).count(0.0).occurrence(0L).occurrence_average(0.0).build());
        return occurrenceAndOccurrenceAverages;
    }
}

