/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.moodupdate.controller;

import com.infinite.focus.server.compassdashboard.request.GetTravelLogForStudentRequest;
import com.infinite.focus.server.data.model.EmotionCountAndAverage;
import com.infinite.focus.server.data.model.EmotionsByStandards;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.mood.wrapper.MoodUpdateAndStreak;
import com.infinite.focus.server.moodupdate.dto.MoodUpdateDTO;
import com.infinite.focus.server.moodupdate.entity.MoodUpdate;
import com.infinite.focus.server.moodupdate.request.GetLastThreeMoodsByStudentIdRequest;
import com.infinite.focus.server.moodupdate.request.GetSelfAwarenessByIdRequest;
import com.infinite.focus.server.moodupdate.request.GetSelfAwarenessByStudentIdsRequest;
import com.infinite.focus.server.moodupdate.service.MoodUpdateService;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/mood-update"})
public class MoodUpdateController {
    private final MoodUpdateService moodUpdateService;
    private final MessageService messageService;

    public MoodUpdateController(MoodUpdateService moodUpdateService, MessageService messageService) {
        this.moodUpdateService = moodUpdateService;
        this.messageService = messageService;
    }

    @PostMapping(value={"/get-by-id"})
    ResponseEntity<MoodUpdateDTO> getById(@RequestBody GetSelfAwarenessByIdRequest request) {
        MoodUpdateDTO moodUpdateDTO = this.moodUpdateService.getById(request.getSelf_awareness_id());
        if (moodUpdateDTO == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.self.awareness.is.not.found"));
        }
        return new ResponseEntity((Object)moodUpdateDTO, HttpStatus.OK);
    }

    @PostMapping(value={"/get-last-three-moods-by-student-id"})
    ResponseEntity<Object> getLastThreeMoodsByStudentId(@RequestBody GetLastThreeMoodsByStudentIdRequest request) {
        return new ResponseEntity((Object)this.moodUpdateService.getLastThreeMoodsByStudentId(request.getStudent_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/review-update"})
    ResponseEntity<Void> reviewUpdate() {
        this.moodUpdateService.reviewUpdate();
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/apply-review-update"})
    ResponseEntity<Void> applyReviewUpdate() {
        this.moodUpdateService.applyReviewUpdate();
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/create"})
    ResponseEntity<MoodUpdateAndStreak> create(@RequestBody MoodUpdate request) {
        return new ResponseEntity((Object)this.moodUpdateService.create(request), HttpStatus.OK);
    }

    @PostMapping(value={"/get-self-awareness-by-student-ids"})
    ResponseEntity<List<EmotionCountAndAverage>> getSelfAwarenessByStudentIds(@RequestBody GetSelfAwarenessByStudentIdsRequest request) {
        return new ResponseEntity((Object)this.moodUpdateService.getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate(request.getStudent_ids(), request.getFromDate(), request.getToDate()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-self-awareness-by-student-ids-2"})
    ResponseEntity<EmotionsByStandards> getSelfAwarenessByStudentIds2(@RequestBody GetSelfAwarenessByStudentIdsRequest request) {
        return new ResponseEntity((Object)this.moodUpdateService.getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate2(request.getStudent_ids(), request.getFromDate(), request.getToDate()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-student-id"})
    ResponseEntity<Page<MoodUpdateDTO>> getByStudentId(@RequestHeader(value="Authorization") String token, @RequestBody GetTravelLogForStudentRequest getTravelLogForStudentRequest) {
        return new ResponseEntity((Object)this.moodUpdateService.getByStudentId(getTravelLogForStudentRequest.getStudent_id(), getTravelLogForStudentRequest.getPageNo(), getTravelLogForStudentRequest.getPageSize(), getTravelLogForStudentRequest.getSortBy(), getTravelLogForStudentRequest.getOrderBy()), HttpStatus.OK);
    }
}

