/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.clever.service.sync;

import com.infinite.focus.server.auth.service.ValidationService;
import com.infinite.focus.server.clever.service.district.CleverDistrictSyncService;
import com.infinite.focus.server.clever.service.school.CleverSchoolSyncService;
import com.infinite.focus.server.clever.service.sync.CleverSyncService;
import com.infinite.focus.server.district.repository.DistrictCoreRepository;
import com.infinite.focus.server.school.repository.SchoolCoreRepository;
import java.util.Iterator;
import java.util.List;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CleverSyncServiceImpl
implements CleverSyncService {
    private final DistrictCoreRepository districtCoreRepository;
    private final ValidationService validationService;
    private final CleverDistrictSyncService cleverDistrictSyncService;
    private final CleverSchoolSyncService cleverSchoolSyncService;
    private final SchoolCoreRepository schoolCoreRepository;

    public CleverSyncServiceImpl(DistrictCoreRepository districtCoreRepository, ValidationService validationService, CleverDistrictSyncService cleverDistrictSyncService, CleverSchoolSyncService cleverSchoolSyncService, SchoolCoreRepository schoolCoreRepository) {
        this.districtCoreRepository = districtCoreRepository;
        this.validationService = validationService;
        this.cleverDistrictSyncService = cleverDistrictSyncService;
        this.cleverSchoolSyncService = cleverSchoolSyncService;
        this.schoolCoreRepository = schoolCoreRepository;
    }

    @Async
    public void syncAll() {
        this.syncAllDistrict();
        this.syncAllSchool();
    }

    public void syncAllDistrict() {
        List district_ids = this.districtCoreRepository.findAllIdsFromClever();
        Iterator iterator = district_ids.iterator();
        while (iterator.hasNext()) {
            long district_id = (Long)iterator.next();
            try {
                if (!this.validationService.isValidDistrict(district_id).isValid()) continue;
                this.cleverDistrictSyncService.syncDistrictNonAsync(district_id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void syncAllSchool() {
        List school_ids = this.schoolCoreRepository.findAllIdsFromClever();
        Iterator iterator = school_ids.iterator();
        while (iterator.hasNext()) {
            long school_id = (Long)iterator.next();
            try {
                if (!this.validationService.isValidSchool(school_id).isValid()) continue;
                this.cleverSchoolSyncService.syncSchoolNonAsync(school_id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

