/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.wallpostrestriction.service;

import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.wallpost.dto.WallPostDTO;
import com.infinite.focus.server.wallpostrestriction.dto.WallPostRestrictionDTO;
import com.infinite.focus.server.wallpostrestriction.repository.WallPostRestrictionRepository;
import com.infinite.focus.server.wallpostrestriction.service.WallPostRestrictionService;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class WallPostRestrictionServiceImpl
implements WallPostRestrictionService {
    private final WallPostRestrictionRepository wallPostRestrictionRepository;
    private final RestComponent restComponent;

    public WallPostRestrictionServiceImpl(WallPostRestrictionRepository wallPostRestrictionRepository, RestComponent restComponent) {
        this.wallPostRestrictionRepository = wallPostRestrictionRepository;
        this.restComponent = restComponent;
    }

    public WallPostRestrictionDTO findById(long student_id) {
        return this.wallPostRestrictionRepository.findById(student_id);
    }

    public List<WallPostRestrictionDTO> findAll() {
        return this.wallPostRestrictionRepository.findAll();
    }

    public WallPostRestrictionDTO save(WallPostRestrictionDTO wallPostRestriction) {
        return this.wallPostRestrictionRepository.save(wallPostRestriction);
    }

    public void update(WallPostRestrictionDTO wallPostRestriction) {
        this.wallPostRestrictionRepository.update(wallPostRestriction);
    }

    public void deleteById(long student_id) {
        this.wallPostRestrictionRepository.deleteById(student_id);
    }

    public void incrementCount(long student_id) {
        WallPostRestrictionDTO restriction = this.wallPostRestrictionRepository.findById(student_id);
        if (restriction == null) {
            restriction = new WallPostRestrictionDTO();
            restriction.setStudent_id(student_id);
            restriction.setCount(1);
            restriction.setBlocked_until(new Date());
            this.wallPostRestrictionRepository.save(restriction);
        } else {
            if (new Date().before(restriction.getBlocked_until())) {
                return;
            }
            restriction.setCount(restriction.getCount() + 1);
            if (restriction.getCount() >= 3) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.add(5, 30);
                restriction.setBlocked_until(calendar.getTime());
            }
            this.wallPostRestrictionRepository.update(restriction);
        }
    }

    public boolean isBlocked(long student_id) {
        WallPostRestrictionDTO restriction = this.wallPostRestrictionRepository.findById(student_id);
        if (restriction == null) {
            return false;
        }
        WallPostDTO wallPost = this.restComponent.getLastWallPostByStudentId(student_id);
        if (wallPost != null) {
            Date comparisonDate;
            Date date = comparisonDate = wallPost.getDeleted_date() != null ? wallPost.getDeleted_date() : wallPost.getCreatedAt();
            if (comparisonDate.after(restriction.getBlocked_until()) && restriction.getCount() >= 3) {
                restriction.setCount(0);
                this.wallPostRestrictionRepository.update(restriction);
            }
        }
        return restriction.getCount() >= 3 || new Date().before(restriction.getBlocked_until());
    }
}

