/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.logging.helper;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpHeaders;

public class LoggingHelper {
    public static Map<String, String> getHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerMap = request.getHeaderNames();
        while (headerMap.hasMoreElements()) {
            String headerName = (String)headerMap.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    public static Map<String, String> getHeaders(HttpServletResponse response, HttpHeaders httpHeaders) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Collection headerMap = response.getHeaderNames();
        for (String str : headerMap) {
            headers.put(str, response.getHeader(str));
        }
        try {
            HashMap<String, String> http_headers = new HashMap<String, String>();
            for (String key : httpHeaders.keySet()) {
                http_headers.put(key, Objects.requireNonNull(httpHeaders.get((Object)key)).toString());
            }
            headers.put("httpHeaders", ((Object)http_headers).toString());
        }
        catch (Exception e) {
            headers.put("httpHeaders", e.getMessage());
        }
        return headers;
    }

    public static Map<String, String> getParameters(HttpServletRequest request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            String paramValue = request.getParameter(paramName);
            parameters.put(paramName, paramValue);
        }
        return parameters;
    }
}

