/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.test.controller;

import com.infinite.focus.server.answer.entity.Answer;
import com.infinite.focus.server.answer.repository.AnswerRepository;
import com.infinite.focus.server.correctanswer.entity.CorrectAnswer;
import com.infinite.focus.server.correctanswer.repository.CorrectAnswerRepository;
import com.infinite.focus.server.lesson.entity.Lesson;
import com.infinite.focus.server.lesson.repository.LessonRepository;
import com.infinite.focus.server.lessonrecord.entity.LessonRecord;
import com.infinite.focus.server.lessonrecord.repository.LessonRecordRepository;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.multiplechoiceoption.entity.MultipleChoiceOption;
import com.infinite.focus.server.multiplechoiceoption.repository.MultipleChoiceOptionRepository;
import com.infinite.focus.server.question.entity.Question;
import com.infinite.focus.server.question.repository.QuestionRepository;
import com.infinite.focus.server.socioemotionaltestanswer.entity.SocioEmotionalTestAnswer;
import com.infinite.focus.server.socioemotionaltestanswer.repository.SocioEmotionalTestAnswerRepository;
import com.infinite.focus.server.socioemotionaltestquestion.entity.SocioEmotionalTestQuestion;
import com.infinite.focus.server.socioemotionaltestquestion.repository.SocioEmotionalTestQuestionRepository;
import com.infinite.focus.server.socioemotionaltestquestionoption.entity.SocioEmotionalTestQuestionOption;
import com.infinite.focus.server.socioemotionaltestquestionoption.repository.SocioEmotionalTestQuestionOptionRepository;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.repository.SocioEmotionalTestResultRepository;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.studentstreak.service.selcheckpoint.StreakSELCheckpointService;
import com.infinite.focus.server.test.entity.Test;
import com.infinite.focus.server.test.repository.TestRepository;
import com.infinite.focus.server.test.response.SubmitSocioEmotionalTestResponse;
import com.infinite.focus.server.test.wrapper.QuestionDataWrapper;
import com.infinite.focus.server.test.wrapper.SocioEmotionalTestDataWrapper;
import com.infinite.focus.server.test.wrapper.SocioEmotionalTestResultWrapper;
import com.infinite.focus.server.test.wrapper.TestDataWrapper;
import com.infinite.focus.server.test.wrapper.TestResultDataWrapper;
import com.infinite.focus.server.testresult.entity.TestResult;
import com.infinite.focus.server.testresult.repository.TestResultRepository;
import com.infinite.focus.server.testresultgrade.entity.TestResultGrade;
import com.infinite.focus.server.testresultgrade.repository.TestResultGradeRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/test"})
public class TestController {
    @Autowired
    StreakSELCheckpointService streakSELCheckpointService;
    private StudentRepository studentRepository;
    private TestRepository testRepository;
    private QuestionRepository questionRepository;
    private CorrectAnswerRepository correctAnswerRepository;
    private MultipleChoiceOptionRepository multipleChoiceOptionRepository;
    private AnswerRepository answerRepository;
    private TestResultRepository testResultRepository;
    private TestResultGradeRepository testResultGradeRepository;
    private LessonRepository lessonRepository;
    private LessonRecordRepository lessonRecordRepository;
    private SocioEmotionalTestQuestionRepository socioEmotionalTestQuestionRepository;
    private SocioEmotionalTestQuestionOptionRepository socioEmotionalTestQuestionOptionRepository;
    private SocioEmotionalTestAnswerRepository socioEmotionalTestAnswerRepository;
    private SocioEmotionalTestResultRepository socioEmotionalTestResultRepository;
    @Autowired
    MessageService messageService;

    public TestController(LessonRecordRepository lessonRecordRepository, SocioEmotionalTestResultRepository socioEmotionalTestResultRepository, SocioEmotionalTestAnswerRepository socioEmotionalTestAnswerRepository, SocioEmotionalTestQuestionRepository socioEmotionalTestQuestionRepository, SocioEmotionalTestQuestionOptionRepository socioEmotionalTestQuestionOptionRepository, LessonRepository lessonRepository, TestResultGradeRepository testResultGradeRepository, TestResultRepository testResultRepository, AnswerRepository answerRepository, TestRepository testRepository, QuestionRepository questionRepository, CorrectAnswerRepository correctAnswerRepository, MultipleChoiceOptionRepository multipleChoiceOptionRepository, StudentRepository studentRepository) {
        this.lessonRecordRepository = lessonRecordRepository;
        this.socioEmotionalTestQuestionRepository = socioEmotionalTestQuestionRepository;
        this.socioEmotionalTestQuestionOptionRepository = socioEmotionalTestQuestionOptionRepository;
        this.socioEmotionalTestAnswerRepository = socioEmotionalTestAnswerRepository;
        this.socioEmotionalTestResultRepository = socioEmotionalTestResultRepository;
        this.testResultRepository = testResultRepository;
        this.answerRepository = answerRepository;
        this.testRepository = testRepository;
        this.lessonRepository = lessonRepository;
        this.questionRepository = questionRepository;
        this.correctAnswerRepository = correctAnswerRepository;
        this.multipleChoiceOptionRepository = multipleChoiceOptionRepository;
        this.testResultGradeRepository = testResultGradeRepository;
        this.studentRepository = studentRepository;
    }

    @GetMapping(value={"/get/test"})
    public ResponseEntity<TestDataWrapper> getTest(@RequestParam(value="lesson_id", defaultValue="aEn24") Long lesson_id) {
        TestDataWrapper data = new TestDataWrapper();
        Lesson l = (Lesson)this.lessonRepository.getOne((Object)lesson_id);
        if (l == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        if (l.getTest_id() == 0L) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.test.is.not.found"));
        }
        Test test = (Test)this.testRepository.getOne((Object)l.getTest_id());
        if (test == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        data.setTest(test);
        List questions = this.questionRepository.findByTestId(Long.valueOf(l.getTest_id()));
        for (Question q : questions) {
            QuestionDataWrapper qdw = new QuestionDataWrapper();
            qdw.setQuestion(q);
            if (test.getIsGraded().booleanValue() && this.correctAnswerRepository.findByQuestionId(Long.valueOf(q.getQuestion_id())) != null) {
                qdw.setCorrectAnswer(this.correctAnswerRepository.findByQuestionId(Long.valueOf(q.getQuestion_id())));
                if (q.getQuestion_type().equals("multiple")) {
                    qdw.setOptions(this.multipleChoiceOptionRepository.findByQuestionId(Long.valueOf(q.getQuestion_id())));
                }
            }
            data.questions.add(qdw);
        }
        return new ResponseEntity((Object)data, HttpStatus.OK);
    }

    @GetMapping(value={"/get/socio/emotional/test"})
    public ResponseEntity<SocioEmotionalTestDataWrapper> getSocioEmotionalTest() {
        SocioEmotionalTestDataWrapper s = new SocioEmotionalTestDataWrapper();
        s.setOptions(this.socioEmotionalTestQuestionOptionRepository.findAll());
        s.setQuestions(this.socioEmotionalTestQuestionRepository.findAll());
        return new ResponseEntity((Object)s, HttpStatus.OK);
    }

    @GetMapping(value={"/check/socio/emotional/test"})
    public ResponseEntity<Lesson> checkSocioEmotionalTest(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        Student student = (Student)this.studentRepository.getOne((Object)student_id);
        if (student == null) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        SocioEmotionalTestResult t = this.socioEmotionalTestResultRepository.findMostRecentByStudentId(student_id);
        if (t == null) {
            return new ResponseEntity((Object)new Lesson(), HttpStatus.OK);
        }
        ArrayList<Lesson> completedLessons = new ArrayList<Lesson>();
        List allLessons = this.lessonRepository.findByGradeId(Long.valueOf(student.getStandard().getGrade_id()));
        for (LessonRecord l : this.lessonRecordRepository.findByStudentId(Long.valueOf(student.getStudent_id()))) {
            Lesson _l = (Lesson)this.lessonRepository.getOne((Object)l.getLesson_id());
            if (_l == null) continue;
            completedLessons.add(_l);
        }
        int highest_lesson_completed = 1;
        for (Lesson l : completedLessons) {
            if (l.getLesson_index() <= highest_lesson_completed) continue;
            highest_lesson_completed = l.getLesson_index();
        }
        if (highest_lesson_completed % 30 == 0) {
            for (Lesson l : allLessons) {
                if (l.getLesson_index() != highest_lesson_completed) continue;
                if (l.getLesson_id() == t.getLast_completed_lesson_id()) {
                    return new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                return new ResponseEntity((Object)new Lesson(), HttpStatus.OK);
            }
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/submit/socio/emotional/test"})
    @ResponseBody
    public ResponseEntity<SubmitSocioEmotionalTestResponse> submitTest(@RequestBody SocioEmotionalTestResultWrapper request) {
        Student student = this.studentRepository.findByStudentId(request.getStudent_id());
        if (student == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        int total_score = 0;
        for (SocioEmotionalTestAnswer a : request.getAnswers()) {
            SocioEmotionalTestQuestion q = (SocioEmotionalTestQuestion)this.socioEmotionalTestQuestionRepository.getOne((Object)a.getSocio_emotional_test_question_id());
            if (q == null) {
                // empty if block
            }
            SocioEmotionalTestQuestionOption o = (SocioEmotionalTestQuestionOption)this.socioEmotionalTestQuestionOptionRepository.getOne((Object)a.getSocio_emotional_test_question_option_id());
            if (q.isReversed()) {
                total_score += o.getReverse_weight();
                continue;
            }
            total_score += o.getWeight();
        }
        ArrayList<Lesson> completedLessons = new ArrayList<Lesson>();
        List allLessons = this.lessonRepository.findByGradeId(Long.valueOf(student.getStandard().getGrade_id()));
        for (Object l : this.lessonRecordRepository.findByStudentId(Long.valueOf(student.getStudent_id()))) {
            Lesson lesson = (Lesson)this.lessonRepository.getOne((Object)l.getLesson_id());
            if (lesson == null) continue;
            completedLessons.add(lesson);
        }
        int highest_lesson_completed = 1;
        for (Lesson lesson : completedLessons) {
            if (lesson.getLesson_index() <= highest_lesson_completed) continue;
            highest_lesson_completed = lesson.getLesson_index();
        }
        SocioEmotionalTestResult t = new SocioEmotionalTestResult();
        for (Lesson l : allLessons) {
            if (l.getLesson_index() != highest_lesson_completed) continue;
            t.setLast_completed_lesson_id(l.getLesson_id());
        }
        t.setStudent_id(request.getStudent_id().longValue());
        t.setScore(total_score);
        if (student.isDemo()) {
            long l = this.socioEmotionalTestResultRepository.findLastRecordId() + 1L;
            t.setSocio_emotional_test_result_id(l);
            t.setCreatedAt(new Date());
        } else {
            t = (SocioEmotionalTestResult)this.socioEmotionalTestResultRepository.save((Object)t);
        }
        for (SocioEmotionalTestAnswer a : request.getAnswers()) {
            a.setSocio_emotional_test_result_id(t.getSocio_emotional_test_result_id());
            if (student.isDemo()) continue;
            this.socioEmotionalTestAnswerRepository.save((Object)a);
        }
        student.setShould_auto_show_assessment(false);
        student.setShould_force_socio_emotional_assessment(false);
        this.studentRepository.save((Object)student);
        SubmitSocioEmotionalTestResponse submitSocioEmotionalTestResponse = new SubmitSocioEmotionalTestResponse();
        submitSocioEmotionalTestResponse.setSocio_emotional_test_result(t);
        StreakDTO streak = this.streakSELCheckpointService.addStreakSELCheckpoint(student.getStudent_id());
        submitSocioEmotionalTestResponse.setStreak(streak);
        return new ResponseEntity((Object)submitSocioEmotionalTestResponse, HttpStatus.OK);
    }

    @PostMapping(value={"/create/question"})
    @ResponseBody
    public ResponseEntity<SocioEmotionalTestQuestion> createQuestion(@RequestBody SocioEmotionalTestQuestion request) {
        return new ResponseEntity(this.socioEmotionalTestQuestionRepository.save((Object)request), HttpStatus.OK);
    }

    @PostMapping(value={"/submit/test"})
    @ResponseBody
    public ResponseEntity<TestResultGrade> submitTest(@RequestBody TestResultDataWrapper request) {
        Test test = (Test)this.testRepository.getOne((Object)request.getTest_id());
        if (test == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        TestResult tr = this.testResultRepository.findMostRecentByStudent(Long.valueOf(test.getTest_id()), Long.valueOf(request.getStudent_id()));
        if (tr == null) {
            tr = new TestResult();
        }
        tr.setTest_id(test.getTest_id());
        tr.setStudent_id(request.getStudent_id());
        tr.setCreatedAt(new Date());
        TestResult testResult = (TestResult)this.testResultRepository.save((Object)tr);
        int total_question_count = this.questionRepository.findByTestId(Long.valueOf(test.getTest_id())).size();
        int correct_answer_count = 0;
        for (Answer a : request.getAnswers()) {
            Answer answer = this.answerRepository.findByTestResultIdAndQuestionId(Long.valueOf(testResult.getTest_result_id()), Long.valueOf(a.getQuestion_id()));
            if (answer != null) {
                a.setAnswer_id(answer.getAnswer_id());
            }
            a.setTest_result_id(testResult.getTest_result_id());
            this.answerRepository.save((Object)a);
            CorrectAnswer c = this.correctAnswerRepository.findByQuestionId(Long.valueOf(a.getQuestion_id()));
            if (c == null) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            if (!a.getAnswer_text().toLowerCase().trim().equals(c.getCorrect_answer_text().toLowerCase().trim())) continue;
            ++correct_answer_count;
        }
        float grade = 0.0f;
        grade = correct_answer_count > 0 ? (float)correct_answer_count / (float)total_question_count : 0.0f;
        TestResultGrade testResultGrade = this.testResultGradeRepository.findByTestResultId(Long.valueOf(testResult.getTest_result_id()));
        if (testResultGrade == null) {
            testResultGrade = new TestResultGrade();
        }
        testResultGrade.setGrade(grade);
        testResultGrade.setTest_result_id(testResult.getTest_result_id());
        TestResultGrade result = (TestResultGrade)this.testResultGradeRepository.save((Object)testResultGrade);
        LessonRecord l = this.lessonRecordRepository.findByStudentIdAndLessonId(Long.valueOf(request.getStudent_id()), Long.valueOf(request.getLesson_id()));
        if (l == null) {
            l = new LessonRecord();
        }
        l.setStudent_id(request.getStudent_id());
        l.setLesson_id(request.getLesson_id());
        l.setCreatedAt(new Date());
        this.lessonRecordRepository.save((Object)l);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @PostMapping(value={"/create/test"})
    @ResponseBody
    public ResponseEntity<Test> createTest(@RequestBody TestDataWrapper request) {
        Test test = (Test)this.testRepository.save((Object)request.getTest());
        if (this.lessonRepository.existsById((Object)request.getLesson_id())) {
            Lesson lesson = (Lesson)this.lessonRepository.getOne((Object)request.getLesson_id());
            lesson.setTest_id(test.getTest_id());
            this.lessonRepository.save((Object)lesson);
        }
        for (QuestionDataWrapper q : request.questions) {
            q.getQuestion().setTest_id(test.getTest_id());
            Question question = (Question)this.questionRepository.save((Object)q.getQuestion());
            q.getCorrectAnswer().setQuestion_id(question.getQuestion_id());
            this.correctAnswerRepository.save((Object)q.getCorrectAnswer());
            for (MultipleChoiceOption o : q.getOptions()) {
                o.setQuestion_id(question.getQuestion_id());
                this.multipleChoiceOptionRepository.save((Object)o);
            }
        }
        return new ResponseEntity((Object)test, HttpStatus.OK);
    }

    @PostMapping(value={"/update/test"})
    @ResponseBody
    public ResponseEntity<Test> updateTest(@RequestBody TestDataWrapper request) {
        Test test = (Test)this.testRepository.save((Object)request.getTest());
        for (Question q : this.questionRepository.findByTestId(Long.valueOf(test.getTest_id()))) {
            this.correctAnswerRepository.delete((Object)this.correctAnswerRepository.findByQuestionId(Long.valueOf(q.getQuestion_id())));
            this.multipleChoiceOptionRepository.deleteAll((Iterable)this.multipleChoiceOptionRepository.findByQuestionId(Long.valueOf(q.getQuestion_id())));
            this.questionRepository.delete((Object)q);
        }
        for (Question q : request.questions) {
            q.getQuestion().setTest_id(test.getTest_id());
            Question question = (Question)this.questionRepository.save((Object)q.getQuestion());
            q.getCorrectAnswer().setQuestion_id(question.getQuestion_id());
            this.correctAnswerRepository.save((Object)q.getCorrectAnswer());
            for (MultipleChoiceOption o : q.getOptions()) {
                o.setQuestion_id(question.getQuestion_id());
                this.multipleChoiceOptionRepository.save((Object)o);
            }
        }
        return new ResponseEntity((Object)test, HttpStatus.OK);
    }

    @GetMapping(value={"/delete/test"})
    public ResponseEntity<Test> deleteTest(@RequestParam(value="test_id", defaultValue="aEn24") Long test_id) {
        Test test = (Test)this.testRepository.getOne((Object)test_id);
        if (test == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.testRepository.deleteById((Object)test_id);
        for (Question q : this.questionRepository.findByTestId(test_id)) {
            this.correctAnswerRepository.delete((Object)this.correctAnswerRepository.findByQuestionId(Long.valueOf(q.question_id)));
            this.multipleChoiceOptionRepository.deleteAll((Iterable)this.multipleChoiceOptionRepository.findByQuestionId(Long.valueOf(q.getQuestion_id())));
            this.questionRepository.deleteById((Object)q.getQuestion_id());
        }
        return new ResponseEntity((Object)new Test(), HttpStatus.OK);
    }
}

