/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.instructor.service;

import com.infinite.focus.server.account.response.GetEmailByAccountIdResponse;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.instructor.dto.InstructorDTO;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorCriteriaRepository;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.instructor.view.InstructorView;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class InstructorServiceImpl
implements InstructorService {
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    private InstructorCriteriaRepository instructorCriteriaRepository;
    @Autowired
    StudentService studentService;
    @Autowired
    ActivityService activityService;
    @Autowired
    MessageService messageService;
    @Autowired
    private RestComponent restComponent;

    public InstructorDTO getById(long id) {
        return this.instructorCriteriaRepository.findById(id);
    }

    public Instructor getInstructorById(long instructor_id) {
        return this.instructorRepository.findByInstructorId(Long.valueOf(instructor_id));
    }

    public Instructor getInstructorByAccountId(long account_id) {
        return this.instructorRepository.findByAccountId(Long.valueOf(account_id));
    }

    public List<Instructor> getInstructorsBySchoolId(long school_id) {
        return this.instructorRepository.findBySchoolId(Long.valueOf(school_id));
    }

    public List<Long> getInstructorIdsBySchoolId(long school_id) {
        return this.instructorRepository.findInstructorIdsBySchoolIdOrderByInstructorIdASC(Long.valueOf(school_id));
    }

    public long getStudentsCountByInstructorId(long school_id) {
        List instructors = this.getInstructorsBySchoolId(school_id);
        long count = 0L;
        for (Instructor instructor : instructors) {
            count += this.studentService.getStudentsCountByInstructorId(instructor.getInstructor_id());
        }
        return count;
    }

    public List<BigInteger> findInstructorIdsBySchoolId(long school_id) {
        return this.instructorRepository.findInstructorIdsBySchoolId(school_id);
    }

    public List<BigInteger> findInstructorIdsWhereInstructorNameLikeAndBySchoolId(String instructor_name, long school_id) {
        return this.instructorRepository.findInstructorIdsWhereInstructorNameLikeAndBySchoolId(instructor_name, school_id);
    }

    public String outOfStudentWhoLoggedBetween(long instructor_id, Date fromDate, Date toDate, TimeZone timeZone) {
        List studentIds = this.studentService.getStudentIdsByInstructorId(instructor_id);
        if (AppUtils.isNullOrEmpty((List)studentIds)) {
            return this.messageService.getMessage().getNumber_of_students_who_did_clymb().replace("<out_of>", "0").replace("<total>", "0");
        }
        List activities = this.activityService.getLoggedInStudentsByStudentIdsBetweenFromDateAndToDateAndBetweenFromTimeAndToTime(studentIds, DateUtils.yearMonthDateHoursMinutesSecondsUTC.format(fromDate), DateUtils.yearMonthDateHoursMinutesSecondsUTC.format(toDate), timeZone);
        return this.messageService.getMessage().getNumber_of_students_who_did_clymb().replace("<out_of>", activities.size() + "").replace("<total>", studentIds.size() + "");
    }

    public List<Instructor> findBySchoolId(long school_id) {
        return this.instructorRepository.findBySchoolId(Long.valueOf(school_id));
    }

    public Instructor isValidInstructor(long instructor_id) {
        Instructor instructor = this.getInstructorById(instructor_id);
        if (instructor == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("instructor.is.not.found"));
        }
        return instructor;
    }

    public Instructor setOperatingSystemAndBrowser(long instructor_id, String operating_system, String browser) {
        Instructor instructor = this.getInstructorById(instructor_id);
        if (instructor == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("instructor.is.not.found"));
        }
        instructor.setOperating_system(operating_system);
        instructor.setBrowser(browser);
        return (Instructor)this.instructorRepository.save((Object)instructor);
    }

    public Instructor getInstructorByRegistrationCode(String registration_code) {
        return this.instructorRepository.findByRegistrationCode(registration_code);
    }

    public Instructor save(Instructor instructor) {
        return (Instructor)this.instructorRepository.save((Object)instructor);
    }

    public List<Instructor> saveAll(List<Instructor> instructor) {
        return this.instructorRepository.saveAll(instructor);
    }

    public String generateRegistrationCodeForInstructor() {
        String registration_code = null;
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = "I" + KeyGenerator.generateUniqueAuthCode();
            Instructor x = this.instructorRepository.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                registration_code = possible_code;
                continue;
            }
            isUnique = false;
        }
        return registration_code;
    }

    public Instructor getInstructorsByCleverId(String clever_id) {
        return this.instructorRepository.findByCleverId(clever_id);
    }

    public List<Instructor> getInstructorsByCleverIds(List<String> clever_ids) {
        return this.instructorRepository.findByCleverIds(clever_ids);
    }

    public List<InstructorView> getInstructorsOrderByInstructorIdAsc() {
        return this.instructorRepository.findAllInstructorIdOrderById();
    }

    public String getInstructorEmailByInstructorId(long instructor_id) {
        Instructor instructor = this.instructorRepository.findByInstructorId(Long.valueOf(instructor_id));
        GetEmailByAccountIdResponse getEmailByAccountIdResponse = this.restComponent.getEmailByAccountId(instructor.getAccount_id());
        return getEmailByAccountIdResponse.getEmail();
    }

    public void setNewNotificationsForInstructor(long instructor_id, boolean new_notifications) {
        this.instructorCriteriaRepository.updateNewNotificationsById(instructor_id, new_notifications);
    }
}

