/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.twilio.config;

import com.infinite.focus.server.twilio.config.TwilioConfiguration;
import com.infinite.focus.server.twilio.request.SmsRequest;
import com.twilio.rest.api.v2010.account.Message;
import com.twilio.rest.api.v2010.account.MessageCreator;
import com.twilio.type.PhoneNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="twilio")
public class TwilioSmsSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(TwilioSmsSender.class);
    @Autowired
    TwilioConfiguration twilioConfiguration;

    @Async
    public void sendSms(SmsRequest smsRequest) {
        if (!this.isPhoneNumberValid(smsRequest.getPhoneNumber())) {
            throw new IllegalArgumentException("Phone number [" + smsRequest.getPhoneNumber() + "] is not a valid number");
        }
        PhoneNumber to = new PhoneNumber(smsRequest.getPhoneNumber());
        PhoneNumber from = new PhoneNumber(this.twilioConfiguration.getTrialNumber());
        String message = smsRequest.getMessage();
        MessageCreator creator = Message.creator((PhoneNumber)to, (PhoneNumber)from, (String)message);
        creator.create();
        LOGGER.info("Send sms {}", (Object)smsRequest);
    }

    private boolean isPhoneNumberValid(String phoneNumber) {
        return true;
    }
}

