/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dataset.controller;

import com.infinite.focus.server.dataset.request.GetPVStatesByDataSetIdsRequest;
import com.infinite.focus.server.dataset.service.DataSetService;
import com.infinite.focus.server.dataset.wrapper.RelationshipSkillsWrapper;
import com.infinite.focus.server.dataset.wrapper.ResponsibleDecisionMakingWrapper;
import com.infinite.focus.server.dataset.wrapper.SelfManagementWrapper;
import com.infinite.focus.server.pvstate.model.PVState;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/data-set"})
public class DataSetController {
    private final DataSetService dataSetService;

    public DataSetController(DataSetService dataSetService) {
        this.dataSetService = dataSetService;
    }

    @PostMapping(value={"/get-pv-states-by-ids"})
    ResponseEntity<List<PVState>> getPVStatesByDataSetIds(@RequestBody GetPVStatesByDataSetIdsRequest request) {
        return new ResponseEntity((Object)this.dataSetService.getPVStatesByDataSetIds(request.getData_set_ids()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-all-responsible-decision-making"})
    ResponseEntity<List<ResponsibleDecisionMakingWrapper>> getAllResponsibleDecisionMaking(@RequestHeader(value="Authorization") String token) {
        return new ResponseEntity(this.dataSetService.getAllResponsibleDecisionMaking().stream().map(d -> ResponsibleDecisionMakingWrapper.builder().data_set_id(d.getData_set_id()).title(d.getTitle()).title_es(d.getTitle_es()).text_to_display(d.getText_to_display()).text_to_display_es(d.getText_to_display_es()).image(d.getImage()).resource_library_category_id(d.getResource_library_category_id()).build()).collect(Collectors.toList()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-all-self-management"})
    ResponseEntity<List<SelfManagementWrapper>> getAllSelfManagement(@RequestHeader(value="Authorization") String token) {
        return new ResponseEntity(this.dataSetService.getAllSelfManagement().stream().map(d -> SelfManagementWrapper.builder().data_set_id(d.getData_set_id()).title(d.getTitle()).title_es(d.getTitle_es()).sub_title(d.getSub_title()).sub_title_es(d.getSub_title_es()).text_to_display(d.getText_to_display()).text_to_display_es(d.getText_to_display_es()).color(d.getColor()).image(d.getImage()).resource_library_category_id(d.getResource_library_category_id()).build()).collect(Collectors.toList()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-all-social-awareness"})
    ResponseEntity<List<SelfManagementWrapper>> getAllSocialAwareness(@RequestHeader(value="Authorization") String token) {
        return new ResponseEntity(this.dataSetService.getAllSocialAwareness().stream().map(d -> SelfManagementWrapper.builder().data_set_id(d.getData_set_id()).title(d.getTitle()).title_es(d.getTitle_es()).sub_title(d.getSub_title()).sub_title_es(d.getSub_title_es()).text_to_display(d.getText_to_display()).text_to_display_es(d.getText_to_display_es()).color(d.getColor()).image(d.getImage()).resource_library_category_id(d.getResource_library_category_id()).build()).collect(Collectors.toList()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-all-relationship-skills"})
    ResponseEntity<List<RelationshipSkillsWrapper>> getAllRelationshipSkills(@RequestHeader(value="Authorization") String token) {
        return new ResponseEntity(this.dataSetService.getAllRelationshipSkills().stream().map(d -> RelationshipSkillsWrapper.builder().data_set_id(d.getData_set_id()).assessment_category(d.getAssessment_category()).assessment_category_name(d.getAssessment_category_name()).assessment_category_name_es(d.getAssessment_category_name_es()).assessment_child_category(d.getAssessment_child_category()).assessment_child_category_name(d.getAssessment_child_category_name()).assessment_child_category_name_es(d.getAssessment_child_category_name_es()).title(d.getTitle()).title_es(d.getTitle_es()).text_to_display(d.getText_to_display()).text_to_display_es(d.getText_to_display_es()).color(d.getColor()).image(d.getImage()).resource_library_category_id(d.getResource_library_category_id()).build()).collect(Collectors.toList()), HttpStatus.OK);
    }
}

