/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.post.service;

import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.content.dto.ContentDTO;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.model.PostType;
import com.infinite.focus.server.post.repository.PageImplStreak;
import com.infinite.focus.server.post.repository.PostRepository;
import com.infinite.focus.server.post.service.PostService;
import com.infinite.focus.server.post.wrapper.PostCategoryListAndCategoryListWrapper;
import com.infinite.focus.server.post.wrapper.PostContentListAndContentListWrapper;
import com.infinite.focus.server.post.wrapper.PostMoodListAndMoodListWrapper;
import com.infinite.focus.server.post.wrapper.PostStandardListAndStandardListWrapper;
import com.infinite.focus.server.post.wrapper.PostWrapper;
import com.infinite.focus.server.postcategory.dto.PostCategoryDTO;
import com.infinite.focus.server.postcontent.dto.PostContentDTO;
import com.infinite.focus.server.postmood.dto.PostMoodDTO;
import com.infinite.focus.server.poststandard.dto.PostStandardDTO;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.standard.dto.StandardDTO;
import com.infinite.focus.server.studentstreak.service.resourcelibrary.StreakResourceLibraryService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.vimeo.model.VimeoVideoDetailsoEmbed;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PostServiceImpl
implements PostService {
    private final PostRepository postRepository;
    private final StreakResourceLibraryService streakResourceLibraryService;
    private final RestComponent restComponent;

    public PostServiceImpl(PostRepository postRepository, StreakResourceLibraryService streakResourceLibraryService, RestComponent restComponent) {
        this.postRepository = postRepository;
        this.streakResourceLibraryService = streakResourceLibraryService;
        this.restComponent = restComponent;
    }

    public Set<Long> getPostIdsByStandardId(long standard_id) {
        HashSet<Long> standard_ids = new HashSet<Long>();
        standard_ids.add(standard_id);
        return this.restComponent.getPostIdsByStandardIds(standard_ids);
    }

    public Set<Long> getPostIdsByCategoryId(long category_id) {
        HashSet<Long> category_ids = new HashSet<Long>();
        category_ids.add(category_id);
        return this.restComponent.getPostIdsByCategoryIds(category_ids);
    }

    public List<PostDTO> get3RandomPost(long standard_id) {
        return this.postRepository.get3RandomPostByIds(this.getPostIdsByStandardId(standard_id));
    }

    public List<PostDTO> get3RandomPostByCategories(long standard_id, Set<Long> category_ids) {
        Set postIdsByStandardId = this.getPostIdsByStandardId(standard_id);
        Set postIdsByCategoryIds = this.restComponent.getPostIdsByCategoryIds(category_ids).stream().filter(postIdsByStandardId::contains).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        return this.postRepository.get3RandomPostByIds(postIdsByCategoryIds);
    }

    public List<PostDTO> get3RandomPostByCategoryId(long standard_id, long category_id) {
        Set postIdsByStandardId = this.getPostIdsByStandardId(standard_id);
        Set postIdsByCategoryId = this.getPostIdsByCategoryId(category_id).stream().filter(postIdsByStandardId::contains).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        return this.postRepository.get3RandomPostByIds(postIdsByCategoryId);
    }

    public PostDTO findByPostId(long post_id) {
        return this.postRepository.findById(post_id);
    }

    @Async
    public void deletePostsByIds(Set<Long> post_ids) {
        this.postRepository.deleteByIds(post_ids);
    }

    @Async
    public void deleteAllPosts() {
        this.postRepository.deleteAll();
    }

    public PostDTO create(PostType post_type, String post_title, String post_title_es, String post_description, String post_description_es, String post_cover_image_url, String post_cover_image_url_es, String post_video_url, String post_video_url_es, Set<Long> category_ids, Set<Long> content_ids, Set<Long> mood_ids, Set<Long> standard_ids) {
        return this.update(0L, post_type, post_title, post_title_es, post_description, post_description_es, post_cover_image_url, post_cover_image_url_es, post_video_url, post_video_url_es, category_ids, content_ids, mood_ids, standard_ids);
    }

    public PostDTO update(long post_id, PostType post_type, String post_title, String post_title_es, String post_description, String post_description_es, String post_cover_image_url, String post_cover_image_url_es, String post_video_url, String post_video_url_es, Set<Long> category_ids, Set<Long> content_ids, Set<Long> mood_ids, Set<Long> standard_ids) {
        Long post_duration = null;
        String oEmbed_html = null;
        if (post_type.equals((Object)PostType.VIDEO) && AppUtils.isNotNullOrEmpty((String)post_video_url)) {
            VimeoVideoDetailsoEmbed vimeoVideoDetailsoEmbed = this.restComponent.getVimeoVideoDetailsoEmbedByVideoUrl(post_video_url = post_video_url.trim());
            if (vimeoVideoDetailsoEmbed != null) {
                post_cover_image_url = vimeoVideoDetailsoEmbed.getThumbnail_url();
                post_duration = vimeoVideoDetailsoEmbed.getDuration();
                oEmbed_html = vimeoVideoDetailsoEmbed.getHtml();
            } else {
                post_cover_image_url = null;
            }
        } else {
            post_video_url = null;
        }
        Long post_duration_es = null;
        String oEmbed_html_es = null;
        if (post_type.equals((Object)PostType.VIDEO) && AppUtils.isNotNullOrEmpty((String)post_video_url_es)) {
            VimeoVideoDetailsoEmbed vimeoVideoDetailsoEmbed_es = this.restComponent.getVimeoVideoDetailsoEmbedByVideoUrl(post_video_url_es = post_video_url_es.trim());
            if (vimeoVideoDetailsoEmbed_es != null) {
                post_cover_image_url_es = vimeoVideoDetailsoEmbed_es.getThumbnail_url();
                post_duration_es = vimeoVideoDetailsoEmbed_es.getDuration();
                oEmbed_html_es = vimeoVideoDetailsoEmbed_es.getHtml();
            } else {
                post_cover_image_url_es = null;
            }
        } else {
            post_video_url_es = null;
        }
        PostDTO postDTO = null;
        postDTO = post_id > 0L ? this.postRepository.update(post_id, post_type, post_title, post_title_es, post_description, post_description_es, post_cover_image_url, post_cover_image_url_es, post_video_url, post_video_url_es, post_duration, post_duration_es, oEmbed_html, oEmbed_html_es) : this.postRepository.create(post_type, post_title, post_title_es, post_description, post_description_es, post_cover_image_url, post_cover_image_url_es, post_video_url, post_video_url_es, post_duration, post_duration_es, oEmbed_html, oEmbed_html_es);
        List postAndCategoryDTOS = this.restComponent.setPostAndCategories(postDTO.getPost_id(), category_ids);
        List postAndContentDTOS = this.restComponent.setPostAndContents(postDTO.getPost_id(), content_ids);
        List postAndMoodDTOS = this.restComponent.setPostAndMoods(postDTO.getPost_id(), mood_ids);
        List postAndStandardDTOS = this.restComponent.setPostAndStandards(postDTO.getPost_id(), standard_ids);
        return postDTO;
    }

    public Page<PostDTO> getPosts(long student_id, String post_title, Set<String> post_types, Set<Long> category_ids, Set<Long> content_ids, Set<Long> mood_ids, Set<Long> standard_ids, boolean showOnlyFavorites, Set<Long> last_post_ids, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        Set<Long> postIdsByCategoryIds = new HashSet();
        if (!AppUtils.isNullOrEmpty(category_ids) && AppUtils.isNullOrEmpty(postIdsByCategoryIds = this.restComponent.getPostIdsByCategoryIds(category_ids))) {
            postIdsByCategoryIds.add(-1L);
        }
        Set<Long> postIdsByContentIds = new HashSet();
        if (!AppUtils.isNullOrEmpty(content_ids) && AppUtils.isNullOrEmpty(postIdsByContentIds = this.restComponent.getPostIdsByContentIds(content_ids))) {
            postIdsByContentIds.add(-1L);
        }
        Set<Long> postIdsByMoodIds = new HashSet();
        if (!AppUtils.isNullOrEmpty(mood_ids) && AppUtils.isNullOrEmpty(postIdsByMoodIds = this.restComponent.getPostIdsByMoodIds(mood_ids))) {
            postIdsByMoodIds.add(-1L);
        }
        Set<Long> postIdsByStandardIds = new HashSet();
        if (!AppUtils.isNullOrEmpty(standard_ids) && AppUtils.isNullOrEmpty(postIdsByStandardIds = this.restComponent.getPostIdsByStandardIds(standard_ids))) {
            postIdsByStandardIds.add(-1L);
        }
        Set<Long> postIdsByFavorite = new HashSet();
        if (showOnlyFavorites && student_id > 0L && AppUtils.isNullOrEmpty(postIdsByFavorite = this.restComponent.getPostIdsByStudentId(student_id))) {
            postIdsByFavorite.add(-1L);
        }
        PageRequest pageable = null;
        pageable = last_post_ids != null ? PageRequest.of((int)pageNo, (int)pageSize) : PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pageByPostTitle = this.postRepository.findPageByPostTitle(post_title, post_types, postIdsByCategoryIds, postIdsByContentIds, postIdsByMoodIds, postIdsByStandardIds, postIdsByFavorite, last_post_ids, (Pageable)pageable);
        if (!AppUtils.isNullOrEmpty((List)pageByPostTitle.getContent())) {
            Set post_ids = pageByPostTitle.stream().map(PostDTO::getPost_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
            PostCategoryListAndCategoryListWrapper categories = this.getPostCategoryListAndCategoryListByPostIds(post_ids);
            PostContentListAndContentListWrapper contents = this.getPostContentListAndContentListByPostIds(post_ids);
            PostMoodListAndMoodListWrapper moods = this.getPostMoodListAndMoodListByPostIds(post_ids);
            PostStandardListAndStandardListWrapper standards = this.getPostStandardListAndStandardListByPostIds(post_ids);
            if (student_id > 0L && !showOnlyFavorites) {
                postIdsByFavorite = this.restComponent.getPostIdsByStudentId(student_id);
            }
            for (PostDTO post : pageByPostTitle.getContent()) {
                this.setCategories(post, categories);
                this.setContents(post, contents);
                this.setMoods(post, moods);
                this.setStandards(post, standards);
                if (student_id <= 0L) continue;
                post.setFavorite(postIdsByFavorite.contains(post.getPost_id()));
            }
        }
        PageImplStreak pagedResult = new PageImplStreak(pageByPostTitle.getContent(), (Pageable)pageable, pageByPostTitle.getTotalElements(), student_id > 0L ? this.streakResourceLibraryService.addStreakResourceLibrary(student_id) : null);
        return pagedResult;
    }

    public Page<PostWrapper> getResourceLibrary(long student_id, String post_title, Set<String> post_types, Set<Long> category_ids, Set<Long> content_ids, Set<Long> mood_ids, Set<Long> standard_ids, boolean showOnlyFavorites, Set<Long> last_post_ids, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        Set<Long> postIdsByCategoryIds = new HashSet();
        if (!AppUtils.isNullOrEmpty(category_ids) && AppUtils.isNullOrEmpty(postIdsByCategoryIds = this.restComponent.getPostIdsByCategoryIds(category_ids))) {
            postIdsByCategoryIds.add(-1L);
        }
        Set<Long> postIdsByContentIds = new HashSet();
        if (!AppUtils.isNullOrEmpty(content_ids) && AppUtils.isNullOrEmpty(postIdsByContentIds = this.restComponent.getPostIdsByContentIds(content_ids))) {
            postIdsByContentIds.add(-1L);
        }
        Set<Long> postIdsByMoodIds = new HashSet();
        if (!AppUtils.isNullOrEmpty(mood_ids) && AppUtils.isNullOrEmpty(postIdsByMoodIds = this.restComponent.getPostIdsByMoodIds(mood_ids))) {
            postIdsByMoodIds.add(-1L);
        }
        Set<Long> postIdsByStandardIds = new HashSet();
        if (!AppUtils.isNullOrEmpty(standard_ids) && AppUtils.isNullOrEmpty(postIdsByStandardIds = this.restComponent.getPostIdsByStandardIds(standard_ids))) {
            postIdsByStandardIds.add(-1L);
        }
        Set<Long> postIdsByFavorite = new HashSet();
        if (showOnlyFavorites && student_id > 0L && AppUtils.isNullOrEmpty(postIdsByFavorite = this.restComponent.getPostIdsByStudentId(student_id))) {
            postIdsByFavorite.add(-1L);
        }
        PageRequest pageable = null;
        pageable = last_post_ids != null ? PageRequest.of((int)pageNo, (int)pageSize) : PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pageByPostTitle = this.postRepository.findPageByPostTitle(post_title, post_types, postIdsByCategoryIds, postIdsByContentIds, postIdsByMoodIds, postIdsByStandardIds, postIdsByFavorite, last_post_ids, (Pageable)pageable);
        if (!AppUtils.isNullOrEmpty((List)pageByPostTitle.getContent()) && student_id > 0L && !showOnlyFavorites) {
            postIdsByFavorite = this.restComponent.getPostIdsByStudentId(student_id);
        }
        Set<Long> finalPostIdsByFavorite = postIdsByFavorite;
        PageImplStreak pagedResult = new PageImplStreak(pageByPostTitle.getContent().stream().map(p -> PostWrapper.builder().post_id(p.getPost_id()).post_title(p.getPost_title()).post_title_es(p.getPost_title_es()).post_duration(p.getPost_duration()).post_description(p.getPost_description()).post_cover_image_url(p.getPost_cover_image_url()).post_cover_image_url_es(p.getPost_cover_image_url_es()).post_duration(p.getPost_duration()).post_duration_es(p.getPost_duration_es()).post_video_url(p.getPost_video_url()).post_video_url_es(p.getPost_video_url_es()).oEmbed_html(p.getoEmbed_html()).oEmbed_html_es(p.getoEmbed_html_es()).deleted(p.isDeleted()).favorite(student_id > 0L ? finalPostIdsByFavorite.contains(p.getPost_id()) : p.isFavorite()).post_type(p.getPost_type()).build()).collect(Collectors.toList()), (Pageable)pageable, pageByPostTitle.getTotalElements(), student_id > 0L ? this.streakResourceLibraryService.addStreakResourceLibrary(student_id) : null);
        return pagedResult;
    }

    public void updateoEmbed_htmlById(long id, String oEmbed_html) {
        this.postRepository.updateoEmbed_htmlById(id, oEmbed_html);
    }

    private PostCategoryListAndCategoryListWrapper getPostCategoryListAndCategoryListByPostIds(Set<Long> post_ids) {
        Set ids;
        PostCategoryListAndCategoryListWrapper wrapper = new PostCategoryListAndCategoryListWrapper();
        wrapper.setPost_category_list(this.restComponent.getPostCategoryListByPostIds(post_ids));
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_category_list()) && !AppUtils.isNullOrEmpty((Set)(ids = (Set)wrapper.getPost_category_list().stream().map(PostCategoryDTO::getCategory_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            wrapper.setCategory_list(this.restComponent.getCategoriesByIds(ids));
        }
        return wrapper;
    }

    private PostContentListAndContentListWrapper getPostContentListAndContentListByPostIds(Set<Long> post_ids) {
        Set ids;
        PostContentListAndContentListWrapper wrapper = new PostContentListAndContentListWrapper();
        wrapper.setPost_content_list(this.restComponent.getPostContentListByPostIds(post_ids));
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_content_list()) && !AppUtils.isNullOrEmpty((Set)(ids = (Set)wrapper.getPost_content_list().stream().map(PostContentDTO::getContent_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            wrapper.setContent_list(this.restComponent.getContentsByIds(ids));
        }
        return wrapper;
    }

    private PostMoodListAndMoodListWrapper getPostMoodListAndMoodListByPostIds(Set<Long> post_ids) {
        Set ids;
        PostMoodListAndMoodListWrapper wrapper = new PostMoodListAndMoodListWrapper();
        wrapper.setPost_mood_list(this.restComponent.getPostMoodListByPostIds(post_ids));
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_mood_list()) && !AppUtils.isNullOrEmpty((Set)(ids = (Set)wrapper.getPost_mood_list().stream().map(PostMoodDTO::getMood_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            wrapper.setMood_list(this.restComponent.getMoodsByIds(ids));
        }
        return wrapper;
    }

    private PostStandardListAndStandardListWrapper getPostStandardListAndStandardListByPostIds(Set<Long> post_ids) {
        Set ids;
        PostStandardListAndStandardListWrapper wrapper = new PostStandardListAndStandardListWrapper();
        wrapper.setPost_standard_list(this.restComponent.getPostStandardListByPostIds(post_ids));
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_standard_list()) && !AppUtils.isNullOrEmpty((Set)(ids = (Set)wrapper.getPost_standard_list().stream().map(PostStandardDTO::getStandard_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            wrapper.setStandard_list(this.restComponent.getStandardsByIds(ids));
        }
        return wrapper;
    }

    private void setCategories(PostDTO post, PostCategoryListAndCategoryListWrapper wrapper) {
        Set categoryIdsForPost;
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_category_list()) && !AppUtils.isNullOrEmpty((Set)(categoryIdsForPost = (Set)wrapper.getPost_category_list().stream().filter(postCategoryDTO -> postCategoryDTO.getPost_id() == post.getPost_id()).map(PostCategoryDTO::getCategory_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            Set categories = wrapper.getCategory_list().stream().filter(categoryDTO -> categoryIdsForPost.contains(categoryDTO.getCategory_id())).sorted(Comparator.comparingLong(CategoryDTO::getCategory_id)).collect(Collectors.toCollection(LinkedHashSet::new));
            post.setCategories(categories);
        }
    }

    private void setContents(PostDTO post, PostContentListAndContentListWrapper wrapper) {
        Set contentIdsForPost;
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_content_list()) && !AppUtils.isNullOrEmpty((Set)(contentIdsForPost = (Set)wrapper.getPost_content_list().stream().filter(postContentDTO -> postContentDTO.getPost_id() == post.getPost_id()).map(PostContentDTO::getContent_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            Set contents = wrapper.getContent_list().stream().filter(contentDTO -> contentIdsForPost.contains(contentDTO.getContent_id())).sorted(Comparator.comparingLong(ContentDTO::getContent_id)).collect(Collectors.toCollection(LinkedHashSet::new));
            post.setContents(contents);
        }
    }

    private void setMoods(PostDTO post, PostMoodListAndMoodListWrapper wrapper) {
        Set moodIdsForPost;
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_mood_list()) && !AppUtils.isNullOrEmpty((Set)(moodIdsForPost = (Set)wrapper.getPost_mood_list().stream().filter(postContentDTO -> postContentDTO.getPost_id() == post.getPost_id()).map(PostMoodDTO::getMood_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            Set moods = wrapper.getMood_list().stream().filter(moodDTO -> moodIdsForPost.contains(moodDTO.getMood_id())).sorted(Comparator.comparingLong(MoodDTO::getMood_id)).collect(Collectors.toCollection(LinkedHashSet::new));
            post.setMoods(moods);
        }
    }

    private void setStandards(PostDTO post, PostStandardListAndStandardListWrapper wrapper) {
        Set standardIdsForPost;
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_standard_list()) && !AppUtils.isNullOrEmpty((Set)(standardIdsForPost = (Set)wrapper.getPost_standard_list().stream().filter(postContentDTO -> postContentDTO.getPost_id() == post.getPost_id()).map(PostStandardDTO::getStandard_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            Set standards = wrapper.getStandard_list().stream().filter(standardDTO -> standardIdsForPost.contains(standardDTO.getStandard_id())).sorted(Comparator.comparingLong(StandardDTO::getStandard_id)).collect(Collectors.toCollection(LinkedHashSet::new));
            post.setStandards(standards);
        }
    }
}

