/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.selfmanagement.service;

import com.infinite.focus.server.assessment.model.AssessmentOccurrence;
import com.infinite.focus.server.assessment.model.CategoryAndScore;
import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.data.model.OccurrenceAndOccurrenceAverage;
import com.infinite.focus.server.dataset.dto.DataSetDTO;
import com.infinite.focus.server.dataset.entity.DataSet;
import com.infinite.focus.server.dataset.service.DataSetService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.responsibledecisionmaking.model.AssessmentOccurrenceByStandards;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.selfmanagement.dto.SelfManagementUpdateDTO;
import com.infinite.focus.server.selfmanagement.entity.SelfManagementUpdate;
import com.infinite.focus.server.selfmanagement.repository.SelfManagementUpdateCriteriaRepository;
import com.infinite.focus.server.selfmanagement.repository.SelfManagementUpdateRepository;
import com.infinite.focus.server.selfmanagement.service.SelfManagementUpdateService;
import com.infinite.focus.server.selfmanagement.wrapper.SelfManagementUpdateWrapper;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class SelfManagementUpdateServiceImpl
implements SelfManagementUpdateService {
    private final EntityManager entityManager;
    private final SelfManagementUpdateRepository selfManagementUpdateRepository;
    private final SelfManagementUpdateCriteriaRepository selfManagementUpdateCriteriaRepository;
    private final DataSetService dataService;
    private final MessageService messageService;
    private final RestComponent restComponent;

    public SelfManagementUpdateServiceImpl(EntityManager entityManager, SelfManagementUpdateRepository selfManagementUpdateRepository, SelfManagementUpdateCriteriaRepository selfManagementUpdateCriteriaRepository, DataSetService dataService, MessageService messageService, RestComponent restComponent) {
        this.entityManager = entityManager;
        this.selfManagementUpdateRepository = selfManagementUpdateRepository;
        this.selfManagementUpdateCriteriaRepository = selfManagementUpdateCriteriaRepository;
        this.dataService = dataService;
        this.messageService = messageService;
        this.restComponent = restComponent;
    }

    public SelfManagementUpdate createSelfManagementUpdate(SelfManagementUpdate selfManagementUpdate) {
        DataSet dataSet = this.dataService.getDataSetById(selfManagementUpdate.getData_set_id());
        if (dataSet == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.data.set.is.not.found"));
        }
        selfManagementUpdate.setScore(dataSet.getScore());
        return (SelfManagementUpdate)this.selfManagementUpdateRepository.save((Object)selfManagementUpdate);
    }

    public Page<SelfManagementUpdateWrapper> getSelfManagementUpdateLogByStudentId(long student_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.selfManagementUpdateRepository.findByStudentId(student_id, (Pageable)paging);
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(log -> {
            SelfManagementUpdateWrapper wrapper = new SelfManagementUpdateWrapper();
            DataSet dataSet = this.dataService.getDataSetById(log.getData_set_id());
            this.dataService.addDataSetImages(dataSet);
            wrapper.setSelf_management_update_id(log.getSelf_management_update_id());
            wrapper.setStudent_id(log.getStudent_id());
            wrapper.setData_set_id(log.getData_set_id());
            wrapper.setText(log.getText());
            wrapper.setText_es(log.getText_es());
            wrapper.setImage(dataSet.getImage());
            wrapper.setColor(dataSet.getColor());
            wrapper.setCreatedAt(log.getCreatedAt());
            return wrapper;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public Page<SelfManagementUpdateWrapper> getByStudentId(long student_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.selfManagementUpdateRepository.findByStudentId(student_id, (Pageable)paging);
        List data_set_ids = pagedResult.stream().map(SelfManagementUpdate::getData_set_id).distinct().collect(Collectors.toList());
        HashMap dataSetMap = new HashMap();
        if (!AppUtils.isNullOrEmpty(data_set_ids)) {
            this.dataService.getDataSetByIds(data_set_ids).forEach(dataSet -> dataSetMap.put(dataSet.getData_set_id(), dataSet));
        }
        List wrappers = pagedResult.stream().map(log -> {
            SelfManagementUpdateWrapper wrapper = new SelfManagementUpdateWrapper();
            DataSetDTO dataSet = (DataSetDTO)dataSetMap.get(log.getData_set_id());
            wrapper.setSelf_management_update_id(log.getSelf_management_update_id());
            wrapper.setStudent_id(log.getStudent_id());
            wrapper.setData_set_id(log.getData_set_id());
            wrapper.setText(log.getText());
            wrapper.setText_es(log.getText_es());
            if (dataSet != null) {
                wrapper.setImage(dataSet.getImage());
                wrapper.setColor(dataSet.getColor());
            }
            wrapper.setCreatedAt(log.getCreatedAt());
            return wrapper;
        }).collect(Collectors.toList());
        return new PageImpl(wrappers, pagedResult.getPageable(), pagedResult.getTotalElements());
    }

    public SelfManagementUpdate getSelfManagementUpdateById(long self_management_update_id) {
        return this.selfManagementUpdateRepository.findBySelfManagementUpdateId(Long.valueOf(self_management_update_id));
    }

    public CategoryAndScore getCategoryAndScoreBySelfManagementUpdateIdAndScore(long self_management_update_id, double score) {
        SelfManagementUpdate selfManagementUpdate = this.getSelfManagementUpdateById(self_management_update_id);
        CategoryDTO category = this.dataService.getCategoryByDataSetId(selfManagementUpdate.getData_set_id());
        CategoryAndScore categoryAndScore = new CategoryAndScore();
        categoryAndScore.setCategory(category);
        categoryAndScore.setScore(score);
        return categoryAndScore;
    }

    public List<String[]> getTextList() {
        List list = this.selfManagementUpdateRepository.getTextListOrderByDataSetId();
        ArrayList<String[]> texts = new ArrayList<String[]>();
        for (Object[] item : list) {
            texts.add(new String[]{(String)item[0], (String)item[1]});
        }
        return texts;
    }

    public List<SelfManagementUpdate> findByStudentIdAndBetweenFromDateAndEndDate(Long student_id, String fromDate, String toDate) {
        return this.selfManagementUpdateRepository.findByStudentIdAndBetweenFromDateAndEndDate(student_id, fromDate, toDate);
    }

    public List<SelfManagementUpdate> getSelfManagementUpdateByStudentIds(List<Long> student_ids, Date fromDate, Date toDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(SelfManagementUpdate.class);
        Root root = query.from(SelfManagementUpdate.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!AppUtils.isNotNullOrEmpty(student_ids)) {
            return new ArrayList<SelfManagementUpdate>();
        }
        CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student_id")).value(student_ids);
        predicates.add(genderPredicate);
        if (fromDate != null && toDate != null) {
            System.out.println("getSelfManagementUpdateByStudentIds FromDate " + DateUtils.dailyDateFormat.format(fromDate) + " - ToDate " + DateUtils.dailyDateFormat.format(toDate));
            predicates.add(criteriaBuilder.between((Expression)root.get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        }
        query.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("createdAt"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List selfManagementUpdateList = typedQuery.getResultList();
        System.out.println("SelfManagementUpdate Count = " + selfManagementUpdateList.size());
        return selfManagementUpdateList;
    }

    public AssessmentOccurrenceByStandards getByStudentIdsAndFromDateAndToDate(Set<Long> student_ids, Date from_date, Date to_date) {
        List selfManagementUpdateDTOS = this.selfManagementUpdateCriteriaRepository.findByStudentIdsAndBetweenFromDateAndToDate2(student_ids, from_date, to_date);
        AssessmentOccurrenceByStandards byStandards = AssessmentOccurrenceByStandards.builder()._3_5(new ArrayList(this.selfManagementUpdateCriteriaRepository.getTextToDisplay2()))._6_12(new ArrayList(this.selfManagementUpdateCriteriaRepository.getTextToDisplay2())).build();
        Set _3_5_standard_ids = this.restComponent.get3_5StandardIds();
        Set _6_12_standard_ids = this.restComponent.get6_12StandardIds();
        this.setSelfManagementByStandard(student_ids, _3_5_standard_ids, byStandards.get_3_5(), selfManagementUpdateDTOS);
        this.setSelfManagementByStandard(student_ids, _6_12_standard_ids, byStandards.get_6_12(), selfManagementUpdateDTOS);
        return byStandards;
    }

    public SelfManagementUpdateDTO getById(long self_management_update_id) {
        return this.selfManagementUpdateCriteriaRepository.findById(self_management_update_id);
    }

    public List<OccurrenceAndOccurrenceAverage> getOccurrenceAndOccurrenceAverageByStudentIdsAndFromDateAndToDate(Set<Long> student_ids, Date from_date, Date to_date) {
        List selfManagementUpdateDTOS = this.selfManagementUpdateCriteriaRepository.findByStudentIdsAndBetweenFromDateAndToDate2(student_ids, from_date, to_date);
        List occurrenceAndOccurrenceAverages = this.setSelfManagement(student_ids, this.selfManagementUpdateCriteriaRepository.getTextToDisplay3(), selfManagementUpdateDTOS);
        return occurrenceAndOccurrenceAverages;
    }

    private void setSelfManagementByStandard(Set<Long> student_ids, Set<Long> standardIds, List<AssessmentOccurrence> assessmentOccurrences, List<SelfManagementUpdateDTO> selfManagementUpdateDTOS) {
        Set byStandards = selfManagementUpdateDTOS.stream().filter(r -> standardIds.contains(r.getStandard_id())).collect(Collectors.toSet());
        for (AssessmentOccurrence assessmentOccurrence : assessmentOccurrences) {
            for (SelfManagementUpdateDTO dto : byStandards) {
                if (!dto.getText().equalsIgnoreCase(assessmentOccurrence.getText_to_display()) || !dto.getText_es().equalsIgnoreCase(assessmentOccurrence.getText_to_display_es())) continue;
                assessmentOccurrence.setOccurrence(assessmentOccurrence.getOccurrence() + 1L);
            }
            try {
                assessmentOccurrence.setCount(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)assessmentOccurrence.getOccurrence() / (double)student_ids.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (AssessmentOccurrence assessmentOccurrence : assessmentOccurrences) {
            try {
                assessmentOccurrence.setOccurrence_average(DigitUtils.getPercentageInTwoDigit((Long)assessmentOccurrence.getOccurrence(), (Long)Long.valueOf(byStandards.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<OccurrenceAndOccurrenceAverage> setSelfManagement(Set<Long> student_ids, List<OccurrenceAndOccurrenceAverage> occurrenceAndOccurrenceAverages, List<SelfManagementUpdateDTO> selfManagementUpdateDTOS) {
        for (OccurrenceAndOccurrenceAverage assessmentOccurrence : occurrenceAndOccurrenceAverages) {
            for (SelfManagementUpdateDTO dto : selfManagementUpdateDTOS) {
                if (!dto.getText().equalsIgnoreCase(assessmentOccurrence.getText_to_display()) || !dto.getText_es().equalsIgnoreCase(assessmentOccurrence.getText_to_display_es())) continue;
                assessmentOccurrence.setOccurrence(assessmentOccurrence.getOccurrence() + 1L);
            }
            try {
                assessmentOccurrence.setCount(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)assessmentOccurrence.getOccurrence() / (double)student_ids.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (OccurrenceAndOccurrenceAverage assessmentOccurrence : occurrenceAndOccurrenceAverages) {
            try {
                assessmentOccurrence.setOccurrence_average(DigitUtils.getPercentageInTwoDigit((Long)assessmentOccurrence.getOccurrence(), (Long)Long.valueOf(selfManagementUpdateDTOS.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return occurrenceAndOccurrenceAverages;
    }
}

