/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.selanalytics.selfawareness;

import com.infinite.focus.server.activity.dto.ActivityDTO;
import com.infinite.focus.server.activity.entity.Activity;
import com.infinite.focus.server.activity.repository.ActivityCriteriaRepository;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.dashboard.helper.LabelAndDataHelper;
import com.infinite.focus.server.dashboard.model.LabelAndValue;
import com.infinite.focus.server.dashboard.model.MoodInsight;
import com.infinite.focus.server.dashboard.model.MoodInsightPost;
import com.infinite.focus.server.dashboard.model.MoodOccuranceAndCompetencyScore;
import com.infinite.focus.server.dashboard.request.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.selanalytics.selfawareness.SelfAwarenessDataService;
import com.infinite.focus.server.data.model.EmotionsByStandards;
import com.infinite.focus.server.data.model.MoodOccurance;
import com.infinite.focus.server.data.model.SubMoodByStandardOccurrence;
import com.infinite.focus.server.data.response.MoodInsightsPostBeforeAfterResponse;
import com.infinite.focus.server.data.service.DataServiceImpl;
import com.infinite.focus.server.ethnicity.entity.Ethnicity;
import com.infinite.focus.server.ethnicity.repository.EthnicityRepository;
import com.infinite.focus.server.gender.entity.Gender;
import com.infinite.focus.server.gender.repository.GenderRepository;
import com.infinite.focus.server.grade.entity.Grade;
import com.infinite.focus.server.grade.repository.GradeRepository;
import com.infinite.focus.server.grade.view.GradeView;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.lesson.entity.Lesson;
import com.infinite.focus.server.lesson.repository.LessonRepository;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.repository.MoodRepository;
import com.infinite.focus.server.moodupdate.dto.MoodUpdateDTO;
import com.infinite.focus.server.moodupdate.entity.MoodUpdate;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.repository.PostRepository;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.socioemotionaltestanswer.entity.SocioEmotionalTestAnswer;
import com.infinite.focus.server.socioemotionaltestanswer.repository.SocioEmotionalTestAnswerRepository;
import com.infinite.focus.server.socioemotionaltestquestion.entity.SocioEmotionalTestQuestion;
import com.infinite.focus.server.socioemotionaltestquestion.repository.SocioEmotionalTestQuestionRepository;
import com.infinite.focus.server.socioemotionaltestquestionoption.entity.SocioEmotionalTestQuestionOption;
import com.infinite.focus.server.socioemotionaltestquestionoption.repository.SocioEmotionalTestQuestionOptionRepository;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestResultService;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.student.repository.StudentCriteriaRepository;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.test.wrapper.SocioEmotionalTestDataWrapper;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import com.infinite.focus.server.utils.MoodUpdateUtils;
import com.infinite.focus.server.utils.TimeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.stereotype.Service;

@Service
public class SelfAwarenessDataServiceImpl
implements SelfAwarenessDataService {
    private final RestComponent restComponent;
    private final EntityManager entityManager;
    private final SocioEmotionalTestQuestionOptionRepository socioEmotionalTestQuestionOptionRepository;
    private final SocioEmotionalTestQuestionRepository socioEmotionalTestQuestionRepository;
    private final SocioEmotionalTestAnswerRepository socioEmotionalTestAnswerRepository;
    private final SocioEmotionalTestResultService socioEmotionalTestResultService;
    private final GradeRepository gradeRepository;
    private final StudentRepository studentRepository;
    private final StudentCriteriaRepository studentCriteriaRepository;
    private final MoodRepository moodRepository;
    private final LessonRepository lessonRepository;
    private final PostRepository postRepository;
    private final ActivityService activityService;
    private final ActivityCriteriaRepository activityCriteriaRepository;
    private final GenderRepository genderRepository;
    private final EthnicityRepository ethnicityRepository;
    String forwardSlash = "/";

    public SelfAwarenessDataServiceImpl(RestComponent restComponent, EntityManager entityManager, SocioEmotionalTestQuestionOptionRepository socioEmotionalTestQuestionOptionRepository, SocioEmotionalTestQuestionRepository socioEmotionalTestQuestionRepository, SocioEmotionalTestAnswerRepository socioEmotionalTestAnswerRepository, SocioEmotionalTestResultService socioEmotionalTestResultService, GradeRepository gradeRepository, StudentRepository studentRepository, StudentCriteriaRepository studentCriteriaRepository, MoodRepository moodRepository, LessonRepository lessonRepository, PostRepository postRepository, ActivityService activityService, ActivityCriteriaRepository activityCriteriaRepository, GenderRepository genderRepository, EthnicityRepository ethnicityRepository) {
        this.restComponent = restComponent;
        this.entityManager = entityManager;
        this.socioEmotionalTestQuestionOptionRepository = socioEmotionalTestQuestionOptionRepository;
        this.socioEmotionalTestQuestionRepository = socioEmotionalTestQuestionRepository;
        this.socioEmotionalTestAnswerRepository = socioEmotionalTestAnswerRepository;
        this.socioEmotionalTestResultService = socioEmotionalTestResultService;
        this.gradeRepository = gradeRepository;
        this.studentRepository = studentRepository;
        this.studentCriteriaRepository = studentCriteriaRepository;
        this.moodRepository = moodRepository;
        this.lessonRepository = lessonRepository;
        this.postRepository = postRepository;
        this.activityService = activityService;
        this.activityCriteriaRepository = activityCriteriaRepository;
        this.genderRepository = genderRepository;
        this.ethnicityRepository = ethnicityRepository;
    }

    public Object getSelfReportingData(GetDataDashBoardRequest request) {
        LinkedList values;
        List student_ids;
        GetDataDashBoardRequest getDataDashBoardRequest;
        Date fromDate = null;
        Date toDate = null;
        if (request.getFromDate() != null && request.getToDate() != null) {
            fromDate = request.getFromDate();
            toDate = request.getToDate();
        } else {
            Date firstStudentRegistredDate = this.studentRepository.getDateOfFirstRegistredStudent();
            System.out.println("firstStudentRegistredDate - " + firstStudentRegistredDate);
            fromDate = firstStudentRegistredDate == null ? DateUtils.setTimeToFromDate((Date)new Date()) : DateUtils.setTimeToFromDate((Date)firstStudentRegistredDate);
            toDate = DateUtils.setTimeToToDate((Date)new Date());
        }
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        System.out.println("----------------------------- Gender------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedList> genders_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> genders_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, false);
            for (String gender : request.getGenders()) {
                Gender genderItem = this.genderRepository.findByGender(gender);
                System.out.println("----------------------------- " + gender + "------------------------------");
                values = this.getSelfReporting(student_ids.stream().filter(studentDTO -> studentDTO.getGender().equalsIgnoreCase(gender)).map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate, getDataDashBoardRequest.getTimeZone());
                genders_en.put(gender, values);
                genders_es.put(genderItem.getGender_es(), values);
            }
            graphData_en.put("Gender", genders_en);
            graphData_es.put("G\u00e9nero", genders_es);
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedList> ages_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> ages_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, false);
            for (Integer age : request.getAges()) {
                System.out.println("----------------------------- " + age + "------------------------------");
                LinkedList values2 = this.getSelfReporting(student_ids.stream().filter(studentDTO -> TimeUtils.getAge((Date)studentDTO.getDate_of_birth()) == age).map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate, getDataDashBoardRequest.getTimeZone());
                ages_en.put(String.valueOf(age), values2);
                ages_es.put(String.valueOf(age), values2);
            }
            graphData_en.put("Age", ages_en);
            graphData_es.put("Edad", ages_es);
        }
        System.out.println("----------------------------- Ethnicity------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedList> ethnicityMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> ethnicityMap_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, false);
            for (String ethnicity : request.getEthnicity()) {
                Ethnicity ethnicityItem = this.ethnicityRepository.findByEthnicity(ethnicity);
                System.out.println("----------------------------- " + ethnicity + "------------------------------");
                values = this.getSelfReporting(student_ids.stream().filter(studentDTO -> studentDTO.getEthnicity().equalsIgnoreCase(ethnicityItem.getEthnicity())).map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate, getDataDashBoardRequest.getTimeZone());
                ethnicityMap_en.put(ethnicity, values);
                ethnicityMap_es.put(ethnicityItem.getEthnicity_es(), values);
            }
            graphData_en.put("Ethnicity", ethnicityMap_en);
            graphData_es.put("Etnia", ethnicityMap_es);
        }
        System.out.println("----------------------------- Grade------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> grades_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> grades_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGradeIds().addAll(request.getGradeIds());
            student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, false);
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                String grade_name = ((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name();
                System.out.println("-----------------------------" + grade_id + " -> " + grade_name + "------------------------------");
                LinkedList values3 = this.getSelfReporting(student_ids.stream().filter(studentDTO -> Objects.equals(studentDTO.getGrade_id(), grade_id)).map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate, getDataDashBoardRequest.getTimeZone());
                grades_en.put(grade_name, values3);
                grades_es.put(gradeView.getGrade_name_es(), values3);
            }
            graphData_en.put("Grade", grades_en);
            graphData_es.put("Grado", grades_es);
        }
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public Object getMoodUpdateDemographicComparisonGraphData(GetDataDashBoardRequest request) {
        List student_ids = this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, false);
        List moodUpdateList = this.getMoodUpdateByStudentIds(student_ids, request.getFromDate(), request.getToDate());
        LinkedList moodOccurances = this.getMoodAnalysisByMoodUpdate(moodUpdateList, false, false);
        LinkedList<LabelAndValue> graphData_en = new LinkedList<LabelAndValue>();
        LinkedList<LabelAndValue> graphData_es = new LinkedList<LabelAndValue>();
        for (int i = 0; i < moodOccurances.size(); ++i) {
            graphData_en.add(new LabelAndValue(((MoodOccurance)moodOccurances.get(i)).getMood(), ((MoodOccurance)moodOccurances.get(i)).getCount().doubleValue()));
            if (!Language.isSpanish()) continue;
            graphData_es.add(new LabelAndValue(((MoodOccurance)moodOccurances.get(i)).getMood_es(), ((MoodOccurance)moodOccurances.get(i)).getCount().doubleValue()));
        }
        LinkedHashMap<String, LinkedList<LabelAndValue>> graphData = new LinkedHashMap<String, LinkedList<LabelAndValue>>();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public Object getMoodUpdateDemographicComparisonGraphDataNew(GetDataDashBoardRequest request) {
        List student_ids = this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, false);
        SubMoodByStandardOccurrence subMoodByStandardOccurrence = new SubMoodByStandardOccurrence();
        EmotionsByStandards emotionCountAndAverages = this.restComponent.getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate2(student_ids, request.getFromDate(), request.getToDate());
        subMoodByStandardOccurrence.set_k_2(DataServiceImpl.setSubMoodOccurrence((long)student_ids.size(), (List)emotionCountAndAverages.get_k_2()));
        subMoodByStandardOccurrence.set_3_5(DataServiceImpl.setSubMoodOccurrence((long)student_ids.size(), (List)emotionCountAndAverages.get_3_5()));
        subMoodByStandardOccurrence.set_6_12(DataServiceImpl.setSubMoodOccurrence((long)student_ids.size(), (List)emotionCountAndAverages.get_6_12()));
        return subMoodByStandardOccurrence;
    }

    public Object getMoodAnalysisGraphData(GetDataDashBoardRequest request) {
        System.out.println("----------------------------MOOD_ANALYSIS--------------------------------------");
        List student_ids = this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, false);
        List moodUpdateList = this.getMoodUpdateByStudentIds(student_ids, request.getFromDate(), request.getToDate());
        LinkedList moodOccurances = this.getMoodAnalysisByMoodUpdate(moodUpdateList, false, false);
        Double totalCount = 0.0;
        for (int i = 0; i < moodOccurances.size(); ++i) {
            totalCount = totalCount + ((MoodOccurance)moodOccurances.get(i)).getCount();
            System.out.println(((MoodOccurance)moodOccurances.get(i)).getMood() + " - " + ((MoodOccurance)moodOccurances.get(i)).getCount());
        }
        System.out.println("-------------------------------------------------------------------");
        System.out.println("Total occournce " + totalCount);
        String forwordSlash = "/";
        System.out.println("------------------------Percentage = (Value " + forwordSlash + " Total Value) \ufffd 100-------------------------------------------");
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        double percentageTotal = 0.0;
        for (int i = 0; i < moodOccurances.size(); ++i) {
            LinkedList<Double> list = new LinkedList<Double>();
            String mood = ((MoodOccurance)moodOccurances.get(i)).getMood();
            Double count = (double)((MoodOccurance)moodOccurances.get(i)).getCount();
            Double percentage = DigitUtils.getPercentage((Double)count, (Double)totalCount);
            percentageTotal += percentage.doubleValue();
            System.out.println(mood + "\t=\t( Value\t" + count + "\t" + forwordSlash + "\tTotal Value\t" + totalCount + " ) X 100 =\tpercentage\t" + percentage);
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)count));
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)percentage));
            graphData_en.put(((MoodOccurance)moodOccurances.get(i)).getMood(), list);
            graphData_es.put(((MoodOccurance)moodOccurances.get(i)).getMood_es(), list);
        }
        System.out.println("-----------------------------------------------------------------------------------------------------------------------------");
        System.out.println("\t\t( Value\t" + totalCount + "\t" + forwordSlash + "\tTotal Value\t" + totalCount + " ) X 100 =\tpercentage\t" + percentageTotal);
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public Object getMoodAnalysisGraphDataNew(GetDataDashBoardRequest request) {
        System.out.println("----------------------------MOOD_ANALYSIS--------------------------------------");
        List student_ids = this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, false);
        SubMoodByStandardOccurrence subMoodByStandardOccurrence = new SubMoodByStandardOccurrence();
        EmotionsByStandards emotionCountAndAverages = this.restComponent.getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate2(student_ids, request.getFromDate(), request.getToDate());
        subMoodByStandardOccurrence.set_k_2(DataServiceImpl.setSubMoodOccurrence((long)student_ids.size(), (List)emotionCountAndAverages.get_k_2()));
        subMoodByStandardOccurrence.set_3_5(DataServiceImpl.setSubMoodOccurrence((long)student_ids.size(), (List)emotionCountAndAverages.get_3_5()));
        subMoodByStandardOccurrence.set_6_12(DataServiceImpl.setSubMoodOccurrence((long)student_ids.size(), (List)emotionCountAndAverages.get_6_12()));
        return subMoodByStandardOccurrence;
    }

    public Object getMostAndLeastReportedData(GetDataDashBoardRequest request) {
        LinkedHashMap values;
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
        List student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, false);
        System.out.println("----------------------------- Gender ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap genderMap_en = new LinkedHashMap();
            LinkedHashMap genderMap_es = new LinkedHashMap();
            for (String gender : request.getGenders()) {
                Gender genderItem = this.genderRepository.findByGender(gender);
                System.out.println("-----------------------------" + gender + "------------------------------");
                values = this.getMostAndLeast(student_ids.stream().filter(studentDTO -> !AppUtils.isNullOrEmpty((String)studentDTO.getGender()) && studentDTO.getGender().equals(gender)).map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate());
                genderMap_en.put(gender, values.get("en"));
                genderMap_es.put(genderItem.getGender_es(), values.get("es"));
            }
            graphData_en.put("Gender", genderMap_en);
            graphData_es.put("G\u00e9nero", genderMap_es);
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap ageMap_en = new LinkedHashMap();
            LinkedHashMap ageMap_es = new LinkedHashMap();
            for (Integer age : request.getAges()) {
                System.out.println("-----------------------------" + age + "------------------------------");
                LinkedHashMap values2 = this.getMostAndLeast(student_ids.stream().filter(studentDTO -> TimeUtils.getAge((Date)studentDTO.getDate_of_birth()) == age).map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate());
                ageMap_en.put(String.valueOf(age), values2.get("en"));
                ageMap_es.put(String.valueOf(age), values2.get("es"));
            }
            graphData_en.put("Age", ageMap_en);
            graphData_es.put("Edad", ageMap_es);
        }
        System.out.println("---------------------------- Ethnicity ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap ethnicityMap_en = new LinkedHashMap();
            LinkedHashMap ethnicityMap_es = new LinkedHashMap();
            for (String ethnicity : request.getEthnicity()) {
                Ethnicity ethnicityItem = this.ethnicityRepository.findByEthnicity(ethnicity);
                System.out.println("-----------------------------" + ethnicity + "------------------------------");
                values = this.getMostAndLeast(student_ids.stream().filter(studentDTO -> studentDTO.getEthnicity().equals(ethnicityItem.getEthnicity())).map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate());
                ethnicityMap_en.put(ethnicity, values.get("en"));
                ethnicityMap_es.put(ethnicityItem.getEthnicity_es(), values.get("es"));
            }
            graphData_en.put("Ethnicity", ethnicityMap_en);
            graphData_es.put("Etnia", ethnicityMap_es);
        }
        System.out.println("----------------------------- Grade ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap gradeMap_en = new LinkedHashMap();
            LinkedHashMap gradeMap_es = new LinkedHashMap();
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                values = this.getMostAndLeast(student_ids.stream().filter(studentDTO -> Objects.equals(studentDTO.getGrade_id(), grade_id)).map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate());
                gradeMap_en.put(gradeView.getGrade_name(), values.get("en"));
                gradeMap_es.put(gradeView.getGrade_name_es(), values.get("es"));
            }
            graphData_en.put("Grade", gradeMap_en);
            graphData_es.put("Grado", gradeMap_es);
        }
        System.out.println("----------------------------- Overall ------------------------------");
        LinkedHashMap values3 = this.getMostAndLeast(student_ids.stream().map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate());
        LinkedHashMap overall_en = new LinkedHashMap();
        overall_en.put("Overall", values3.get("en"));
        LinkedHashMap overall_es = new LinkedHashMap();
        overall_es.put("En total", values3.get("es"));
        graphData_en.put("Overall", overall_en);
        graphData_es.put("En total", overall_es);
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedList<String>> getMostAndLeast(List<Long> student_ids, Date fromDate, Date toDate) {
        List moodUpdateList = this.getMoodUpdateByStudentIds(student_ids, fromDate, toDate);
        LinkedList moodOccurances = this.removeMoodOccuranceWithZeroCountFromMoodOccuranceList(this.getMoodAnalysisByMoodUpdate(moodUpdateList, true, false));
        LinkedList<String> mostAndLeast_en = new LinkedList<String>();
        LinkedList<String> mostAndLeast_es = new LinkedList<String>();
        if (AppUtils.isNotNullOrEmpty((List)moodOccurances)) {
            MoodOccurance most = (MoodOccurance)moodOccurances.get(0);
            MoodOccurance least = (MoodOccurance)moodOccurances.get(moodOccurances.size() - 1);
            if (most.getCount() > 0.0) {
                mostAndLeast_en.add(most.getMood() + " ( " + most.getCount() + " ) ");
                mostAndLeast_es.add(most.getMood_es() + " ( " + most.getCount() + " ) ");
            } else {
                mostAndLeast_en.add(" ( " + least.getCount() + " ) ");
                mostAndLeast_es.add(" ( " + least.getCount() + " ) ");
            }
            if (least.getCount() > 0.0) {
                mostAndLeast_en.add(least.getMood() + " ( " + least.getCount() + " ) ");
                mostAndLeast_es.add(least.getMood_es() + " ( " + least.getCount() + " ) ");
            } else {
                mostAndLeast_en.add(" ( " + least.getCount() + " ) ");
                mostAndLeast_es.add(" ( " + least.getCount() + " ) ");
            }
        } else {
            mostAndLeast_en.add("");
            mostAndLeast_en.add("");
            mostAndLeast_es.add("");
            mostAndLeast_es.add("");
        }
        LinkedHashMap<String, LinkedList<String>> graphData = new LinkedHashMap<String, LinkedList<String>>();
        graphData.put("en", mostAndLeast_en);
        if (Language.isSpanish()) {
            graphData.put("es", mostAndLeast_es);
        }
        return graphData;
    }

    private LinkedList<MoodOccurance> removeMoodOccuranceWithZeroCountFromMoodOccuranceList(LinkedList<MoodOccurance> list) {
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            MoodOccurance x = (MoodOccurance)itr.next();
            if (x.getCount() != 0.0) continue;
            itr.remove();
        }
        return list;
    }

    public Object getMoodAnalysisAndCompetencyScoreGraphData(GetDataDashBoardRequest request) {
        LinkedHashMap values;
        GetDataDashBoardRequest getDataDashBoardRequest;
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            values = this.getMoodAnalysisAndCompetencyScore(getDataDashBoardRequest);
            graphData_en.put("Gender", values.get("en"));
            graphData_es.put("G\u00e9nero", values.get("es"));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            values = this.getMoodAnalysisAndCompetencyScore(getDataDashBoardRequest);
            graphData_en.put("Age", values.get("en"));
            graphData_es.put("Edad", values.get("es"));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            values = this.getMoodAnalysisAndCompetencyScore(getDataDashBoardRequest);
            graphData_en.put("Ethnicity", values.get("en"));
            graphData_es.put("Etnia", values.get("es"));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getGradeIds().addAll(request.getGradeIds());
            values = this.getMoodAnalysisAndCompetencyScore(getSocioEmotionalDataAnalyticsRequest);
            graphData_en.put("Grade", values.get("en"));
            graphData_es.put("Grado", values.get("es"));
        }
        LinkedHashMap<String, Object> graphData = new LinkedHashMap<String, Object>();
        graphData.put("en", LabelAndDataHelper.getLabelsAndMultiDatasets(graphData_en));
        if (Language.isSpanish()) {
            graphData.put("es", LabelAndDataHelper.getLabelsAndMultiDatasets(graphData_es));
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> getMoodAnalysisAndCompetencyScore(GetDataDashBoardRequest request) {
        System.out.println("----------------------------MODD_ANALYSIS_AND_COMPETENCY_SCORE--------------------------------------");
        List student_ids = this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, false);
        List moodUpdateList = this.getMoodUpdateByStudentIds(student_ids, request.getFromDate(), request.getToDate());
        LinkedList moodOccurances = this.getMoodAnalysisCompetencyScore(moodUpdateList, false);
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        Long socio_emotional_test_question_type_id = request.getSocio_emotional_test_question_type_id();
        for (int i = 0; i < moodOccurances.size(); ++i) {
            if (((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getCount() > 0 && AppUtils.isNotNullOrEmpty((LinkedHashSet)((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getStudentIds())) {
                List values = this.socioEmotionalTestResultService.getSocioEmotionalTestResultByStudentIds(((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getStudentIds(), request.getFromDate(), request.getToDate());
                if (socio_emotional_test_question_type_id == null) {
                    if (!values.isEmpty()) {
                        Double score = 0.0;
                        for (SocioEmotionalTestResult test : values) {
                            score = score + (double)test.getScore();
                        }
                        ((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).setScore(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getAverage((Double)score, (Double)Double.valueOf(values.size()))));
                    }
                } else {
                    SocioEmotionalTestDataWrapper s = new SocioEmotionalTestDataWrapper();
                    s.setOptions(this.socioEmotionalTestQuestionOptionRepository.findAll());
                    s.setQuestions(this.socioEmotionalTestQuestionRepository.findBySocioEmotionalTestQuestionTypeId(socio_emotional_test_question_type_id));
                    if (!values.isEmpty()) {
                        Double score = 0.0;
                        for (SocioEmotionalTestResult test : values) {
                            Double total_score = 0.0;
                            List socioEmotionalTestAnswers = this.socioEmotionalTestAnswerRepository.findBySocioEmotionalTestResultId(Long.valueOf(test.getSocio_emotional_test_result_id()));
                            for (int q = 0; q < s.getQuestions().size(); ++q) {
                                SocioEmotionalTestQuestion socioEmotionalTestQuestion = (SocioEmotionalTestQuestion)s.getQuestions().get(q);
                                block4: for (int a = 0; a < socioEmotionalTestAnswers.size(); ++a) {
                                    if (socioEmotionalTestQuestion.getSocio_emotional_test_question_id() != ((SocioEmotionalTestAnswer)socioEmotionalTestAnswers.get(a)).getSocio_emotional_test_question_id()) continue;
                                    SocioEmotionalTestAnswer socioEmotionalTestAnswer = (SocioEmotionalTestAnswer)socioEmotionalTestAnswers.get(a);
                                    for (int o = 0; o < s.getOptions().size(); ++o) {
                                        if (socioEmotionalTestAnswer.getSocio_emotional_test_question_option_id() != ((SocioEmotionalTestQuestionOption)s.getOptions().get(o)).getSocio_emotional_test_question_option_id()) continue;
                                        SocioEmotionalTestQuestionOption socioEmotionalTestQuestionOption = (SocioEmotionalTestQuestionOption)s.getOptions().get(o);
                                        total_score = socioEmotionalTestQuestion.isReversed() ? Double.valueOf(total_score + (double)socioEmotionalTestQuestionOption.getReverse_weight()) : Double.valueOf(total_score + (double)socioEmotionalTestQuestionOption.getWeight());
                                        System.out.println("total_score = " + total_score);
                                        continue block4;
                                    }
                                }
                            }
                            score = score + total_score;
                            System.out.println("test id " + test.getSocio_emotional_test_result_id() + "  score = " + score);
                        }
                        ((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).setScore(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getAverage((Double)score, (Double)Double.valueOf(values.size()))));
                    }
                }
            }
            LinkedList<Double> list = new LinkedList<Double>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)((Object)((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getCount())));
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getScore()));
            graphData_en.put(((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getMood(), list);
            graphData_es.put(((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getMood_es(), list);
        }
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>>();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public LinkedList<MoodOccuranceAndCompetencyScore> getMoodAnalysisCompetencyScore(List<MoodUpdate> moodUpdateList, boolean isSortData) {
        LinkedList<MoodOccuranceAndCompetencyScore> list = new LinkedList<MoodOccuranceAndCompetencyScore>();
        for (MoodDTO moodDTO : this.moodRepository.getAllMoodsOrderBySortIndex()) {
            list.add(new MoodOccuranceAndCompetencyScore(moodDTO.getMood(), moodDTO.getMood_es(), Integer.valueOf(0)));
        }
        for (MoodUpdate moodUpdate : moodUpdateList) {
            for (MoodOccuranceAndCompetencyScore moodOccuranceAndCompetencyScore : list) {
                if (!MoodUpdateUtils.containsMood((String)moodOccuranceAndCompetencyScore.getMood(), (String)moodUpdate.getText())) continue;
                for (MoodOccuranceAndCompetencyScore o : list) {
                    if (!o.getMood().equals(moodOccuranceAndCompetencyScore.getMood())) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                    o.getStudentIds().add(moodUpdate.getStudent_id());
                }
            }
        }
        if (isSortData) {
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        }
        return list;
    }

    public LinkedList<MoodOccurance> getMoodAnalysisByMoodUpdate(List<MoodUpdate> moodUpdateList, boolean isSortData, boolean isHappinessAltitude) {
        LinkedList<MoodOccurance> list = new LinkedList<MoodOccurance>();
        for (MoodDTO moodDTO : isHappinessAltitude ? this.moodRepository.getAllHappinessAltitudeMoodsOrderBySortIndex() : this.moodRepository.getAllMoodsOrderBySortIndex()) {
            list.add(new MoodOccurance(moodDTO.getMood(), moodDTO.getMood_es(), Double.valueOf(0.0)));
        }
        for (MoodUpdate moodUpdate : moodUpdateList) {
            for (MoodOccurance moodOccurance : list) {
                if (!MoodUpdateUtils.containsMood((String)moodOccurance.getMood(), (String)moodUpdate.getText())) continue;
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals(moodOccurance.getMood())) continue;
                    o.setCount(Double.valueOf(o.getCount() + 1.0));
                }
            }
        }
        if (isSortData) {
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        }
        return list;
    }

    public LinkedList<MoodOccurance> getMoodAnalysisByMoodUpdateAfter(List<ActivityDTO> activities, boolean isSortData, boolean isHappinessAltitude) {
        LinkedList<MoodOccurance> list = new LinkedList<MoodOccurance>();
        for (MoodDTO moodDTO : isHappinessAltitude ? this.moodRepository.getAllHappinessAltitudeMoodsOrderBySortIndex() : this.moodRepository.getAllMoodsOrderBySortIndex()) {
            list.add(new MoodOccurance(moodDTO.getMood(), moodDTO.getMood_es(), Double.valueOf(0.0)));
        }
        for (ActivityDTO activityDTO : activities) {
            for (MoodOccurance moodOccurance : list) {
                if (!MoodUpdateUtils.containsMood((String)moodOccurance.getMood(), (String)activityDTO.getMood_update_after())) continue;
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals(moodOccurance.getMood())) continue;
                    o.setCount(Double.valueOf(o.getCount() + 1.0));
                }
            }
        }
        if (isSortData) {
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        }
        return list;
    }

    public LinkedList<BigDecimal> getSelfReporting(List<Long> student_ids, Date fromDate, Date toDate, TimeZone timeZone) {
        List moodUpdateList = this.getMoodUpdateByStudentIds(student_ids, fromDate, toDate);
        LinkedList<BigDecimal> reportings = new LinkedList<BigDecimal>();
        if (AppUtils.isNotNullOrEmpty((List)moodUpdateList)) {
            Double size = moodUpdateList.size();
            System.out.println("MoodUpdate List Size - " + size + " FromDate - " + DateUtils.dayWitTimeFormat.format(fromDate) + " ToDate - " + DateUtils.dayWitTimeFormat.format(toDate));
            System.out.println("----------------------------Daily---------------------------------");
            Double days = DateUtils.getDayCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal dailyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)days);
            System.out.println("dailyReporting - " + dailyReporting + " = Size: " + size + " / Days: " + days);
            reportings.add(dailyReporting);
            System.out.println("----------------------------Weekly---------------------------------");
            Double weeks = DateUtils.getWeekCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal weeklyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)weeks);
            System.out.println("weeklyReporting - " + weeklyReporting + " = Size: " + size + " / Weeks: " + weeks);
            reportings.add(weeklyReporting);
            System.out.println("----------------------------Monthly---------------------------------");
            Double months = DateUtils.getMonthCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal monthlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)months);
            System.out.println("monthlyReporting - " + monthlyReporting + " = Size: " + size + " / Months: " + months);
            reportings.add(monthlyReporting);
            System.out.println("----------------------------Yearly---------------------------------");
            Double years = DateUtils.getYearCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal yearlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)years);
            System.out.println("yearlyReporting - " + yearlyReporting + " = Size: " + size + " / Years: " + years);
            reportings.add(yearlyReporting);
        } else {
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
        }
        return reportings;
    }

    public List<MoodUpdate> getMoodUpdateByStudentIds(List<Long> student_ids, Date fromDate, Date toDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(MoodUpdate.class);
        Root root = query.from(MoodUpdate.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!AppUtils.isNotNullOrEmpty(student_ids)) {
            return new ArrayList<MoodUpdate>();
        }
        CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student_id")).value(student_ids);
        predicates.add(genderPredicate);
        if (fromDate != null && toDate != null) {
            System.out.println("getMoodUpdateByStudentIds FromDate " + DateUtils.dailyDateFormat.format(fromDate) + " - ToDate " + DateUtils.dailyDateFormat.format(toDate));
            predicates.add(criteriaBuilder.between((Expression)root.get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        }
        query.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("createdAt"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List moodUpdateList = typedQuery.getResultList();
        System.out.println("MoodUpdate Count = " + moodUpdateList.size());
        return moodUpdateList;
    }

    private GetDataDashBoardRequest getGetDataDashBoardRequestWithReqeuest(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = new GetDataDashBoardRequest();
        getDataDashBoardRequest.setTimeLine(request.getTimeLine());
        getDataDashBoardRequest.setSocio_emotional_test_question_type_id(request.getSocio_emotional_test_question_type_id());
        getDataDashBoardRequest.setGraphType(request.getGraphType());
        getDataDashBoardRequest.setFromDate(request.getFromDate());
        getDataDashBoardRequest.setToDate(request.getToDate());
        getDataDashBoardRequest.setTimeZone(request.getTimeZone());
        return getDataDashBoardRequest;
    }

    public LinkedList<MoodInsight> getMoodInsight(GetDataDashBoardRequest request) {
        LinkedList<MoodInsight> moodInsightList = new LinkedList<MoodInsight>();
        List activities = this.activityService.getMoodInsight(request);
        for (Activity activity : activities) {
            MoodInsight moodInsight = new MoodInsight();
            if (activity.getStudent() != null) {
                moodInsight.setStudent_name(activity.getStudent().getFirst_name() + " " + activity.getStudent().getLast_name());
            }
            MoodUpdateDTO before = this.restComponent.getSelfAwarenessById(activity.getMood_update_id_before());
            moodInsight.setMood_before(this.getNAIfNull(before.getText()) + " (" + activity.getLevel_of_focus_before() + ")");
            Lesson lesson = this.lessonRepository.findByLessonId(Long.valueOf(activity.getEntity_id()));
            if (lesson != null) {
                moodInsight.setVideo_watched(lesson.getGuide_post_text());
            }
            MoodUpdateDTO after = this.restComponent.getSelfAwarenessById(activity.getMood_update_id_after());
            moodInsight.setMood_after(this.getNAIfNull(after.getText()) + " (" + activity.getLevel_of_focus_after() + ")");
            moodInsightList.add(moodInsight);
        }
        return moodInsightList;
    }

    public LinkedList<MoodInsight> getMoodInsightByInstructerId(GetDataDashBoardRequest request) {
        LinkedList<MoodInsight> moodInsightList = new LinkedList<MoodInsight>();
        List activities = this.activityService.getMoodInsightByInstructerId(request);
        for (Activity activity : activities) {
            MoodInsight moodInsight = new MoodInsight();
            if (activity.getStudent() != null) {
                moodInsight.setStudent_name(activity.getStudent().getFirst_name() + " " + activity.getStudent().getLast_name());
            }
            MoodUpdateDTO before = this.restComponent.getSelfAwarenessById(activity.getMood_update_id_before());
            moodInsight.setMood_before(this.getNAIfNull(before.getText()) + " (" + activity.getLevel_of_focus_before() + ")");
            Lesson lesson = this.lessonRepository.findByLessonId(Long.valueOf(activity.getEntity_id()));
            if (lesson != null) {
                moodInsight.setVideo_watched(lesson.getGuide_post_text());
            }
            MoodUpdateDTO after = this.restComponent.getSelfAwarenessById(activity.getMood_update_id_before());
            moodInsight.setMood_after(this.getNAIfNull(after.getText()) + " (" + activity.getLevel_of_focus_after() + ")");
            moodInsightList.add(moodInsight);
        }
        return moodInsightList;
    }

    public LinkedList<MoodInsightPost> getMoodInsightPost(GetDataDashBoardRequest request) {
        LinkedList<MoodInsightPost> moodInsightPostList = new LinkedList<MoodInsightPost>();
        List activities = this.activityCriteriaRepository.getMoodInsightPost(request);
        for (ActivityDTO activity : activities) {
            PostDTO post = this.postRepository.findById(activity.getEntity_id());
            if (post == null) continue;
            MoodInsightPost moodInsightPost = new MoodInsightPost();
            moodInsightPost.setMood_before(this.getNAIfNull(activity.getMood_update_before()) + " (" + activity.getLevel_of_focus_before() + ")");
            moodInsightPost.setPost_type(post.getPost_type());
            moodInsightPost.setPost_viewed(post.getPost_title());
            moodInsightPost.setMood_after(this.getNAIfNull(activity.getMood_update_after()) + " (" + activity.getLevel_of_focus_after() + ")");
            moodInsightPostList.add(moodInsightPost);
        }
        return moodInsightPostList;
    }

    public LinkedHashMap<String, MoodInsightsPostBeforeAfterResponse> getMoodBeforeAndMoodAfter(GetDataDashBoardRequest request, String language) {
        return this.getMoodInsightsPostByActivities(this.activityCriteriaRepository.getMoodInsightPost(request), language);
    }

    public LinkedList<MoodInsightPost> getMoodInsightPostInstructor(GetDataDashBoardRequest request) {
        List activities = this.activityService.getMoodInsightPostByInstructerId(request);
        return this.getMoodInsightPostByActivities(activities);
    }

    public LinkedList<MoodInsightPost> getMoodInsightPostParent(GetDataDashBoardRequest request) {
        List activities = this.activityService.getMoodInsightPostByParentId(request);
        return this.getMoodInsightPostByActivities(activities);
    }

    public LinkedList<MoodInsightPost> getMoodInsightPostByActivities(List<Activity> activities) {
        LinkedList<MoodInsightPost> moodInsightPostList = new LinkedList<MoodInsightPost>();
        Set entityIds = activities.stream().map(Activity::getEntity_id).collect(Collectors.toSet());
        List posts = this.postRepository.findByIds(entityIds);
        Map<Long, PostDTO> postMap = posts.stream().collect(Collectors.toMap(PostDTO::getPost_id, post -> post));
        for (Activity activity : activities) {
            MoodUpdateDTO before;
            PostDTO post2 = postMap.get(activity.getEntity_id());
            if (post2 == null) continue;
            MoodInsightPost moodInsightPost = new MoodInsightPost();
            if (activity.getStudent() != null) {
                moodInsightPost.setStudent_name(activity.getStudent().getFirst_name() + " " + activity.getStudent().getLast_name());
            }
            if ((before = this.restComponent.getSelfAwarenessById(activity.getMood_update_id_before())) != null) {
                boolean isSpanish = Language.isSpanish();
                String moodBefore = isSpanish ? before.getText_es() : before.getText();
                String subMoodBefore = isSpanish ? before.getSub_mood_text_es() : before.getSub_mood_text();
                moodInsightPost.setMood_before(this.getNAIfNull(moodBefore) + " (" + before.getLevel_of_focus() + ")");
                moodInsightPost.setSub_mood_before(this.getNAIfNull(subMoodBefore) + " (" + before.getLevel_of_focus() + ")");
            }
            moodInsightPost.setPost_type(post2.getPost_type());
            moodInsightPost.setPost_viewed(post2.getPost_title());
            moodInsightPost.setPost_viewed_es(post2.getPost_title_es());
            MoodUpdateDTO after = this.restComponent.getSelfAwarenessById(activity.getMood_update_id_after());
            if (after != null) {
                boolean isSpanish = Language.isSpanish();
                String moodAfter = isSpanish ? after.getText_es() : after.getText();
                String subMoodAfter = isSpanish ? after.getSub_mood_text_es() : after.getSub_mood_text();
                moodInsightPost.setMood_after(this.getNAIfNull(moodAfter) + " (" + after.getLevel_of_focus() + ")");
                moodInsightPost.setSub_mood_after(this.getNAIfNull(subMoodAfter) + " (" + after.getLevel_of_focus() + ")");
            }
            moodInsightPostList.add(moodInsightPost);
        }
        return moodInsightPostList;
    }

    private String getNAIfNull(String strValue) {
        if (strValue == null) {
            return "N/A";
        }
        return strValue;
    }

    private String getESNAIfMoodNull(MoodDTO mood) {
        if (mood == null) {
            return "N/A";
        }
        return mood.getMood_es();
    }

    public LinkedHashMap<String, MoodInsightsPostBeforeAfterResponse> getMoodInsightsPostByActivities(List<ActivityDTO> activities, String language) {
        LinkedList<MoodOccurance> listBefore = new LinkedList<MoodOccurance>();
        LinkedList<MoodOccurance> listAfter = new LinkedList<MoodOccurance>();
        for (MoodDTO m : this.moodRepository.getAllMoodsOrderBySortIndex()) {
            listBefore.add(new MoodOccurance(m.getMood(), m.getMood_es(), Double.valueOf(0.0)));
            listAfter.add(new MoodOccurance(m.getMood(), m.getMood_es(), Double.valueOf(0.0)));
        }
        for (ActivityDTO activity : activities) {
            for (MoodOccurance moodOccurance : listBefore) {
                if (!MoodUpdateUtils.containsMood((String)moodOccurance.getMood(), (String)activity.getMood_update_before())) continue;
                for (MoodOccurance o : listBefore) {
                    if (!o.getMood().equals(moodOccurance.getMood())) continue;
                    o.setCount(Double.valueOf(o.getCount() + 1.0));
                }
            }
            for (MoodOccurance moodOccurance : listAfter) {
                if (!MoodUpdateUtils.containsMood((String)moodOccurance.getMood(), (String)activity.getMood_update_after())) continue;
                for (MoodOccurance o : listAfter) {
                    if (!o.getMood().equals(moodOccurance.getMood())) continue;
                    o.setCount(Double.valueOf(o.getCount() + 1.0));
                }
            }
        }
        LinkedHashMap<String, Object> before_en = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> before_es = new LinkedHashMap<String, Object>();
        for (MoodOccurance o : listBefore) {
            LinkedList<Double> list = new LinkedList<Double>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)o.getCount()));
            list.add(DigitUtils.getPercentageInTwoDigit((Double)o.getCount(), (Double)Double.valueOf(activities.size())));
            before_en.put(o.getMood(), list);
            if (!Language.isSpanish((String)language)) continue;
            before_es.put(o.getMood_es(), list);
        }
        LinkedHashMap after_en = new LinkedHashMap();
        LinkedHashMap after_es = new LinkedHashMap();
        for (MoodOccurance o : listAfter) {
            LinkedList<Double> list = new LinkedList<Double>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)o.getCount()));
            list.add(DigitUtils.getPercentageInTwoDigit((Double)o.getCount(), (Double)Double.valueOf(activities.size())));
            after_en.put(o.getMood(), list);
            if (!Language.isSpanish((String)language)) continue;
            after_es.put(o.getMood_es(), list);
        }
        LinkedHashMap<String, MoodInsightsPostBeforeAfterResponse> graphData = new LinkedHashMap<String, MoodInsightsPostBeforeAfterResponse>();
        graphData.put("en", new MoodInsightsPostBeforeAfterResponse(before_en, after_en));
        if (Language.isSpanish((String)language)) {
            graphData.put("es", new MoodInsightsPostBeforeAfterResponse(before_es, after_es));
        }
        return graphData;
    }
}

