/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.data.service;

import com.infinite.focus.server.assessment.model.AssessmentOccurrence;
import com.infinite.focus.server.data.model.DataGraphType;
import com.infinite.focus.server.data.model.EmotionCountAndAverage;
import com.infinite.focus.server.data.model.EmotionOccurrenceAndAverage;
import com.infinite.focus.server.data.model.EmotionsByStandards;
import com.infinite.focus.server.data.model.SubEmotionCountAndAverage;
import com.infinite.focus.server.data.model.SubMoodByStandardOccurrence;
import com.infinite.focus.server.data.request.DataApiRequest;
import com.infinite.focus.server.data.service.DataService;
import com.infinite.focus.server.data.service.DataServiceImpl;
import com.infinite.focus.server.data.wrapper.SocioEmotionalDataWrapper;
import com.infinite.focus.server.dataset.model.AssessmentChildCategory;
import com.infinite.focus.server.grade.repository.GradeRepository;
import com.infinite.focus.server.grade.view.GradeView;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.group.view.ClassView;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.moodupdate.repository.MoodUpdateRepository;
import com.infinite.focus.server.relationshipskills.repository.RelationshipSkillsUpdateCriteriaRepository;
import com.infinite.focus.server.responsibledecisionmaking.repository.ResponsibleDecisionMakingUpdateCriteriaRepository;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.selfmanagement.repository.SelfManagementUpdateCriteriaRepository;
import com.infinite.focus.server.socialawareness.repository.SocialAwarenessUpdateCriteriaRepository;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.repository.SocioEmotionalTestResultRepository;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentCriteriaRepository;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.submood.model.SubMoodOccurrence;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DataServiceImpl
implements DataService {
    private final RestComponent restComponent;
    private final StudentRepository studentRepository;
    private final StudentCriteriaRepository studentCriteriaRepository;
    private final MoodUpdateRepository moodUpdateRepository;
    private final ResponsibleDecisionMakingUpdateCriteriaRepository responsibleDecisionMakingUpdateCriteriaRepository;
    private final SelfManagementUpdateCriteriaRepository selfManagementUpdateCriteriaRepository;
    private final SocialAwarenessUpdateCriteriaRepository socialAwarenessUpdateCriteriaRepository;
    private final RelationshipSkillsUpdateCriteriaRepository relationshipSkillsUpdateCriteriaRepository;
    private final ClassService classService;
    private final MessageService messageService;
    private final GradeRepository gradeRepository;
    private final SocioEmotionalTestResultRepository socioEmotionalTestResultRepository;

    public DataServiceImpl(RestComponent restComponent, StudentRepository studentRepository, StudentCriteriaRepository studentCriteriaRepository, MoodUpdateRepository moodUpdateRepository, ResponsibleDecisionMakingUpdateCriteriaRepository responsibleDecisionMakingUpdateCriteriaRepository, SelfManagementUpdateCriteriaRepository selfManagementUpdateCriteriaRepository, SocialAwarenessUpdateCriteriaRepository socialAwarenessUpdateCriteriaRepository, RelationshipSkillsUpdateCriteriaRepository relationshipSkillsUpdateCriteriaRepository, ClassService classService, MessageService messageService, GradeRepository gradeRepository, SocioEmotionalTestResultRepository socioEmotionalTestResultRepository) {
        this.restComponent = restComponent;
        this.studentRepository = studentRepository;
        this.studentCriteriaRepository = studentCriteriaRepository;
        this.moodUpdateRepository = moodUpdateRepository;
        this.responsibleDecisionMakingUpdateCriteriaRepository = responsibleDecisionMakingUpdateCriteriaRepository;
        this.selfManagementUpdateCriteriaRepository = selfManagementUpdateCriteriaRepository;
        this.socialAwarenessUpdateCriteriaRepository = socialAwarenessUpdateCriteriaRepository;
        this.relationshipSkillsUpdateCriteriaRepository = relationshipSkillsUpdateCriteriaRepository;
        this.classService = classService;
        this.messageService = messageService;
        this.gradeRepository = gradeRepository;
        this.socioEmotionalTestResultRepository = socioEmotionalTestResultRepository;
    }

    public Object getSELAnalytics(DataApiRequest request) {
        ArrayList<Long> studentIds = new ArrayList<Long>();
        studentIds.add(request.getStudent_id());
        return this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), studentIds, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory());
    }

    public Object getSELAnalyticsByClass(DataApiRequest request) {
        List studentIds;
        LinkedHashMap responseMap = new LinkedHashMap();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, Object> genderMap = new LinkedHashMap<String, Object>();
            for (String gender : request.getGenders()) {
                ArrayList<String> genders = new ArrayList<String>();
                genders.add(gender);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), genders, null, null, null, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                genderMap.put(gender, this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), studentIds, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory()));
            }
            responseMap.put("Gender", genderMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, Object> ageMap = new LinkedHashMap<String, Object>();
            for (Integer age : request.getAges()) {
                ArrayList<Integer> ages = new ArrayList<Integer>();
                ages.add(age);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), null, ages, null, null, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                ageMap.put(String.valueOf(age), this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), studentIds, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory()));
            }
            responseMap.put("Age", ageMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, Object> ethnicityMap = new LinkedHashMap<String, Object>();
            for (String ethnicity : request.getEthnicity()) {
                ArrayList<String> ethnicityItemList = new ArrayList<String>();
                ethnicityItemList.add(ethnicity);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), null, null, ethnicityItemList, null, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                ethnicityMap.put(ethnicity, this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), studentIds, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory()));
            }
            responseMap.put("Ethnicity", ethnicityMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, Object> gradeMap = new LinkedHashMap<String, Object>();
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                ArrayList<Long> gradeIds = new ArrayList<Long>();
                gradeIds.add(grade_id);
                List studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), null, null, null, gradeIds, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                gradeMap.put(gradeView.getGrade_name(), this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), studentIds2, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory()));
            }
            responseMap.put("Grade", gradeMap);
        }
        if (!responseMap.isEmpty()) {
            return responseMap;
        }
        List studentIds3 = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), null, null, null, null, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
        return this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), studentIds3, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory());
    }

    public Object getSELAnalyticsBySchool(DataApiRequest request) {
        List studentIds;
        List studentIds2;
        LinkedHashMap responseMap = new LinkedHashMap();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, Object> genderMap = new LinkedHashMap<String, Object>();
            for (String gender : request.getGenders()) {
                ArrayList<String> genders = new ArrayList<String>();
                genders.add(gender);
                studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), genders, null, null, null, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                genderMap.put(gender, this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), studentIds2, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory()));
            }
            responseMap.put("Gender", genderMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, Object> ageMap = new LinkedHashMap<String, Object>();
            for (Integer age : request.getAges()) {
                ArrayList<Integer> ages = new ArrayList<Integer>();
                ages.add(age);
                studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, ages, null, null, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                ageMap.put(String.valueOf(age), this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), studentIds2, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory()));
            }
            responseMap.put("Age", ageMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, Object> ethnicityMap = new LinkedHashMap<String, Object>();
            for (String ethnicity : request.getEthnicity()) {
                ArrayList<String> ethnicityItemList = new ArrayList<String>();
                ethnicityItemList.add(ethnicity);
                studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, ethnicityItemList, null, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                ethnicityMap.put(ethnicity, this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), studentIds2, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory()));
            }
            responseMap.put("Ethnicity", ethnicityMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, Object> gradeMap = new LinkedHashMap<String, Object>();
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                ArrayList<Long> gradeIds = new ArrayList<Long>();
                gradeIds.add(grade_id);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, null, gradeIds, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                gradeMap.put(gradeView.getGrade_name(), this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), studentIds, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory()));
            }
            responseMap.put("Grade", gradeMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            LinkedHashMap<String, Object> classMap = new LinkedHashMap<String, Object>();
            for (Long class_id : request.getClassIds()) {
                ClassView classView = this.classService.findByClassId(class_id.longValue());
                ArrayList<Long> classIds = new ArrayList<Long>();
                classIds.add(class_id);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, null, null, classIds, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                classMap.put(classView.getClass_name(), this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), studentIds, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory()));
            }
            responseMap.put("Classroom", classMap);
        }
        if (!responseMap.isEmpty()) {
            return responseMap;
        }
        List studentIds3 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, null, null, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
        return this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(request.isFrom_mobile(), studentIds3, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory());
    }

    public Object getSELAnalyticsBySchool2(DataApiRequest request) {
        Object ethnicityList;
        List studentIds;
        List studentIds2;
        LinkedHashMap responseMap = new LinkedHashMap();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, Object> genderMap = new LinkedHashMap<String, Object>();
            for (String gender : request.getGenders()) {
                ArrayList<String> genders = new ArrayList<String>();
                genders.add(gender);
                studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), genders, null, null, null, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                Object genderList = this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDate2(studentIds2, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory());
                genderMap.put(gender, genderList);
            }
            responseMap.put("Gender", genderMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, Object> ageMap = new LinkedHashMap<String, Object>();
            for (Integer age : request.getAges()) {
                ArrayList<Integer> ages = new ArrayList<Integer>();
                ages.add(age);
                studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, ages, null, null, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                Object ageList = this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDate2(studentIds2, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory());
                ageMap.put(String.valueOf(age), ageList);
            }
            responseMap.put("Age", ageMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, Object> ethnicityMap = new LinkedHashMap<String, Object>();
            for (String ethnicity : request.getEthnicity()) {
                ArrayList<String> ethnicityItemList = new ArrayList<String>();
                ethnicityItemList.add(ethnicity);
                studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, ethnicityItemList, null, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                Object ethnicityList2 = this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDate2(studentIds2, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory());
                ethnicityMap.put(ethnicity, ethnicityList2);
            }
            responseMap.put("Ethnicity", ethnicityMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, Object> gradeMap = new LinkedHashMap<String, Object>();
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                ArrayList<Long> gradeIds = new ArrayList<Long>();
                gradeIds.add(grade_id);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, null, gradeIds, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                ethnicityList = this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDate2(studentIds, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory());
                gradeMap.put(gradeView.getGrade_name(), ethnicityList);
            }
            responseMap.put("Grade", gradeMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            LinkedHashMap<String, Object> classMap = new LinkedHashMap<String, Object>();
            for (Long class_id : request.getClassIds()) {
                ClassView classView = this.classService.findByClassId(class_id.longValue());
                ArrayList<Long> classIds = new ArrayList<Long>();
                classIds.add(class_id);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, null, null, classIds, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
                ethnicityList = this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDate2(studentIds, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory());
                classMap.put(classView.getClass_name(), ethnicityList);
            }
            responseMap.put("Classroom", classMap);
        }
        if (!responseMap.isEmpty()) {
            return responseMap;
        }
        List studentIds3 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, null, null, null, null, null, !request.getDataGraphType().equals((Object)DataGraphType.SELF_AWARENESS));
        return this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDate2(studentIds3, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory());
    }

    private List<SubMoodOccurrence> setOccurrenceAndAverage(long studentCount, EmotionCountAndAverage e, List<SubEmotionCountAndAverage> subMoodOccurrences) {
        return subMoodOccurrences.stream().map(s -> {
            SubMoodOccurrence build = SubMoodOccurrence.builder().mood_id(e.getEmotion_id()).text_to_display(s.getSub_emotion()).text_to_display_es(s.getSub_emotion_es()).count(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)s.getCount() / (double)studentCount)).doubleValue()).occurrence(s.getCount()).occurrence_average(s.getAverage()).sub_emotions(this.setOccurrenceAndAverage(studentCount, e, s.getSub_emotions())).build();
            return build;
        }).collect(Collectors.toList());
    }

    public List<AssessmentOccurrence> getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDate(List<Long> studentIds, Date fromDate, Date toDate, DataGraphType dataGraphType, AssessmentChildCategory assessmentChildCategory) {
        switch (1.$SwitchMap$com$infinite$focus$server$data$model$DataGraphType[dataGraphType.ordinal()]) {
            case 1: {
                List emotionCountAndAverages = this.restComponent.getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate(studentIds, fromDate, toDate);
                return emotionCountAndAverages.stream().map(e -> AssessmentOccurrence.builder().mood_id(e.getEmotion_id()).text_to_display(e.getEmotion()).text_to_display_es(e.getEmotion_es()).count(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)e.getCount() / (double)studentIds.size())).doubleValue()).occurrence(e.getCount()).occurrence_average(e.getAverage()).sub_emotions(SubMoodByStandardOccurrence.builder()._k_2(this.setOccurrenceAndAverage((long)studentIds.size(), e, e.getSub_emotions().get_k_2()))._3_5(this.setOccurrenceAndAverage((long)studentIds.size(), e, e.getSub_emotions().get_3_5()))._6_12(this.setOccurrenceAndAverage((long)studentIds.size(), e, e.getSub_emotions().get_6_12())).build()).build()).collect(Collectors.toList());
            }
            case 2: {
                return this.responsibleDecisionMakingUpdateCriteriaRepository.getChoicesAnalysisByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
            }
            case 3: {
                return this.selfManagementUpdateCriteriaRepository.getMotivationAnalysisByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
            }
            case 4: {
                return this.socialAwarenessUpdateCriteriaRepository.getFriendshipAnalysisByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
            }
            case 5: {
                return this.relationshipSkillsUpdateCriteriaRepository.getFriendshipAnalysisByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate, assessmentChildCategory);
            }
        }
        throw new IllegalArgumentException(this.messageService.getMessage("unknown.data.graph.type") + " " + dataGraphType);
    }

    public static List<SubMoodOccurrence> setOccurrenceAndAverage2(long studentCount, EmotionOccurrenceAndAverage e, List<SubEmotionCountAndAverage> subMoodOccurrences) {
        return subMoodOccurrences.stream().map(s -> {
            SubMoodOccurrence build = SubMoodOccurrence.builder().mood_id(e.getEmotion_id()).text_to_display(s.getSub_emotion()).text_to_display_es(s.getSub_emotion_es()).color(s.getColor()).count(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)s.getCount() / (double)studentCount)).doubleValue()).occurrence(s.getCount()).occurrence_average(s.getAverage()).sub_emotions(DataServiceImpl.setOccurrenceAndAverage2((long)studentCount, (EmotionOccurrenceAndAverage)e, (List)s.getSub_emotions())).build();
            return build;
        }).collect(Collectors.toList());
    }

    public static List<SubMoodOccurrence> setSubMoodOccurrence(long studentCount, List<EmotionOccurrenceAndAverage> emotionCountAndAverages) {
        ArrayList<SubMoodOccurrence> subMoodOccurrences = new ArrayList<SubMoodOccurrence>();
        for (EmotionOccurrenceAndAverage e : emotionCountAndAverages) {
            subMoodOccurrences.add(SubMoodOccurrence.builder().mood_id(e.getEmotion_id()).text_to_display(e.getEmotion()).text_to_display_es(e.getEmotion_es()).color(e.getColor()).count(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)e.getCount() / (double)studentCount)).doubleValue()).occurrence(e.getCount()).occurrence_average(e.getAverage()).sub_emotions(DataServiceImpl.setOccurrenceAndAverage2((long)studentCount, (EmotionOccurrenceAndAverage)e, (List)e.getSub_emotions())).build());
        }
        return subMoodOccurrences;
    }

    public Object getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDate2(List<Long> studentIds, Date fromDate, Date toDate, DataGraphType dataGraphType, AssessmentChildCategory assessmentChildCategory) {
        switch (1.$SwitchMap$com$infinite$focus$server$data$model$DataGraphType[dataGraphType.ordinal()]) {
            case 1: {
                SubMoodByStandardOccurrence subMoodByStandardOccurrence = new SubMoodByStandardOccurrence();
                EmotionsByStandards emotionCountAndAverages = this.restComponent.getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate2(studentIds, fromDate, toDate);
                subMoodByStandardOccurrence.set_k_2(DataServiceImpl.setSubMoodOccurrence((long)studentIds.size(), (List)emotionCountAndAverages.get_k_2()));
                subMoodByStandardOccurrence.set_3_5(DataServiceImpl.setSubMoodOccurrence((long)studentIds.size(), (List)emotionCountAndAverages.get_3_5()));
                subMoodByStandardOccurrence.set_6_12(DataServiceImpl.setSubMoodOccurrence((long)studentIds.size(), (List)emotionCountAndAverages.get_6_12()));
                return subMoodByStandardOccurrence;
            }
            case 2: {
                return this.restComponent.getChoicesAnalysisByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
            }
            case 3: {
                return this.restComponent.getMotivationAnalysisByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
            }
            case 4: {
                return this.restComponent.getFriendshipAnalysisByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
            }
            case 5: {
                return this.restComponent.getFriendshipAnalysisByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate, assessmentChildCategory);
            }
        }
        throw new IllegalArgumentException(this.messageService.getMessage("unknown.data.graph.type") + " " + dataGraphType);
    }

    public Object getSocioEmotionalRecordsByClass(DataApiRequest request) {
        List studentIds;
        LinkedHashMap responseMap = new LinkedHashMap();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, List> genderMap = new LinkedHashMap<String, List>();
            for (String gender : request.getGenders()) {
                ArrayList<String> genders = new ArrayList<String>();
                genders.add(gender);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), genders, null, null, null, null, null, null, false);
                List genderList = this.getSocioEmotionalDataByStudentIdsAndBetweenFromDateAndToDate(studentIds, request.getFromDate(), request.getToDate());
                genderMap.put(gender, genderList);
            }
            responseMap.put("Gender", genderMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, List> ageMap = new LinkedHashMap<String, List>();
            for (Integer age : request.getAges()) {
                ArrayList<Integer> ages = new ArrayList<Integer>();
                ages.add(age);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), null, ages, null, null, null, null, null, false);
                List ageList = this.getSocioEmotionalDataByStudentIdsAndBetweenFromDateAndToDate(studentIds, request.getFromDate(), request.getToDate());
                ageMap.put(String.valueOf(age), ageList);
            }
            responseMap.put("Age", ageMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, List> ethnicityMap = new LinkedHashMap<String, List>();
            for (String ethnicity : request.getEthnicity()) {
                ArrayList<String> ethnicityItemList = new ArrayList<String>();
                ethnicityItemList.add(ethnicity);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), null, null, ethnicityItemList, null, null, null, null, false);
                List ethnicityList = this.getSocioEmotionalDataByStudentIdsAndBetweenFromDateAndToDate(studentIds, request.getFromDate(), request.getToDate());
                ethnicityMap.put(ethnicity, ethnicityList);
            }
            responseMap.put("Ethnicity", ethnicityMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, List> gradeMap = new LinkedHashMap<String, List>();
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                ArrayList<Long> gradeIds = new ArrayList<Long>();
                gradeIds.add(grade_id);
                List studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), null, null, null, gradeIds, null, null, null, false);
                List gradeList = this.getSocioEmotionalDataByStudentIdsAndBetweenFromDateAndToDate(studentIds2, request.getFromDate(), request.getToDate());
                gradeMap.put(gradeView.getGrade_name(), gradeList);
            }
            responseMap.put("Grade", gradeMap);
        }
        if (!responseMap.isEmpty()) {
            return responseMap;
        }
        List studentIds3 = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), null, null, null, null, null, null, null, false);
        return this.getSocioEmotionalDataByStudentIdsAndBetweenFromDateAndToDate(studentIds3, request.getFromDate(), request.getToDate());
    }

    public Object getSocioEmotionalRecordsBySchool(DataApiRequest request) {
        List gradeList;
        List studentIds;
        List studentIds2;
        LinkedHashMap responseMap = new LinkedHashMap();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, List> genderMap = new LinkedHashMap<String, List>();
            for (String gender : request.getGenders()) {
                ArrayList<String> genders = new ArrayList<String>();
                genders.add(gender);
                studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), genders, null, null, null, null, null, null, false);
                List genderList = this.getSocioEmotionalDataByStudentIdsAndBetweenFromDateAndToDate(studentIds2, request.getFromDate(), request.getToDate());
                genderMap.put(gender, genderList);
            }
            responseMap.put("Gender", genderMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, List> ageMap = new LinkedHashMap<String, List>();
            for (Integer age : request.getAges()) {
                ArrayList<Integer> ages = new ArrayList<Integer>();
                ages.add(age);
                studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, ages, null, null, null, null, null, false);
                List ageList = this.getSocioEmotionalDataByStudentIdsAndBetweenFromDateAndToDate(studentIds2, request.getFromDate(), request.getToDate());
                ageMap.put(String.valueOf(age), ageList);
            }
            responseMap.put("Age", ageMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, List> ethnicityMap = new LinkedHashMap<String, List>();
            for (String ethnicity : request.getEthnicity()) {
                ArrayList<String> ethnicityItemList = new ArrayList<String>();
                ethnicityItemList.add(ethnicity);
                studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, ethnicityItemList, null, null, null, null, false);
                List ethnicityList = this.getSocioEmotionalDataByStudentIdsAndBetweenFromDateAndToDate(studentIds2, request.getFromDate(), request.getToDate());
                ethnicityMap.put(ethnicity, ethnicityList);
            }
            responseMap.put("Ethnicity", ethnicityMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, List> gradeMap = new LinkedHashMap<String, List>();
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                ArrayList<Long> gradeIds = new ArrayList<Long>();
                gradeIds.add(grade_id);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, null, gradeIds, null, null, null, false);
                gradeList = this.getSocioEmotionalDataByStudentIdsAndBetweenFromDateAndToDate(studentIds, request.getFromDate(), request.getToDate());
                gradeMap.put(gradeView.getGrade_name(), gradeList);
            }
            responseMap.put("Grade", gradeMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            LinkedHashMap<String, List> classMap = new LinkedHashMap<String, List>();
            for (Long class_id : request.getClassIds()) {
                ClassView classView = this.classService.findByClassId(class_id.longValue());
                ArrayList<Long> classIds = new ArrayList<Long>();
                classIds.add(class_id);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, null, null, classIds, null, null, false);
                gradeList = this.getSocioEmotionalDataByStudentIdsAndBetweenFromDateAndToDate(studentIds, request.getFromDate(), request.getToDate());
                classMap.put(classView.getClass_name(), gradeList);
            }
            responseMap.put("Classroom", classMap);
        }
        if (!responseMap.isEmpty()) {
            return responseMap;
        }
        List studentIds3 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, null, null, null, null, null, false);
        return this.getSocioEmotionalDataByStudentIdsAndBetweenFromDateAndToDate(studentIds3, request.getFromDate(), request.getToDate());
    }

    public List<SocioEmotionalDataWrapper> getSocioEmotionalDataByStudentIdsAndBetweenFromDateAndToDate(List<Long> student_ids, Date fromDate, Date toDate) {
        ArrayList<SocioEmotionalDataWrapper> list = new ArrayList<SocioEmotionalDataWrapper>();
        List socioEmotionalTestResultList = new ArrayList();
        if (AppUtils.isNotNullOrEmpty(student_ids)) {
            socioEmotionalTestResultList = this.socioEmotionalTestResultRepository.findByStudentIdsAndBetweenFromDateAndEndDate(student_ids, fromDate, toDate);
        }
        for (SocioEmotionalTestResult t : socioEmotionalTestResultList) {
            boolean found = false;
            for (SocioEmotionalDataWrapper sdw : list) {
                if (t.getCreatedAt().getMonth() + 1 != sdw.month || t.getCreatedAt().getYear() + 1900 != sdw.year) continue;
                sdw.score += t.score;
                ++sdw.count;
                found = true;
            }
            if (found) continue;
            list.add(new SocioEmotionalDataWrapper(t.score, 1, t.getCreatedAt().getMonth() + 1, t.getCreatedAt().getYear() + 1900));
        }
        for (SocioEmotionalDataWrapper a : list) {
            a.score /= a.count;
        }
        Collections.sort(list, Comparator.comparing(SocioEmotionalDataWrapper::getYear).thenComparing(SocioEmotionalDataWrapper::getMonth));
        return list;
    }

    public List<AssessmentOccurrence> getSELAnalyticsByInstructor(DataApiRequest request) {
        List studentIds = this.studentRepository.findByInstructorIdWhichCompletedFirstLoginAndAccessCodeAcceptedOrderByFirstNameASC(request.getInstructor_id()).stream().map(Student::getStudent_id).collect(Collectors.toList());
        return this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDate(studentIds, request.getFromDate(), request.getToDate(), request.getDataGraphType(), request.getAssessmentChildCategory());
    }

    public LinkedHashMap<String, Object> getMoodInsightsPost(DataApiRequest request, String language) {
        Student student = this.studentRepository.findByStudentId(request.getStudent_id());
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.student.is.not.found"));
        }
        ArrayList<Long> studentIds = new ArrayList<Long>();
        studentIds.add(student.getStudent_id());
        return this.restComponent.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate(studentIds, request.getFromDate(), request.getToDate(), language);
    }

    public LinkedHashMap<String, Object> getMoodInsightsPostByInstructor(DataApiRequest request, String language) {
        List studentIds = this.studentRepository.findByInstructorIdWhichCompletedFirstLoginAndAccessCodeAcceptedOrderByFirstNameASC(request.getInstructor_id()).stream().map(Student::getStudent_id).collect(Collectors.toList());
        return this.restComponent.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate(studentIds, request.getFromDate(), request.getToDate(), language);
    }

    public Object getMoodInsightsPostByClass(DataApiRequest request, String language) {
        List studentIds;
        ClassView class_ = this.classService.findByClassId(request.getClass_id().longValue());
        if (class_ == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.class.is.not.found"));
        }
        LinkedHashMap responseMap = new LinkedHashMap();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedHashMap> genderMap = new LinkedHashMap<String, LinkedHashMap>();
            for (String gender : request.getGenders()) {
                ArrayList<String> genders = new ArrayList<String>();
                genders.add(gender);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), genders, null, null, null, null, null, null, false);
                LinkedHashMap genderList = this.restComponent.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate(studentIds, request.getFromDate(), request.getToDate(), language);
                genderMap.put(gender, genderList);
            }
            responseMap.put("Gender", genderMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedHashMap> ageMap = new LinkedHashMap<String, LinkedHashMap>();
            for (Integer age : request.getAges()) {
                ArrayList<Integer> ages = new ArrayList<Integer>();
                ages.add(age);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), null, ages, null, null, null, null, null, false);
                LinkedHashMap ageList = this.restComponent.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate(studentIds, request.getFromDate(), request.getToDate(), language);
                ageMap.put(String.valueOf(age), ageList);
            }
            responseMap.put("Age", ageMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedHashMap> ethnicityMap = new LinkedHashMap<String, LinkedHashMap>();
            for (String ethnicity : request.getEthnicity()) {
                ArrayList<String> ethnicityItemList = new ArrayList<String>();
                ethnicityItemList.add(ethnicity);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), null, null, ethnicityItemList, null, null, null, null, false);
                LinkedHashMap ethnicityList = this.restComponent.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate(studentIds, request.getFromDate(), request.getToDate(), language);
                ethnicityMap.put(ethnicity, ethnicityList);
            }
            responseMap.put("Ethnicity", ethnicityMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedHashMap> gradeMap = new LinkedHashMap<String, LinkedHashMap>();
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                ArrayList<Long> gradeIds = new ArrayList<Long>();
                gradeIds.add(grade_id);
                List studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), null, null, null, gradeIds, null, null, null, false);
                LinkedHashMap gradeList = this.restComponent.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate(studentIds2, request.getFromDate(), request.getToDate(), language);
                gradeMap.put(gradeView.getGrade_name(), gradeList);
            }
            responseMap.put("Grade", gradeMap);
        }
        if (!responseMap.isEmpty()) {
            return responseMap;
        }
        List studentIds3 = this.studentCriteriaRepository.getActiveStudentIdsByClass(request.getClass_id(), null, null, null, null, null, null, null, false);
        return this.restComponent.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate(studentIds3, request.getFromDate(), request.getToDate(), language);
    }

    public Object getMoodInsightsPostBySchool(DataApiRequest request, String language) {
        LinkedHashMap gradeList;
        List studentIds;
        List studentIds2;
        LinkedHashMap responseMap = new LinkedHashMap();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedHashMap> genderMap = new LinkedHashMap<String, LinkedHashMap>();
            for (String gender : request.getGenders()) {
                ArrayList<String> genders = new ArrayList<String>();
                genders.add(gender);
                studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), genders, null, null, null, null, null, null, false);
                LinkedHashMap genderList = this.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate2(studentIds2, request.getFromDate(), request.getToDate(), language);
                genderMap.put(gender, genderList);
            }
            responseMap.put("Gender", genderMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedHashMap> ageMap = new LinkedHashMap<String, LinkedHashMap>();
            for (Integer age : request.getAges()) {
                ArrayList<Integer> ages = new ArrayList<Integer>();
                ages.add(age);
                studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, ages, null, null, null, null, null, false);
                LinkedHashMap ageList = this.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate2(studentIds2, request.getFromDate(), request.getToDate(), language);
                ageMap.put(String.valueOf(age), ageList);
            }
            responseMap.put("Age", ageMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedHashMap> ethnicityMap = new LinkedHashMap<String, LinkedHashMap>();
            for (String ethnicity : request.getEthnicity()) {
                ArrayList<String> ethnicityItemList = new ArrayList<String>();
                ethnicityItemList.add(ethnicity);
                studentIds2 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, ethnicityItemList, null, null, null, null, false);
                LinkedHashMap ethnicityList = this.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate2(studentIds2, request.getFromDate(), request.getToDate(), language);
                ethnicityMap.put(ethnicity, ethnicityList);
            }
            responseMap.put("Ethnicity", ethnicityMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedHashMap> gradeMap = new LinkedHashMap<String, LinkedHashMap>();
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                ArrayList<Long> gradeIds = new ArrayList<Long>();
                gradeIds.add(grade_id);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, null, gradeIds, null, null, null, false);
                gradeList = this.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate2(studentIds, request.getFromDate(), request.getToDate(), language);
                gradeMap.put(gradeView.getGrade_name(), gradeList);
            }
            responseMap.put("Grade", gradeMap);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            LinkedHashMap<String, LinkedHashMap> classMap = new LinkedHashMap<String, LinkedHashMap>();
            for (Long class_id : request.getClassIds()) {
                ClassView classView = this.classService.findByClassId(class_id.longValue());
                ArrayList<Long> classIds = new ArrayList<Long>();
                classIds.add(class_id);
                studentIds = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, null, null, classIds, null, null, false);
                gradeList = this.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate2(studentIds, request.getFromDate(), request.getToDate(), language);
                classMap.put(classView.getClass_name(), gradeList);
            }
            responseMap.put("Classroom", classMap);
        }
        if (!responseMap.isEmpty()) {
            return responseMap;
        }
        List studentIds3 = this.studentCriteriaRepository.getActiveStudentIdsBySchool(request.getSchool_id(), null, null, null, null, null, null, null, false);
        return this.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate2(studentIds3, request.getFromDate(), request.getToDate(), language);
    }

    private LinkedHashMap<String, SubMoodByStandardOccurrence> getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate2(List<Long> studentIds, Date fromDate, Date toDate, String language) {
        LinkedHashMap<String, SubMoodByStandardOccurrence> response = new LinkedHashMap<String, SubMoodByStandardOccurrence>();
        LinkedHashMap emotionCountAndAveragesList = this.restComponent.getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate2(studentIds, fromDate, toDate, language);
        for (Map.Entry entry : emotionCountAndAveragesList.entrySet()) {
            SubMoodByStandardOccurrence subMoodByStandardOccurrence = new SubMoodByStandardOccurrence();
            subMoodByStandardOccurrence.set_k_2(DataServiceImpl.setSubMoodOccurrence((long)studentIds.size(), (List)((EmotionsByStandards)entry.getValue()).get_k_2()));
            subMoodByStandardOccurrence.set_3_5(DataServiceImpl.setSubMoodOccurrence((long)studentIds.size(), (List)((EmotionsByStandards)entry.getValue()).get_3_5()));
            subMoodByStandardOccurrence.set_6_12(DataServiceImpl.setSubMoodOccurrence((long)studentIds.size(), (List)((EmotionsByStandards)entry.getValue()).get_6_12()));
            response.put((String)entry.getKey(), subMoodByStandardOccurrence);
        }
        return response;
    }

    public Object getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateNew(boolean isFromMobile, List<Long> studentIds, Date fromDate, Date toDate, DataGraphType dataGraphType, AssessmentChildCategory assessmentChildCategory) {
        if (isFromMobile) {
            return this.getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateMobile(studentIds, fromDate, toDate, dataGraphType, assessmentChildCategory);
        }
        switch (1.$SwitchMap$com$infinite$focus$server$data$model$DataGraphType[dataGraphType.ordinal()]) {
            case 1: {
                SubMoodByStandardOccurrence subMoodByStandardOccurrence = new SubMoodByStandardOccurrence();
                EmotionsByStandards emotionCountAndAverages = this.restComponent.getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate2(studentIds, fromDate, toDate);
                subMoodByStandardOccurrence.set_k_2(DataServiceImpl.setSubMoodOccurrence((long)studentIds.size(), (List)emotionCountAndAverages.get_k_2()));
                subMoodByStandardOccurrence.set_3_5(DataServiceImpl.setSubMoodOccurrence((long)studentIds.size(), (List)emotionCountAndAverages.get_3_5()));
                subMoodByStandardOccurrence.set_6_12(DataServiceImpl.setSubMoodOccurrence((long)studentIds.size(), (List)emotionCountAndAverages.get_6_12()));
                return subMoodByStandardOccurrence;
            }
            case 2: {
                return this.restComponent.getChoicesAnalysisOccurrenceAndOccurrenceAverageByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
            }
            case 3: {
                return this.restComponent.getMotivationAnalysisOccurrenceAndOccurrenceAverageByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
            }
            case 4: {
                return this.restComponent.getFriendshipAnalysisOccurrenceAndOccurrenceAverageByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
            }
            case 5: {
                return this.restComponent.getFriendshipAnalysisOccurrenceAndOccurrenceAverageByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate, assessmentChildCategory);
            }
        }
        throw new IllegalArgumentException(this.messageService.getMessage("unknown.data.graph.type") + " " + dataGraphType);
    }

    public List<AssessmentOccurrence> getSELAnalyticsByStudentIdsAndBetweenFromDateAndToDateMobile(List<Long> studentIds, Date fromDate, Date toDate, DataGraphType dataGraphType, AssessmentChildCategory assessmentChildCategory) {
        switch (1.$SwitchMap$com$infinite$focus$server$data$model$DataGraphType[dataGraphType.ordinal()]) {
            case 1: {
                return this.moodUpdateRepository.getSELAnalyticsByStudentIdsForSelfAwareness(studentIds, fromDate, toDate);
            }
            case 2: {
                return this.responsibleDecisionMakingUpdateCriteriaRepository.getChoicesAnalysisByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
            }
            case 3: {
                return this.selfManagementUpdateCriteriaRepository.getMotivationAnalysisByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
            }
            case 4: {
                return this.socialAwarenessUpdateCriteriaRepository.getFriendshipAnalysisByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate);
            }
            case 5: {
                return this.relationshipSkillsUpdateCriteriaRepository.getFriendshipAnalysisByStudentIdsAndBetweenFromDateAndToDate(studentIds, fromDate, toDate, assessmentChildCategory);
            }
        }
        throw new IllegalArgumentException(this.messageService.getMessage("unknown.data.graph.type") + " " + dataGraphType);
    }
}

