/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.accesscode.repository;

import com.infinite.focus.server.accesscode.dto.AccessCodeDTO;
import com.infinite.focus.server.accesscode.repository.AccessCodeCoreRepository;
import com.infinite.focus.server.auth.model.Status;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class AccessCodeCoreRepositoryImpl
implements AccessCodeCoreRepository {
    private final JdbcTemplate jdbcTemplate;

    public AccessCodeCoreRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static AccessCodeDTO mapRow(ResultSet rs, int i) throws SQLException {
        return AccessCodeDTO.builder().access_code_id(rs.getLong("access_code_id")).accessCode(rs.getString("access_code")).createdDate((Date)rs.getTimestamp("created_date")).status(Status.valueOf((String)rs.getString("status"))).instructor_id(rs.getLong("instructor_id")).student_id(rs.getLong("student_id")).parent_id(rs.getLong("parent_id")).build();
    }

    public AccessCodeDTO findById(long access_code_id) {
        String SQL = "SELECT * FROM access_code a WHERE a.access_code_id = ? ";
        try {
            return (AccessCodeDTO)this.jdbcTemplate.queryForObject(SQL, AccessCodeCoreRepositoryImpl::mapRow, new Object[]{access_code_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AccessCodeDTO findByStudentId(long student_id) {
        String SQL = "SELECT * FROM access_code a WHERE a.student_id = ? ";
        try {
            return (AccessCodeDTO)this.jdbcTemplate.queryForObject(SQL, AccessCodeCoreRepositoryImpl::mapRow, new Object[]{student_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<AccessCodeDTO> findAll() {
        String SQL = "SELECT * FROM access_code a ORDER BY a.access_code_id ASC ";
        try {
            return this.jdbcTemplate.query(SQL, AccessCodeCoreRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<AccessCodeDTO>();
        }
    }

    public void updateInstructorIdAndParentIdByStudentId(long instructor_id, long parent_id, long student_id) {
        String SQL = "UPDATE access_code SET instructor_id = ?, parent_id = ? WHERE student_id = ? ";
        this.jdbcTemplate.update("UPDATE access_code SET instructor_id = ?, parent_id = ? WHERE student_id = ? ", new Object[]{instructor_id, parent_id, student_id});
    }
}

