/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.badge.controller;

import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.badge.entity.Badge;
import com.infinite.focus.server.badge.service.BadgeService;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/badge"})
public class BadgeController {
    @Autowired
    AuthService authService;
    @Autowired
    BadgeService badgeService;
    @Autowired
    ConfigurationService configurationService;

    @GetMapping(value={"/get/badges"})
    public ResponseEntity<List<Badge>> getBadges(@RequestHeader(value="Authorization") String token) {
        this.authService.isAuthenticated(token);
        List badges = this.badgeService.getBadgesOrderByBadgeIdAsc();
        for (Badge badge : badges) {
            badge.setImage(this.configurationService.getConfiguration().getBadge_images_path() + badge.getImage());
        }
        return new ResponseEntity((Object)badges, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @GetMapping(value={"/get/badges/by/page"})
    public ResponseEntity<Page<Badge>> getBadgesByPage(@RequestHeader(value="Authorization") String token, @RequestParam(value="title", defaultValue="") String title, @RequestParam(value="pageNo", defaultValue="0") Integer pageNo, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="sortBy", defaultValue="badge_id") String sortBy, @RequestParam(value="orderBy", defaultValue="asc") String orderBy) {
        this.authService.isAuthenticated(token);
        Page badges = this.badgeService.getBadges(title, pageNo, pageSize, sortBy, orderBy);
        for (Badge badge : badges) {
            badge.setImage(this.configurationService.getConfiguration().getBadge_images_path() + badge.getImage());
        }
        return new ResponseEntity((Object)badges, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/create/badge"})
    @ResponseBody
    public ResponseEntity<Badge> createBadge(@RequestHeader(value="Authorization") String token, @RequestBody Badge request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.badgeService.createBadge(request.getImage(), request.getTitle(), request.getTitle_es(), request.getDescription(), request.getDescription_es(), request.isShould_show_on_front()), HttpStatus.OK);
    }
}

