/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.moodupdate.repository;

import com.infinite.focus.server.assessment.model.AssessmentOccurrence;
import com.infinite.focus.server.moodupdate.dto.MoodUpdateDTO;
import com.infinite.focus.server.moodupdate.entity.MoodUpdate;
import com.infinite.focus.server.moodupdate.repository.MoodUpdateRepository;
import com.infinite.focus.server.pvstate.model.PVState;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class MoodUpdateRepositoryImpl
implements MoodUpdateRepository {
    private final EntityManager entityManager;
    private final JdbcTemplate jdbcTemplate;

    public MoodUpdateRepositoryImpl(EntityManager entityManager, JdbcTemplate jdbcTemplate) {
        this.entityManager = entityManager;
        this.jdbcTemplate = jdbcTemplate;
    }

    public static MoodUpdateDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
        return MoodUpdateDTO.builder().mood_update_id(rs.getLong("mood_update_id")).student_id(rs.getLong("student_id")).standard_id(rs.getLong("standard_id")).mood_id(rs.getLong("mood_id")).text(rs.getString("text")).text_es(rs.getString("text_es")).sub_mood_id(rs.getLong("sub_mood_id")).sub_mood_text(rs.getString("sub_mood_text")).sub_mood_text_es(rs.getString("sub_mood_text_es")).level_of_focus(rs.getFloat("level_of_focus")).pv_state(PVState.valueOfOrDefault((String)rs.getString("pv_state"))).score(rs.getDouble("score")).createdAt((Date)rs.getTimestamp("created_at")).build();
    }

    public MoodUpdateDTO create(long student_id, long standard_id, long mood_id, String text, String text_es, double score, float level_of_focus, long sub_mood_id, String sub_mood_text, String sub_mood_text_es, String pv_state) {
        String INSERT_SQL = "INSERT INTO mood_update (student_id, standard_id, mood_id, text, text_es, score, level_of_focus, sub_mood_id, sub_mood_text, sub_mood_text_es, pv_state, created_at) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO mood_update (student_id, standard_id, mood_id, text, text_es, score, level_of_focus, sub_mood_id, sub_mood_text, sub_mood_text_es, pv_state, created_at) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)", 1);
            ps.setLong(1, student_id);
            ps.setLong(2, standard_id);
            ps.setLong(3, mood_id);
            ps.setString(4, text);
            ps.setString(5, text_es);
            ps.setDouble(6, score);
            ps.setFloat(7, level_of_focus);
            ps.setLong(8, sub_mood_id);
            ps.setString(9, sub_mood_text);
            ps.setString(10, sub_mood_text_es);
            ps.setString(11, pv_state);
            ps.setTimestamp(12, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int mood_update_id = Objects.requireNonNull(holder.getKey()).intValue();
        return this.findById((long)mood_update_id);
    }

    public MoodUpdateDTO findById(long id) {
        String SQL = "SELECT * FROM mood_update WHERE mood_update_id = ? ";
        try {
            return (MoodUpdateDTO)this.jdbcTemplate.queryForObject(SQL, MoodUpdateRepositoryImpl::mapRow, new Object[]{id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<MoodUpdateDTO> getLastThreeMoodsByStudentId(long student_id) {
        String SQL = "SELECT * FROM mood_update WHERE student_id = ? ORDER BY mood_update_id DESC LIMIT 3";
        List moodUpdateDTOS = this.jdbcTemplate.query(SQL, new Object[]{student_id}, MoodUpdateRepositoryImpl::mapRow);
        return moodUpdateDTOS;
    }

    public List<MoodUpdateDTO> findAll() {
        String SQL = "SELECT * FROM mood_update ORDER BY mood_update_id ASC ";
        List moodUpdateDTOS = this.jdbcTemplate.query(SQL, MoodUpdateRepositoryImpl::mapRow);
        return moodUpdateDTOS;
    }

    public void updateAll(List<MoodUpdateDTO> moodUpdateDTOS) {
        String UPDATE_SQL = "UPDATE mood_update SET mood_id = ?, text = ?, text_es = ?, score = ?, sub_mood_id = ?, sub_mood_text = ?, sub_mood_text_es = ?, standard_id = ? WHERE mood_update_id = ? ";
        Integer updatedCount = (Integer)this.jdbcTemplate.execute(connection -> connection.prepareStatement("UPDATE mood_update SET mood_id = ?, text = ?, text_es = ?, score = ?, sub_mood_id = ?, sub_mood_text = ?, sub_mood_text_es = ?, standard_id = ? WHERE mood_update_id = ? "), ps -> {
            for (MoodUpdateDTO moodUpdateDTO : moodUpdateDTOS) {
                ps.setLong(1, moodUpdateDTO.getMood_id());
                ps.setString(2, moodUpdateDTO.getText());
                ps.setString(3, moodUpdateDTO.getText_es());
                ps.setDouble(4, moodUpdateDTO.getScore());
                ps.setLong(5, moodUpdateDTO.getSub_mood_id());
                ps.setString(6, moodUpdateDTO.getSub_mood_text());
                ps.setString(7, moodUpdateDTO.getSub_mood_text_es());
                ps.setLong(8, moodUpdateDTO.getStandard_id());
                ps.setLong(9, moodUpdateDTO.getMood_update_id());
                ps.addBatch();
            }
            ps.executeBatch();
            return ps.getUpdateCount();
        });
        System.out.println("updatedCount: " + updatedCount);
        if (updatedCount == null || updatedCount <= 0) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Not updated!!!");
        }
    }

    public Page<MoodUpdateDTO> findPageByStudentId(long student_id, Pageable pageable) {
        String rowCountSql = "SELECT count(1) AS row_count FROM mood_update mu LEFT JOIN mood m ON mu.mood_id = m.mood_id WHERE mu.student_id = ? ";
        Integer total = (Integer)this.jdbcTemplate.queryForObject(rowCountSql, (rs, rowNum) -> rs.getInt(1), new Object[]{student_id});
        StringBuilder querySql = new StringBuilder("SELECT mu.*, m.images_elementary, m.images_others, m.animated_image FROM mood_update mu LEFT JOIN mood m ON mu.mood_id = m.mood_id WHERE mu.student_id = ? ");
        for (Sort.Order order : pageable.getSort()) {
            System.out.println("Property: " + order.getProperty());
            System.out.println("Direction: " + order.getDirection());
            querySql.append("ORDER BY ").append(order.getProperty()).append(" ").append(order.getDirection()).append(" ");
        }
        querySql.append("LIMIT ").append(pageable.getPageSize()).append(" ").append("OFFSET ").append(pageable.getOffset());
        List demos = this.jdbcTemplate.query(querySql.toString(), (rs, i) -> {
            MoodUpdateDTO moodUpdateDTO = MoodUpdateRepositoryImpl.mapRow((ResultSet)rs, (int)i);
            moodUpdateDTO.setImage_elementary("/images/images_elementary/" + rs.getString("images_elementary"));
            moodUpdateDTO.setImage_others("/images/images_others/" + rs.getString("images_others"));
            moodUpdateDTO.setAnimated_image("/images/mood_gifs/" + rs.getString("animated_image"));
            return moodUpdateDTO;
        }, new Object[]{student_id});
        return new PageImpl(demos, pageable, total == null ? 0L : (long)total.intValue());
    }

    public List<MoodUpdateDTO> findByStudentId(Long student_id) {
        String SQL = "SELECT * FROM mood_update WHERE student_id = ? ORDER BY created_at DESC ";
        List moodUpdateDTOS = this.jdbcTemplate.query(SQL, MoodUpdateRepositoryImpl::mapRow, new Object[]{student_id});
        return moodUpdateDTOS;
    }

    public List<MoodUpdateDTO> findByStudentIdInLast3Days(long student_id) {
        String SQL = "SELECT * FROM mood_update WHERE student_id = ? AND created_at >= DATE_SUB(Now(),INTERVAL 3 DAY) ORDER BY created_at DESC ";
        List moodUpdateDTOS = this.jdbcTemplate.query(SQL, MoodUpdateRepositoryImpl::mapRow, new Object[]{student_id});
        return moodUpdateDTOS;
    }

    public void deleteByStudentIds(Set<Long> student_ids) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return;
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        String SQL = "DELETE FROM mood_update WHERE student_id IN(%S)";
        try {
            this.jdbcTemplate.update(String.format(SQL, inSql), student_ids.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<MoodUpdateDTO> findByStudentIdAndBetweenFromDateAndEndDate(long student_id, Date fromDate, Date toDate) {
        String SQL = "SELECT * FROM mood_update mo_up WHERE student_id = ? AND mo_up.created_at BETWEEN ? AND ? ORDER BY mo_up.created_at desc ";
        List moodUpdateDTOS = this.jdbcTemplate.query(SQL, MoodUpdateRepositoryImpl::mapRow, new Object[]{student_id, new Timestamp(fromDate.getTime()), new Timestamp(toDate.getTime())});
        return moodUpdateDTOS;
    }

    public List<MoodUpdateDTO> findByStudentIdsAndBetweenFromDateAndEndDate(Set<Long> student_ids, Date fromDate, Date toDate) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return new ArrayList<MoodUpdateDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        ArrayList<Long> args = new ArrayList<Long>(student_ids);
        args.add((Long)((Object)new Timestamp(fromDate.getTime())));
        args.add((Long)((Object)new Timestamp(toDate.getTime())));
        String SQL = "SELECT * FROM mood_update mo_up WHERE student_id IN(%S) AND mo_up.created_at BETWEEN ? AND ? ORDER BY mo_up.created_at desc ";
        List moodUpdateDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), args.toArray(), MoodUpdateRepositoryImpl::mapRow);
        return moodUpdateDTOS;
    }

    public List<AssessmentOccurrence> getSELAnalyticsByStudentIdsForSelfAwareness(List<Long> studentIds, Date fromDate, Date toDate) {
        if (AppUtils.isNullOrEmpty(studentIds)) {
            return this.mapToAssessmentOccurrence(new ArrayList());
        }
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Tuple.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        Root rootMoodUpdate = c.from(MoodUpdate.class);
        predicates.add(qb.in((Expression)rootMoodUpdate.get("student_id")).value(studentIds));
        predicates.add(qb.between((Expression)rootMoodUpdate.get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        Expression occurrence = qb.coalesce(qb.count((Expression)rootMoodUpdate), (Object)0);
        Expression quot = qb.coalesce(qb.quot(qb.count((Expression)rootMoodUpdate), (Number)studentIds.size()), (Object)0.0);
        Expression roundExpression = qb.function("round", Double.class, new Expression[]{quot, qb.literal((Object)2)});
        c.multiselect(new Selection[]{rootMoodUpdate.get("text").alias("text_to_display"), rootMoodUpdate.get("text_es").alias("text_to_display_es"), roundExpression.alias("count"), occurrence.alias("occurrence")}).where(predicates.toArray(new Predicate[0]));
        c.groupBy(new Expression[]{rootMoodUpdate.get("text"), rootMoodUpdate.get("text_es")});
        c.orderBy(new Order[]{qb.asc((Expression)rootMoodUpdate.get("text")), qb.asc((Expression)rootMoodUpdate.get("text_es"))});
        TypedQuery typedQuery = this.entityManager.createQuery(c);
        List list = typedQuery.getResultList().stream().map(tuple -> AssessmentOccurrence.builder().mood_id(0L).text_to_display((String)tuple.get("text_to_display")).text_to_display_es((String)tuple.get("text_to_display_es")).count(((Double)tuple.get("count")).doubleValue()).occurrence(((Long)tuple.get("occurrence")).longValue()).occurrence_average(0.0).build()).collect(Collectors.toList());
        return this.mapToAssessmentOccurrence(list);
    }

    public List<AssessmentOccurrence> getTextToDisplay() {
        String SQL = "SELECT m.mood, m.mood_es FROM mood m ORDER BY m.sort_index ASC ";
        List list = this.jdbcTemplate.query(SQL, (rs, i) -> AssessmentOccurrence.builder().mood_id(0L).text_to_display(rs.getString("mood")).text_to_display_es(rs.getString("mood_es")).count(0.0).occurrence(0L).occurrence_average(0.0).build());
        return list;
    }

    public List<AssessmentOccurrence> mapToAssessmentOccurrence(List<AssessmentOccurrence> list) {
        List textToDisplayList = this.getTextToDisplay();
        if (!AppUtils.isNullOrEmpty(list)) {
            for (AssessmentOccurrence a : textToDisplayList) {
                list.stream().filter(o -> o.getText_to_display().equals(a.getText_to_display()) && o.getText_to_display_es().equals(a.getText_to_display_es())).findFirst().ifPresent(o -> {
                    a.setCount(o.getCount());
                    a.setOccurrence(o.getOccurrence());
                });
            }
        }
        long totalOccurrence = textToDisplayList.stream().map(AssessmentOccurrence::getOccurrence).reduce(0L, Long::sum);
        return textToDisplayList.stream().peek(t -> t.setOccurrence_average(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)t.getOccurrence() / (double)totalOccurrence * 100.0)).doubleValue())).collect(Collectors.toList());
    }

    public List<MoodUpdateDTO> findByStudentIdAndCreatedAt(long student_id, Date createdAt) {
        String SQL = "SELECT * FROM mood_update WHERE student_id = ? AND created_at <= ? ORDER BY mood_update_id DESC LIMIT 2";
        try {
            return this.jdbcTemplate.query(SQL, MoodUpdateRepositoryImpl::mapRow, new Object[]{student_id, new Timestamp(createdAt.getTime())});
        }
        catch (Exception e) {
            return null;
        }
    }
}

