/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.clever.service;

import com.infinite.focus.server.clever.model.AccessToken;
import com.infinite.focus.server.clever.model.CleverStudentToken;
import com.infinite.focus.server.clever.request.CleverCodeRequest;
import com.infinite.focus.server.clever.response.GetAccessTokensResponse;
import com.infinite.focus.server.clever.service.CleverApiService;
import com.infinite.focus.server.clever.service.CleverService;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.converter.EncryptDecryptHelper;
import com.infinite.focus.server.utils.AppUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Service
public class CleverServiceImpl
implements CleverService {
    private CleverApiService service;
    @Autowired
    private ConfigurationRepository configurationRepository;

    public CleverServiceImpl() {
        OkHttpClient OClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://clever.com/").client(OClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.service = (CleverApiService)retrofit.create(CleverApiService.class);
    }

    public AccessToken getAccessTokenByDistrictCleverId(String district_clever_id) {
        try {
            Call getAccessToken = this.service.getAccessToken(this.getToken());
            Response response = getAccessToken.execute();
            if (response.isSuccessful() && response.body() != null && ((GetAccessTokensResponse)response.body()).getData() != null && !AppUtils.isNullOrEmpty((List)((GetAccessTokensResponse)response.body()).getData())) {
                return ((GetAccessTokensResponse)response.body()).getData().stream().filter(accessToken -> accessToken.getOwner() != null && accessToken.getOwner().getId().equals(district_clever_id.trim())).findFirst().orElse(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public CleverStudentToken getStudentTokenByCleverCode(CleverCodeRequest request) {
        try {
            String token = this.getToken();
            Call getAccessToken = this.service.getStudentAccessToken(token, request);
            Response response = getAccessToken.execute();
            if (response.isSuccessful() && response.body() != null && ((CleverStudentToken)response.body()).getAccess_token() != null && !AppUtils.isNullOrEmpty((String)((CleverStudentToken)response.body()).getAccess_token())) {
                return (CleverStudentToken)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getToken() {
        return "Basic " + EncryptDecryptHelper.base64Encode((String)(this.configurationRepository.getConfiguration().getClever_client_id() + ":" + this.configurationRepository.getConfiguration().getClever_client_secrete()));
    }
}

