/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.selanalytics.relationshipskills;

import com.infinite.focus.server.assessment.model.AssessmentOccuranceAndCompetencyScore;
import com.infinite.focus.server.assessment.model.AssessmentOccurrence;
import com.infinite.focus.server.dashboard.helper.LabelAndDataHelper;
import com.infinite.focus.server.dashboard.model.LabelAndValue;
import com.infinite.focus.server.dashboard.request.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.selanalytics.relationshipskills.RelationshipSkillsDataService;
import com.infinite.focus.server.dataset.model.AssessmentChildCategory;
import com.infinite.focus.server.ethnicity.entity.Ethnicity;
import com.infinite.focus.server.ethnicity.repository.EthnicityRepository;
import com.infinite.focus.server.gender.entity.Gender;
import com.infinite.focus.server.gender.repository.GenderRepository;
import com.infinite.focus.server.grade.repository.GradeRepository;
import com.infinite.focus.server.grade.view.GradeView;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.relationshipskills.dto.RelationshipSkillsUpdateDTO;
import com.infinite.focus.server.relationshipskills.service.RelationshipSkillsUpdateService;
import com.infinite.focus.server.socioemotionaltestanswer.entity.SocioEmotionalTestAnswer;
import com.infinite.focus.server.socioemotionaltestanswer.repository.SocioEmotionalTestAnswerRepository;
import com.infinite.focus.server.socioemotionaltestquestion.entity.SocioEmotionalTestQuestion;
import com.infinite.focus.server.socioemotionaltestquestion.repository.SocioEmotionalTestQuestionRepository;
import com.infinite.focus.server.socioemotionaltestquestionoption.entity.SocioEmotionalTestQuestionOption;
import com.infinite.focus.server.socioemotionaltestquestionoption.repository.SocioEmotionalTestQuestionOptionRepository;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestResultService;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.student.repository.StudentCriteriaRepository;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.test.wrapper.SocioEmotionalTestDataWrapper;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import com.infinite.focus.server.utils.TimeUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RelationshipSkillsDataServiceImpl
implements RelationshipSkillsDataService {
    @Autowired
    StudentCriteriaRepository studentCriteriaRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    ClassRepository classRepository;
    @Autowired
    ClassService classService;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    SocioEmotionalTestQuestionOptionRepository socioEmotionalTestQuestionOptionRepository;
    @Autowired
    SocioEmotionalTestQuestionRepository socioEmotionalTestQuestionRepository;
    @Autowired
    SocioEmotionalTestAnswerRepository socioEmotionalTestAnswerRepository;
    @Autowired
    RelationshipSkillsUpdateService relationshipSkillsUpdateService;
    @Autowired
    SocioEmotionalTestResultService socioEmotionalTestResultService;
    @Autowired
    GenderRepository genderRepository;
    @Autowired
    EthnicityRepository ethnicityRepository;

    public Object getSelfReportingData(GetDataDashBoardRequest request) {
        LinkedList values;
        List student_ids;
        GetDataDashBoardRequest getDataDashBoardRequest;
        Date fromDate = null;
        Date toDate = null;
        if (request.getFromDate() != null && request.getToDate() != null) {
            fromDate = request.getFromDate();
            toDate = request.getToDate();
        } else {
            Date firstStudentRegistredDate = this.studentRepository.getDateOfFirstRegistredStudent();
            System.out.println("firstStudentRegistredDate - " + firstStudentRegistredDate);
            fromDate = firstStudentRegistredDate == null ? DateUtils.setTimeToFromDate((Date)new Date()) : DateUtils.setTimeToFromDate((Date)firstStudentRegistredDate);
            toDate = DateUtils.setTimeToToDate((Date)new Date());
        }
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        System.out.println("----------------------------- Gender------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedList> genders_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> genders_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, true);
            for (String gender : request.getGenders()) {
                Gender genderItem = this.genderRepository.findByGender(gender);
                System.out.println("----------------------------- " + gender + "------------------------------");
                values = this.getSelfReporting(student_ids.stream().filter(studentDTO -> studentDTO.getGender().equalsIgnoreCase(gender)).map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate, getDataDashBoardRequest.getTimeZone());
                genders_en.put(gender, values);
                if (!Language.isSpanish()) continue;
                genders_es.put(genderItem.getGender_es(), values);
            }
            graphData_en.put("Gender", genders_en);
            if (Language.isSpanish()) {
                graphData_es.put("G\u00e9nero", genders_es);
            }
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedList> ages_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> ages_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, true);
            for (Integer age : request.getAges()) {
                System.out.println("----------------------------- " + age + "------------------------------");
                LinkedList values2 = this.getSelfReporting(student_ids.stream().filter(studentDTO -> TimeUtils.getAge((Date)studentDTO.getDate_of_birth()) == age).map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate, getDataDashBoardRequest.getTimeZone());
                ages_en.put(String.valueOf(age), values2);
                if (!Language.isSpanish()) continue;
                ages_es.put(String.valueOf(age), values2);
            }
            graphData_en.put("Age", ages_en);
            if (Language.isSpanish()) {
                graphData_es.put("Edad", ages_es);
            }
        }
        System.out.println("----------------------------- Ethnicity------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedList> ethnicityMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> ethnicityMap_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, true);
            for (String ethnicity : request.getEthnicity()) {
                Ethnicity ethnicityItem = this.ethnicityRepository.findByEthnicity(ethnicity);
                System.out.println("----------------------------- " + ethnicity + "------------------------------");
                values = this.getSelfReporting(student_ids.stream().filter(studentDTO -> studentDTO.getEthnicity().equalsIgnoreCase(ethnicityItem.getEthnicity())).map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate, getDataDashBoardRequest.getTimeZone());
                ethnicityMap_en.put(ethnicity, values);
                if (!Language.isSpanish()) continue;
                ethnicityMap_es.put(ethnicityItem.getEthnicity_es(), values);
            }
            graphData_en.put("Ethnicity", ethnicityMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("Etnia", ethnicityMap_es);
            }
        }
        System.out.println("----------------------------- Grade------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> grades_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> grades_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGradeIds().addAll(request.getGradeIds());
            student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, true);
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                System.out.println("-----------------------------" + grade_id + " -> " + gradeView.getGrade_name() + "------------------------------");
                values = this.getSelfReporting(student_ids.stream().filter(studentDTO -> Objects.equals(studentDTO.getGrade_id(), grade_id)).map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate, getDataDashBoardRequest.getTimeZone());
                grades_en.put(gradeView.getGrade_name(), values);
                if (!Language.isSpanish()) continue;
                grades_es.put(gradeView.getGrade_name_es(), values);
            }
            graphData_en.put("Grade", grades_en);
            if (Language.isSpanish()) {
                graphData_es.put("Grado", grades_es);
            }
        }
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public LinkedList<BigDecimal> getSelfReporting(List<Long> student_ids, Date fromDate, Date toDate, TimeZone timeZone) {
        List relationshipSkillsUpdateList = this.relationshipSkillsUpdateService.getRelationshipSkillsUpdateByStudentIds(student_ids, fromDate, toDate);
        LinkedList<BigDecimal> reportings = new LinkedList<BigDecimal>();
        if (AppUtils.isNotNullOrEmpty((List)relationshipSkillsUpdateList)) {
            Double size = relationshipSkillsUpdateList.size();
            System.out.println("RelationshipSkillsUpdate List Size - " + size + " FromDate - " + DateUtils.dayWitTimeFormat.format(fromDate) + " ToDate - " + DateUtils.dayWitTimeFormat.format(toDate));
            System.out.println("----------------------------Daily---------------------------------");
            Double days = DateUtils.getDayCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal dailyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)days);
            System.out.println("dailyReporting - " + dailyReporting + " = Size: " + size + " / Days: " + days);
            reportings.add(dailyReporting);
            System.out.println("----------------------------Weekly---------------------------------");
            Double weeks = DateUtils.getWeekCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal weeklyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)weeks);
            System.out.println("weeklyReporting - " + weeklyReporting + " = Size: " + size + " / Weeks: " + weeks);
            reportings.add(weeklyReporting);
            System.out.println("----------------------------Monthly---------------------------------");
            Double months = DateUtils.getMonthCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal monthlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)months);
            System.out.println("monthlyReporting - " + monthlyReporting + " = Size: " + size + " / Months: " + months);
            reportings.add(monthlyReporting);
            System.out.println("----------------------------Yearly---------------------------------");
            Double years = DateUtils.getYearCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal yearlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)years);
            System.out.println("yearlyReporting - " + yearlyReporting + " = Size: " + size + " / Years: " + years);
            reportings.add(yearlyReporting);
        } else {
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
        }
        return reportings;
    }

    public Object getRelationshipSkillsDemographicComparisonGraphData(GetDataDashBoardRequest request) {
        List student_ids = this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, true);
        List socialAwarenessUpdateList = this.relationshipSkillsUpdateService.getRelationshipSkillsUpdateByStudentIds(student_ids, request.getFromDate(), request.getToDate());
        LinkedList assessmentOccurances = this.getFriendshipAnalysis(socialAwarenessUpdateList, false, this.relationshipSkillsUpdateService.getTextList(request.getAssessmentChildCategory()), this.relationshipSkillsUpdateService.getTextList());
        LinkedList<LabelAndValue> graphData_en = new LinkedList<LabelAndValue>();
        LinkedList<LabelAndValue> graphData_es = new LinkedList<LabelAndValue>();
        for (int i = 0; i < assessmentOccurances.size(); ++i) {
            graphData_en.add(new LabelAndValue(((AssessmentOccurrence)assessmentOccurances.get(i)).getText_to_display(), ((AssessmentOccurrence)assessmentOccurances.get(i)).getCount()));
            if (!Language.isSpanish()) continue;
            graphData_es.add(new LabelAndValue(((AssessmentOccurrence)assessmentOccurances.get(i)).getText_to_display_es(), ((AssessmentOccurrence)assessmentOccurances.get(i)).getCount()));
        }
        LinkedHashMap<String, LinkedList<LabelAndValue>> graphData = new LinkedHashMap<String, LinkedList<LabelAndValue>>();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public Object getFriendshipAnalysisGraphData(GetDataDashBoardRequest request) {
        System.out.println("----------------------------FRIENDSHIP_ANALYSIS--------------------------------------");
        List student_ids = this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, true);
        List relationshipSkillsUpdateList = this.relationshipSkillsUpdateService.getRelationshipSkillsUpdateByStudentIds(student_ids, request.getFromDate(), request.getToDate());
        LinkedList assessmentOccurances = this.getFriendshipAnalysis(relationshipSkillsUpdateList, false, null, this.relationshipSkillsUpdateService.getTextList());
        Double totalCount = 0.0;
        for (int i = 0; i < assessmentOccurances.size(); ++i) {
            totalCount = totalCount + ((AssessmentOccurrence)assessmentOccurances.get(i)).getCount();
            System.out.println(((AssessmentOccurrence)assessmentOccurances.get(i)).getText_to_display() + " - " + ((AssessmentOccurrence)assessmentOccurances.get(i)).getCount());
        }
        System.out.println("-------------------------------------------------------------------");
        System.out.println("Total occournce " + totalCount);
        String forwordSlash = "/";
        System.out.println("------------------------Percentage = (Value " + forwordSlash + " Total Value) \ufffd 100-------------------------------------------");
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        double percentageTotal = 0.0;
        for (int i = 0; i < assessmentOccurances.size(); ++i) {
            LinkedList<Double> list = new LinkedList<Double>();
            String mood = ((AssessmentOccurrence)assessmentOccurances.get(i)).getText_to_display();
            Double count = ((AssessmentOccurrence)assessmentOccurances.get(i)).getCount();
            Double percentage = DigitUtils.getPercentage((Double)count, (Double)totalCount);
            percentageTotal += percentage.doubleValue();
            System.out.println(mood + "\t=\t( Value\t" + count + "\t" + forwordSlash + "\tTotal Value\t" + totalCount + " ) X 100 =\tpercentage\t" + percentage);
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)count));
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)percentage));
            graphData_en.put(((AssessmentOccurrence)assessmentOccurances.get(i)).getText_to_display(), list);
            if (!Language.isSpanish()) continue;
            graphData_es.put(((AssessmentOccurrence)assessmentOccurances.get(i)).getText_to_display_es(), list);
        }
        System.out.println("-----------------------------------------------------------------------------------------------------------------------------");
        System.out.println("\t\t( Value\t" + totalCount + "\t" + forwordSlash + "\tTotal Value\t" + totalCount + " ) X 100 =\tpercentage\t" + percentageTotal);
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public Object getMostAndLeastReportedData(GetDataDashBoardRequest request) {
        LinkedHashMap values;
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
        List student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, true);
        List texts = this.relationshipSkillsUpdateService.getTextList();
        System.out.println("----------------------------- Gender ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap genderMap_en = new LinkedHashMap();
            LinkedHashMap genderMap_es = new LinkedHashMap();
            for (String gender : request.getGenders()) {
                Gender genderItem = this.genderRepository.findByGender(gender);
                System.out.println("-----------------------------" + gender + "------------------------------");
                values = this.getMostAndLeast(student_ids.stream().filter(studentDTO -> !AppUtils.isNullOrEmpty((String)studentDTO.getGender()) && studentDTO.getGender().equals(gender)).map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate(), texts);
                genderMap_en.put(gender, values.get("en"));
                if (!Language.isSpanish()) continue;
                genderMap_es.put(genderItem.getGender_es(), values.get("es"));
            }
            graphData_en.put("Gender", genderMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("G\u00e9nero", genderMap_es);
            }
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap ageMap_en = new LinkedHashMap();
            LinkedHashMap ageMap_es = new LinkedHashMap();
            for (Integer age : request.getAges()) {
                System.out.println("-----------------------------" + age + "------------------------------");
                LinkedHashMap values2 = this.getMostAndLeast(student_ids.stream().filter(studentDTO -> TimeUtils.getAge((Date)studentDTO.getDate_of_birth()) == age).map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate(), texts);
                ageMap_en.put(String.valueOf(age), values2.get("en"));
                if (!Language.isSpanish()) continue;
                ageMap_es.put(String.valueOf(age), values2.get("es"));
            }
            graphData_en.put("Age", ageMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("Edad", ageMap_es);
            }
        }
        System.out.println("---------------------------- Ethnicity ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap ethnicityMap_en = new LinkedHashMap();
            LinkedHashMap ethnicityMap_es = new LinkedHashMap();
            for (String ethnicity : request.getEthnicity()) {
                Ethnicity ethnicityItem = this.ethnicityRepository.findByEthnicity(ethnicity);
                System.out.println("-----------------------------" + ethnicity + "------------------------------");
                values = this.getMostAndLeast(student_ids.stream().filter(studentDTO -> studentDTO.getEthnicity().equals(ethnicityItem.getEthnicity())).map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate(), texts);
                ethnicityMap_en.put(ethnicity, values.get("en"));
                if (!Language.isSpanish()) continue;
                ethnicityMap_es.put(ethnicityItem.getEthnicity_es(), values.get("es"));
            }
            graphData_en.put("Ethnicity", ethnicityMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("Etnia", ethnicityMap_es);
            }
        }
        System.out.println("----------------------------- Grade ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap gradeMap_en = new LinkedHashMap();
            LinkedHashMap gradeMap_es = new LinkedHashMap();
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                values = this.getMostAndLeast(student_ids.stream().filter(studentDTO -> Objects.equals(studentDTO.getGrade_id(), grade_id)).map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate(), texts);
                gradeMap_en.put(gradeView.getGrade_name(), values.get("en"));
                if (!Language.isSpanish()) continue;
                gradeMap_es.put(gradeView.getGrade_name_es(), values.get("es"));
            }
            graphData_en.put("Grade", gradeMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("Grado", gradeMap_es);
            }
        }
        System.out.println("----------------------------- Overall ------------------------------");
        LinkedHashMap values3 = this.getMostAndLeast(student_ids.stream().map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate(), texts);
        LinkedHashMap overall_en = new LinkedHashMap();
        overall_en.put("Overall", values3.get("en"));
        LinkedHashMap overall_es = new LinkedHashMap();
        overall_es.put("En total", values3.get("es"));
        graphData_en.put("Overall", overall_en);
        graphData_es.put("En total", overall_es);
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedList<String>> getMostAndLeast(List<Long> student_ids, Date fromDate, Date toDate, List<String[]> texts) {
        List relationshipSkillsUpdateList = this.relationshipSkillsUpdateService.getRelationshipSkillsUpdateByStudentIds(student_ids, fromDate, toDate);
        LinkedList assessmentOccurances = this.removeAssessmentOccuranceWithZeroCountFromAssessmentOccuranceList(this.getFriendshipAnalysis(relationshipSkillsUpdateList, true, null, texts));
        LinkedList<String> mostAndLeast_en = new LinkedList<String>();
        LinkedList<String> mostAndLeast_es = new LinkedList<String>();
        if (AppUtils.isNotNullOrEmpty((List)assessmentOccurances)) {
            AssessmentOccurrence most = (AssessmentOccurrence)assessmentOccurances.get(0);
            AssessmentOccurrence least = (AssessmentOccurrence)assessmentOccurances.get(assessmentOccurances.size() - 1);
            if (most.getCount() > 0.0) {
                mostAndLeast_en.add(most.getText_to_display() + " ( " + most.getCount() + " ) ");
                if (Language.isSpanish()) {
                    mostAndLeast_es.add(most.getText_to_display_es() + " ( " + most.getCount() + " ) ");
                }
            } else {
                mostAndLeast_en.add(" ( " + least.getCount() + " ) ");
                if (Language.isSpanish()) {
                    mostAndLeast_es.add(" ( " + least.getCount() + " ) ");
                }
            }
            if (least.getCount() > 0.0) {
                mostAndLeast_en.add(least.getText_to_display() + " ( " + least.getCount() + " ) ");
                if (Language.isSpanish()) {
                    mostAndLeast_es.add(least.getText_to_display_es() + " ( " + least.getCount() + " ) ");
                }
            } else {
                mostAndLeast_en.add(" ( " + least.getCount() + " ) ");
                if (Language.isSpanish()) {
                    mostAndLeast_es.add(" ( " + least.getCount() + " ) ");
                }
            }
        } else {
            mostAndLeast_en.add("");
            mostAndLeast_en.add("");
            if (Language.isSpanish()) {
                mostAndLeast_es.add("");
                mostAndLeast_es.add("");
            }
        }
        LinkedHashMap<String, LinkedList<String>> graphData = new LinkedHashMap<String, LinkedList<String>>();
        graphData.put("en", mostAndLeast_en);
        if (Language.isSpanish()) {
            graphData.put("es", mostAndLeast_es);
        }
        return graphData;
    }

    private LinkedList<AssessmentOccurrence> removeAssessmentOccuranceWithZeroCountFromAssessmentOccuranceList(LinkedList<AssessmentOccurrence> list) {
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            AssessmentOccurrence x = (AssessmentOccurrence)itr.next();
            if (x.getCount() != 0.0) continue;
            itr.remove();
        }
        return list;
    }

    public Object getFriendshipAnalysisAndCompetencyScoreGraphData(GetDataDashBoardRequest request) {
        LinkedHashMap values;
        GetDataDashBoardRequest getDataDashBoardRequest;
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            values = this.getFriendshipAnalysisAndCompetencyScore(getDataDashBoardRequest);
            graphData_en.put("Gender", values.get("en"));
            if (Language.isSpanish()) {
                graphData_es.put("G\u00e9nero", values.get("es"));
            }
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            values = this.getFriendshipAnalysisAndCompetencyScore(getDataDashBoardRequest);
            graphData_en.put("Age", values.get("en"));
            if (Language.isSpanish()) {
                graphData_es.put("Edad", values.get("es"));
            }
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            values = this.getFriendshipAnalysisAndCompetencyScore(getDataDashBoardRequest);
            graphData_en.put("Ethnicity", values.get("en"));
            if (Language.isSpanish()) {
                graphData_es.put("Etnia", values.get("es"));
            }
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getGradeIds().addAll(request.getGradeIds());
            values = this.getFriendshipAnalysisAndCompetencyScore(getSocioEmotionalDataAnalyticsRequest);
            graphData_en.put("Grade", values.get("en"));
            if (Language.isSpanish()) {
                graphData_es.put("Grado", values.get("es"));
            }
        }
        LinkedHashMap<String, Object> graphData = new LinkedHashMap<String, Object>();
        graphData.put("en", LabelAndDataHelper.getLabelsAndMultiDatasets(graphData_en));
        if (Language.isSpanish()) {
            graphData.put("es", LabelAndDataHelper.getLabelsAndMultiDatasets(graphData_es));
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> getFriendshipAnalysisAndCompetencyScore(GetDataDashBoardRequest request) {
        System.out.println("----------------------------FRIENDSHIP_ANALYSIS_AND_COMPETENCY_SCORE--------------------------------------");
        List student_ids = this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, true);
        List relationshipSkillsUpdateList = this.relationshipSkillsUpdateService.getRelationshipSkillsUpdateByStudentIds(student_ids, request.getFromDate(), request.getToDate());
        LinkedList assessmentOccuranceAndCompetencyScores = this.getFriendshipAnalysisCompetencyScore(relationshipSkillsUpdateList, false, request.getAssessmentChildCategory());
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        Long socio_emotional_test_question_type_id = request.getSocio_emotional_test_question_type_id();
        for (int i = 0; i < assessmentOccuranceAndCompetencyScores.size(); ++i) {
            if (((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getCount() > 0L && AppUtils.isNotNullOrEmpty((LinkedHashSet)((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getStudentIds())) {
                List values = this.socioEmotionalTestResultService.getSocioEmotionalTestResultByStudentIds(((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getStudentIds(), request.getFromDate(), request.getToDate());
                if (socio_emotional_test_question_type_id == null) {
                    if (!values.isEmpty()) {
                        Double score = 0.0;
                        for (SocioEmotionalTestResult test : values) {
                            score = score + (double)test.getScore();
                        }
                        ((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).setScore(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getAverage((Double)score, (Double)Double.valueOf(values.size()))));
                    }
                } else {
                    SocioEmotionalTestDataWrapper s = new SocioEmotionalTestDataWrapper();
                    s.setOptions(this.socioEmotionalTestQuestionOptionRepository.findAll());
                    s.setQuestions(this.socioEmotionalTestQuestionRepository.findBySocioEmotionalTestQuestionTypeId(socio_emotional_test_question_type_id));
                    if (!values.isEmpty()) {
                        Double score = 0.0;
                        for (SocioEmotionalTestResult test : values) {
                            Double total_score = 0.0;
                            List socioEmotionalTestAnswers = this.socioEmotionalTestAnswerRepository.findBySocioEmotionalTestResultId(Long.valueOf(test.getSocio_emotional_test_result_id()));
                            for (int q = 0; q < s.getQuestions().size(); ++q) {
                                SocioEmotionalTestQuestion socioEmotionalTestQuestion = (SocioEmotionalTestQuestion)s.getQuestions().get(q);
                                block4: for (int a = 0; a < socioEmotionalTestAnswers.size(); ++a) {
                                    if (socioEmotionalTestQuestion.getSocio_emotional_test_question_id() != ((SocioEmotionalTestAnswer)socioEmotionalTestAnswers.get(a)).getSocio_emotional_test_question_id()) continue;
                                    SocioEmotionalTestAnswer socioEmotionalTestAnswer = (SocioEmotionalTestAnswer)socioEmotionalTestAnswers.get(a);
                                    for (int o = 0; o < s.getOptions().size(); ++o) {
                                        if (socioEmotionalTestAnswer.getSocio_emotional_test_question_option_id() != ((SocioEmotionalTestQuestionOption)s.getOptions().get(o)).getSocio_emotional_test_question_option_id()) continue;
                                        SocioEmotionalTestQuestionOption socioEmotionalTestQuestionOption = (SocioEmotionalTestQuestionOption)s.getOptions().get(o);
                                        total_score = socioEmotionalTestQuestion.isReversed() ? Double.valueOf(total_score + (double)socioEmotionalTestQuestionOption.getReverse_weight()) : Double.valueOf(total_score + (double)socioEmotionalTestQuestionOption.getWeight());
                                        System.out.println("total_score = " + total_score);
                                        continue block4;
                                    }
                                }
                            }
                            score = score + total_score;
                            System.out.println("test id " + test.getSocio_emotional_test_result_id() + "  score = " + score);
                        }
                        ((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).setScore(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getAverage((Double)score, (Double)Double.valueOf(values.size()))));
                    }
                }
            }
            LinkedList<Double> list = new LinkedList<Double>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)((Object)((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getCount())));
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getScore()));
            graphData_en.put(((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getText_to_display(), list);
            if (!Language.isSpanish()) continue;
            System.out.println("text_to_display_es " + ((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getText_to_display_es());
            graphData_es.put(((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getText_to_display_es(), list);
        }
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>>();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    private GetDataDashBoardRequest getGetDataDashBoardRequestWithReqeuest(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = new GetDataDashBoardRequest();
        getDataDashBoardRequest.setTimeLine(request.getTimeLine());
        getDataDashBoardRequest.setSocio_emotional_test_question_type_id(request.getSocio_emotional_test_question_type_id());
        getDataDashBoardRequest.setGraphType(request.getGraphType());
        getDataDashBoardRequest.setAssessmentChildCategory(request.getAssessmentChildCategory());
        getDataDashBoardRequest.setFromDate(request.getFromDate());
        getDataDashBoardRequest.setToDate(request.getToDate());
        getDataDashBoardRequest.setTimeZone(request.getTimeZone());
        return getDataDashBoardRequest;
    }

    public LinkedList<AssessmentOccuranceAndCompetencyScore> getFriendshipAnalysisCompetencyScore(List<RelationshipSkillsUpdateDTO> relationshipSkillsUpdateList, boolean isSortData, AssessmentChildCategory assessmentChildCategory) {
        LinkedList<AssessmentOccuranceAndCompetencyScore> list = new LinkedList<AssessmentOccuranceAndCompetencyScore>();
        if (assessmentChildCategory == null) {
            for (String[] text : this.relationshipSkillsUpdateService.getTextList()) {
                list.add(new AssessmentOccuranceAndCompetencyScore(text[0], text[1], Long.valueOf(0L)));
            }
        } else {
            for (String[] text : this.relationshipSkillsUpdateService.getTextList(assessmentChildCategory)) {
                list.add(new AssessmentOccuranceAndCompetencyScore(text[0], text[1], Long.valueOf(0L)));
            }
        }
        for (RelationshipSkillsUpdateDTO relationshipSkillsUpdate : relationshipSkillsUpdateList) {
            for (AssessmentOccuranceAndCompetencyScore assessmentOccuranceAndCompetencyScore : list) {
                for (String text : Arrays.asList(relationshipSkillsUpdate.getText().split("\\s*,\\s*"))) {
                    if (!assessmentOccuranceAndCompetencyScore.getText_to_display().toLowerCase().trim().equalsIgnoreCase(text.toLowerCase().trim())) continue;
                    for (AssessmentOccuranceAndCompetencyScore o : list) {
                        if (!o.getText_to_display().equals(assessmentOccuranceAndCompetencyScore.getText_to_display())) continue;
                        o.setCount(Long.valueOf(o.getCount() + 1L));
                        o.getStudentIds().add(relationshipSkillsUpdate.getStudent_id());
                    }
                }
            }
        }
        if (isSortData) {
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        }
        return list;
    }

    public LinkedList<AssessmentOccurrence> getFriendshipAnalysis(List<RelationshipSkillsUpdateDTO> relationshipSkillsUpdateList, boolean isSortData, List<String[]> assessmentChildCategoryTexts, List<String[]> texts) {
        LinkedList<AssessmentOccurrence> list = new LinkedList<AssessmentOccurrence>();
        if (AppUtils.isNullOrEmpty(assessmentChildCategoryTexts)) {
            for (String[] text : texts) {
                list.add(new AssessmentOccurrence(0L, text[0], text[1], 0.0, 0L, 0.0, null));
            }
        } else {
            for (String[] text : assessmentChildCategoryTexts) {
                list.add(new AssessmentOccurrence(0L, text[0], text[1], 0.0, 0L, 0.0, null));
            }
        }
        for (RelationshipSkillsUpdateDTO relationshipSkillsUpdate : relationshipSkillsUpdateList) {
            for (AssessmentOccurrence assessmentOccurance : list) {
                for (String text : Arrays.asList(relationshipSkillsUpdate.getText().split("\\s*,\\s*"))) {
                    if (!assessmentOccurance.getText_to_display().toLowerCase().trim().equalsIgnoreCase(text.toLowerCase().trim())) continue;
                    for (AssessmentOccurrence o : list) {
                        if (!o.getText_to_display().equals(assessmentOccurance.getText_to_display())) continue;
                        o.setCount(o.getCount() + 1.0);
                    }
                }
            }
        }
        if (isSortData) {
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        }
        return list;
    }
}

