/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.pvstate.service;

import com.infinite.focus.server.pvstate.dto.PVStateDTO;
import com.infinite.focus.server.pvstate.model.PVState;
import com.infinite.focus.server.pvstate.repository.PVStateRepository;
import com.infinite.focus.server.pvstate.service.PVStateService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class PVStateServiceImpl
implements PVStateService {
    private final PVStateRepository pvStateRepository;

    public PVStateServiceImpl(PVStateRepository pvStateRepository) {
        this.pvStateRepository = pvStateRepository;
    }

    public List<PVStateDTO> getAll() {
        return this.pvStateRepository.findAllOrderByPVStateId();
    }

    public PVStateDTO getAvgPVStateByPVStates(List<PVState> pv_states) {
        List pvStateDTOS = this.pvStateRepository.findByPVStates(pv_states);
        double total_score = 0.0;
        for (PVState pvState : pv_states) {
            double score = pvStateDTOS.stream().filter(pvStateDTO -> pvStateDTO.getPv_state().equals((Object)pvState)).map(PVStateDTO::getScore).findFirst().orElse(0.0);
            total_score += score;
        }
        double avg_score = total_score / (double)pv_states.size();
        return this.pvStateRepository.findByScore(avg_score);
    }
}

