/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.mood.service;

import com.infinite.focus.server.assessment.model.CategoryAndScore;
import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.category.service.CategoryService;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.data.model.EmotionCountAndAverage;
import com.infinite.focus.server.data.model.EmotionOccurrenceAndAverage;
import com.infinite.focus.server.data.model.EmotionsByStandards;
import com.infinite.focus.server.data.model.SubEmotionByEmotionAndStandard;
import com.infinite.focus.server.data.model.SubEmotionCountAndAverage;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.repository.MoodRepository;
import com.infinite.focus.server.mood.service.MoodService;
import com.infinite.focus.server.moodupdate.dto.MoodUpdateDTO;
import com.infinite.focus.server.moodupdate.repository.MoodUpdateRepository;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.submood.dto.SubMoodDTO;
import com.infinite.focus.server.submoodandstandard.dto.SubMoodAndStandardDTO;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class MoodServiceImpl
implements MoodService {
    private final ConfigurationRepository configurationRepository;
    private final MoodRepository moodRepository;
    private final MoodUpdateRepository moodUpdateRepository;
    private final CategoryService categoryService;
    private final RestComponent restComponent;

    public MoodServiceImpl(ConfigurationRepository configurationRepository, MoodRepository moodRepository, MoodUpdateRepository moodUpdateRepository, CategoryService categoryService, RestComponent restComponent) {
        this.configurationRepository = configurationRepository;
        this.moodRepository = moodRepository;
        this.moodUpdateRepository = moodUpdateRepository;
        this.categoryService = categoryService;
        this.restComponent = restComponent;
    }

    public MoodUpdateDTO getMoodUpdateById(long mood_update_id) {
        return this.moodUpdateRepository.findById(mood_update_id);
    }

    public CategoryAndScore getCategoryAndScoreBySelfAwarenessIdAndScore(long self_awareness_id, double score) {
        CategoryAndScore categoryAndScore = new CategoryAndScore();
        long self_awareness_category_id = this.configurationRepository.getConfiguration().getSelf_awareness_category_id();
        CategoryDTO category = this.categoryService.getCategoryById(self_awareness_category_id);
        categoryAndScore.setCategory(category);
        categoryAndScore.setScore(score);
        return categoryAndScore;
    }

    public List<MoodDTO> getAllHappinessAltitudeMoodsOrderBySortIndex() {
        return this.moodRepository.getAllHappinessAltitudeMoodsOrderBySortIndex();
    }

    public List<MoodDTO> getAskForHelpMoods() {
        return this.moodRepository.getAskForHelpMoods();
    }

    public List<MoodDTO> getMoodsByIds(Set<Long> ids) {
        return this.moodRepository.findByIds(ids);
    }

    public List<MoodDTO> getAllMoods() {
        return this.moodRepository.getAllMoodsOrderBySortIndex();
    }

    public List<EmotionCountAndAverage> getAllEmotionsAndSubEmotions() {
        List<EmotionCountAndAverage> allEmotions = this.moodRepository.getAllMoodsOrderBySortIndex().stream().map(m -> EmotionCountAndAverage.builder().emotion_id(m.getMood_id()).emotion(m.getMood()).emotion_es(m.getMood_es()).count(0L).average(0.0).build()).collect(Collectors.toList());
        Set _k_2_standard_ids = this.restComponent.getK_2StandardIds();
        Set _3_5_standard_ids = this.restComponent.get3_5StandardIds();
        Set _6_12_standard_ids = this.restComponent.get6_12StandardIds();
        List subMoodAndStandardDTOS = this.restComponent.getAllSubMoodAndStandards();
        List subMoodDTOS = this.restComponent.getAllSubMoods();
        for (EmotionCountAndAverage e : allEmotions) {
            e.setSub_emotions(SubEmotionByEmotionAndStandard.builder()._k_2(this.findAllSubEmotionsByMoodIdAndStandardId(e.getEmotion_id(), subMoodAndStandardDTOS, subMoodDTOS, _k_2_standard_ids))._3_5(this.findAllSubEmotionsByMoodIdAndStandardId(e.getEmotion_id(), subMoodAndStandardDTOS, subMoodDTOS, _3_5_standard_ids))._6_12(this.findAllSubEmotionsByMoodIdAndStandardId(e.getEmotion_id(), subMoodAndStandardDTOS, subMoodDTOS, _6_12_standard_ids)).build());
        }
        return allEmotions;
    }

    public List<SubEmotionCountAndAverage> findAllSubEmotionsByMoodIdAndStandardId(long emotion_id, List<SubMoodAndStandardDTO> subMoodAndStandardDTOS, List<SubMoodDTO> subMoodDTOS, Set<Long> standard_ids) {
        List subMoodAndStandardDTOList = subMoodAndStandardDTOS.stream().filter(s -> standard_ids.contains(s.getStandard_id()) && s.getMood_id() == emotion_id).sorted(Comparator.comparingLong(SubMoodAndStandardDTO::getSort_index)).collect(Collectors.toList());
        List topSubMoods = subMoodAndStandardDTOS.stream().filter(s -> standard_ids.contains(s.getStandard_id()) && s.getMood_id() == emotion_id && s.getTop_sub_mood_id() == 0L).sorted(Comparator.comparingLong(SubMoodAndStandardDTO::getSort_index)).collect(Collectors.toList());
        List subMoodDTOList = topSubMoods.stream().map(s -> {
            SubMoodDTO subMoodDTO = subMoodDTOS.stream().filter(se -> se.getSub_mood_id() == s.getSub_mood_id()).findAny().orElse(null);
            if (subMoodDTO != null) {
                subMoodDTO.setColor(s.getColor());
            }
            return subMoodDTO;
        }).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SubEmotionCountAndAverage> subEmotionCountAndAverages = subMoodDTOList.stream().map(s -> SubEmotionCountAndAverage.builder().sub_emotion_id(s.getSub_mood_id()).standard_ids(standard_ids).sub_emotion(s.getSub_mood()).sub_emotion_es(s.getSub_mood_es()).color(s.getColor()).count(0L).average(0.0).build()).collect(Collectors.toList());
        for (SubEmotionCountAndAverage s2 : subEmotionCountAndAverages) {
            s2.setSub_emotions(this.findAllSubEmotionsByMoodIdAndStandardIdByTopMoods(s2, subMoodAndStandardDTOList, subMoodDTOS, standard_ids));
        }
        return subEmotionCountAndAverages;
    }

    private List<SubEmotionCountAndAverage> findAllSubEmotionsByMoodIdAndStandardIdByTopMoods(SubEmotionCountAndAverage subMoodWrapper, List<SubMoodAndStandardDTO> subMoodAndStandardDTOList, List<SubMoodDTO> subMoodDTOList, Set<Long> standard_ids) {
        ArrayList<SubEmotionCountAndAverage> subMoodWrappers = new ArrayList<SubEmotionCountAndAverage>();
        List topSubMoods = subMoodAndStandardDTOList.stream().filter(subMoodAndStandardDTO -> subMoodAndStandardDTO.getTop_sub_mood_id() == subMoodWrapper.getSub_emotion_id()).sorted(Comparator.comparingInt(SubMoodAndStandardDTO::getSort_index)).collect(Collectors.toList());
        for (SubMoodAndStandardDTO subMoodAndStandardDTO2 : topSubMoods) {
            Optional<SubMoodDTO> optionalSubMoodDTO = subMoodDTOList.stream().filter(item -> item.getSub_mood_id() == subMoodAndStandardDTO2.getSub_mood_id()).findAny();
            if (!optionalSubMoodDTO.isPresent()) continue;
            SubMoodDTO subMoodDTO = optionalSubMoodDTO.get();
            SubEmotionCountAndAverage wrapper = new SubEmotionCountAndAverage();
            wrapper.setSub_emotion_id(subMoodDTO.getSub_mood_id());
            wrapper.setSub_emotion(subMoodDTO.getSub_mood());
            wrapper.setSub_emotion_es(subMoodDTO.getSub_mood_es());
            wrapper.setColor(subMoodAndStandardDTO2.getColor());
            wrapper.setStandard_ids(standard_ids);
            wrapper.setSub_emotions(this.findAllSubEmotionsByMoodIdAndStandardIdByTopMoods(wrapper, subMoodAndStandardDTOList, subMoodDTOList, standard_ids));
            subMoodWrappers.add(wrapper);
        }
        return subMoodWrappers.stream().distinct().collect(Collectors.toList());
    }

    public EmotionsByStandards getAllEmotions() {
        Set _k_2_standard_ids = this.restComponent.getK_2StandardIds();
        Set _3_5_standard_ids = this.restComponent.get3_5StandardIds();
        Set _6_12_standard_ids = this.restComponent.get6_12StandardIds();
        List moodDTOS = this.moodRepository.getAllMoodsOrderBySortIndex();
        List subMoodAndStandardDTOS = this.restComponent.getAllSubMoodAndStandards();
        List subMoodDTOS = this.restComponent.getAllSubMoods();
        return EmotionsByStandards.builder()._k_2(this.findEmotionsByStandardIds(_k_2_standard_ids, moodDTOS, subMoodAndStandardDTOS, subMoodDTOS))._3_5(this.findEmotionsByStandardIds(_3_5_standard_ids, moodDTOS, subMoodAndStandardDTOS, subMoodDTOS))._6_12(this.findEmotionsByStandardIds(_6_12_standard_ids, moodDTOS, subMoodAndStandardDTOS, subMoodDTOS)).build();
    }

    private List<EmotionOccurrenceAndAverage> findEmotionsByStandardIds(Set<Long> standard_ids, List<MoodDTO> moodDTOS, List<SubMoodAndStandardDTO> subMoodAndStandardDTOS, List<SubMoodDTO> subMoodDTOS) {
        ArrayList<EmotionOccurrenceAndAverage> emotionOccurrenceAndAverages = new ArrayList<EmotionOccurrenceAndAverage>();
        if (!AppUtils.isNullOrEmpty(standard_ids)) {
            List emotions = subMoodAndStandardDTOS.stream().filter(smas -> standard_ids.contains(smas.getStandard_id())).map(SubMoodAndStandardDTO::getMood_id).distinct().map(id -> moodDTOS.stream().filter(m -> m.getMood_id() == id.longValue()).findAny().orElse(null)).filter(Objects::nonNull).sorted(Comparator.comparingInt(MoodDTO::getSort_index)).collect(Collectors.toList());
            for (MoodDTO m : emotions) {
                emotionOccurrenceAndAverages.add(EmotionOccurrenceAndAverage.builder().emotion_id(m.getMood_id()).emotion(m.getMood()).emotion_es(m.getMood_es()).color(m.getColor()).count(0L).average(0.0).standard_ids(standard_ids).sub_emotions(this.findAllSubEmotionsByMoodIdAndStandardId(m.getMood_id(), subMoodAndStandardDTOS, subMoodDTOS, standard_ids)).build());
            }
        }
        return emotionOccurrenceAndAverages;
    }

    public List<MoodDTO> getByStandardId(long standard_id) {
        List mood_ids = this.restComponent.getMoodIdsAndStandardId(standard_id);
        return this.moodRepository.findByIds(new HashSet(mood_ids));
    }
}

