/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.organization.service;

import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.account.view.AccountView;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organization.entity.Organization;
import com.infinite.focus.server.organization.model.OrganizationDetail;
import com.infinite.focus.server.organization.repository.OrganizationPagingAndSortingRepository;
import com.infinite.focus.server.organization.request.GetOrganizationsRequest;
import com.infinite.focus.server.organization.service.OrganizationService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class OrganizationServiceImpl
implements OrganizationService {
    private final EntityManager entityManager;
    private final OrganizationPagingAndSortingRepository organizationPagingAndSortingRepository;
    private final DistrictService districtService;
    private final SchoolService schoolService;
    private final InstructorService instructorService;
    private final StudentService studentService;
    private final MessageService messageService;
    private final AccountService accountService;
    private final CorporateService corporateService;

    public OrganizationServiceImpl(EntityManager entityManager, OrganizationPagingAndSortingRepository organizationPagingAndSortingRepository, DistrictService districtService, SchoolService schoolService, InstructorService instructorService, StudentService studentService, MessageService messageService, AccountService accountService, CorporateService corporateService) {
        this.entityManager = entityManager;
        this.organizationPagingAndSortingRepository = organizationPagingAndSortingRepository;
        this.districtService = districtService;
        this.schoolService = schoolService;
        this.instructorService = instructorService;
        this.studentService = studentService;
        this.messageService = messageService;
        this.accountService = accountService;
        this.corporateService = corporateService;
    }

    public Page<Organization> getActiveOrganizations(GetOrganizationsRequest request) {
        ArrayList<String> organizationTypes = new ArrayList<String>();
        for (String organization_type : Arrays.asList(request.getOrganization_types().split("\\s*,\\s*"))) {
            if (organization_type.equals(OrganizationType.LARGE_ORGANIZATION.toString())) {
                organizationTypes.add(OrganizationType.LARGE_ORGANIZATION.toString());
            }
            if (!organization_type.equals(OrganizationType.ORGANIZATION.toString())) continue;
            organizationTypes.add(OrganizationType.ORGANIZATION.toString());
        }
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Organization.class);
        Root organizationRoot = query.from(Organization.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((String)request.getName_of_organization())) {
            predicates.add(qb.like(qb.lower((Expression)organizationRoot.get("name_of_organization")), "%" + request.getName_of_organization().toLowerCase() + "%"));
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getOrganization_types())) {
            CriteriaBuilder.In organizationTypePredicate = qb.in((Expression)organizationRoot.get("organization_type")).value(organizationTypes);
            predicates.add(organizationTypePredicate);
        }
        Predicate licenceKeyNotNullPredicate = qb.isNotNull((Expression)organizationRoot.get("license_key"));
        predicates.add(licenceKeyNotNullPredicate);
        Predicate licenceKeyNotEmptyPredicate = qb.notEqual((Expression)organizationRoot.get("license_key"), (Object)"");
        predicates.add(licenceKeyNotEmptyPredicate);
        predicates.add(qb.greaterThanOrEqualTo((Expression)organizationRoot.get("licence_key_expiry_date"), (Comparable)new Date()));
        Predicate isActivePredicate = qb.equal((Expression)organizationRoot.get("active"), (Object)true);
        predicates.add(isActivePredicate);
        Predicate isDeletedPredicate = qb.equal((Expression)organizationRoot.get("deleted"), (Object)false);
        predicates.add(isDeletedPredicate);
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getActiveOrganizations FromDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getFromDate()) + " - ToDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getToDate()));
            predicates.add(qb.between((Expression)organizationRoot.get("licence_key_expiry_date"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        query.where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        PageRequest pageable = null;
        if (request.getOrderBy().equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)organizationRoot.get(request.getSortBy()))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)organizationRoot.get(request.getSortBy()))});
        }
        pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(Organization.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result, (Pageable)pageable, count.longValue());
        return pagedResult;
    }

    public Page<Organization> getInactiveOrganizations(GetOrganizationsRequest request) {
        if (request.isMoreThan30Days()) {
            request.setFromDate(DateUtils.subtractDaysInDate((Date)request.getFromDate(), (int)30));
            request.setToDate(DateUtils.subtractDaysInDate((Date)request.getToDate(), (int)30));
        }
        ArrayList<String> organizationTypes = new ArrayList<String>();
        for (String organization_type : Arrays.asList(request.getOrganization_types().split("\\s*,\\s*"))) {
            if (organization_type.equals(OrganizationType.LARGE_ORGANIZATION.toString())) {
                organizationTypes.add(OrganizationType.LARGE_ORGANIZATION.toString());
            }
            if (!organization_type.equals(OrganizationType.ORGANIZATION.toString())) continue;
            organizationTypes.add(OrganizationType.ORGANIZATION.toString());
        }
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Organization.class);
        Root organizationRoot = query.from(Organization.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((String)request.getName_of_organization())) {
            predicates.add(qb.like(qb.lower((Expression)organizationRoot.get("name_of_organization")), "%" + request.getName_of_organization().toLowerCase() + "%"));
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getOrganization_types())) {
            CriteriaBuilder.In organizationTypePredicate = qb.in((Expression)organizationRoot.get("organization_type")).value(organizationTypes);
            predicates.add(organizationTypePredicate);
        }
        Predicate licenceKeyNotNullPredicate = qb.isNotNull((Expression)organizationRoot.get("license_key"));
        predicates.add(licenceKeyNotNullPredicate);
        Predicate licenceKeyNotEmptyPredicate = qb.notEqual((Expression)organizationRoot.get("license_key"), (Object)"");
        predicates.add(licenceKeyNotEmptyPredicate);
        predicates.add(qb.lessThanOrEqualTo((Expression)organizationRoot.get("licence_key_expiry_date"), (Comparable)new Date()));
        predicates.add(qb.equal((Expression)organizationRoot.get("active"), (Object)true));
        predicates.add(qb.equal((Expression)organizationRoot.get("deleted"), (Object)false));
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getInactiveOrganizations FromDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getFromDate()) + " - ToDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getToDate()));
            predicates.add(qb.between((Expression)organizationRoot.get("licence_key_expiry_date"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        ArrayList<Object> predicates2 = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((String)request.getName_of_organization())) {
            predicates2.add(qb.like(qb.lower((Expression)organizationRoot.get("name_of_organization")), "%" + request.getName_of_organization().toLowerCase() + "%"));
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getOrganization_types())) {
            CriteriaBuilder.In organizationTypePredicate = qb.in((Expression)organizationRoot.get("organization_type")).value(organizationTypes);
            predicates2.add(organizationTypePredicate);
        }
        Predicate licenceKeyNotNullPredicate2 = qb.isNotNull((Expression)organizationRoot.get("license_key"));
        predicates2.add(licenceKeyNotNullPredicate2);
        Predicate licenceKeyNotEmptyPredicate2 = qb.notEqual((Expression)organizationRoot.get("license_key"), (Object)"");
        predicates2.add(licenceKeyNotEmptyPredicate2);
        predicates2.add(qb.lessThanOrEqualTo((Expression)organizationRoot.get("licence_key_expiry_date"), (Comparable)new Date()));
        predicates2.add(qb.equal((Expression)organizationRoot.get("active"), (Object)false));
        predicates2.add(qb.equal((Expression)organizationRoot.get("deleted"), (Object)false));
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getInactiveOrganizations FromDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getFromDate()) + " - ToDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getToDate()));
            predicates2.add(qb.between((Expression)organizationRoot.get("licence_key_expiry_date"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        ArrayList<Object> predicates3 = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((String)request.getName_of_organization())) {
            predicates3.add(qb.like(qb.lower((Expression)organizationRoot.get("name_of_organization")), "%" + request.getName_of_organization().toLowerCase() + "%"));
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getOrganization_types())) {
            CriteriaBuilder.In organizationTypePredicate = qb.in((Expression)organizationRoot.get("organization_type")).value(organizationTypes);
            predicates3.add(organizationTypePredicate);
        }
        Predicate licenceKeyNotNullPredicate3 = qb.isNotNull((Expression)organizationRoot.get("license_key"));
        predicates3.add(licenceKeyNotNullPredicate3);
        Predicate licenceKeyNotEmptyPredicate3 = qb.notEqual((Expression)organizationRoot.get("license_key"), (Object)"");
        predicates3.add(licenceKeyNotEmptyPredicate3);
        predicates3.add(qb.greaterThanOrEqualTo((Expression)organizationRoot.get("licence_key_expiry_date"), (Comparable)new Date()));
        predicates3.add(qb.equal((Expression)organizationRoot.get("active"), (Object)false));
        predicates3.add(qb.equal((Expression)organizationRoot.get("deleted"), (Object)false));
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getInactiveOrganizations FromDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getFromDate()) + " - ToDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getToDate()));
            predicates3.add(qb.between((Expression)organizationRoot.get("licence_key_expiry_date"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        query.where((Expression)qb.or(new Predicate[]{qb.and(predicates.toArray(new Predicate[predicates.size()])), qb.and(predicates2.toArray(new Predicate[predicates2.size()])), qb.and(predicates3.toArray(new Predicate[predicates3.size()]))}));
        PageRequest pageable = null;
        if (request.getOrderBy().equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)organizationRoot.get(request.getSortBy()))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)organizationRoot.get(request.getSortBy()))});
        }
        pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(Organization.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.or(new Predicate[]{qb.and(predicates.toArray(new Predicate[predicates.size()])), qb.and(predicates2.toArray(new Predicate[predicates2.size()])), qb.and(predicates3.toArray(new Predicate[predicates3.size()]))}));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result, (Pageable)pageable, count.longValue());
        return pagedResult;
    }

    public District activeDeactiveLargeOrganization(long organization_id, boolean active) {
        return this.districtService.activeDeactiveDistrict(organization_id, active);
    }

    public School activeDeactiveOrganization(long organization_id, boolean active) {
        return this.schoolService.activeDeactiveSchool(organization_id, active);
    }

    public boolean isActiveInstructor(long instructor_id) {
        Instructor instructor = this.instructorService.getInstructorById(instructor_id);
        if (instructor == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.instructor.is.not.found"));
        }
        boolean isActive = this.isActiveSchool(instructor.getSchool_id());
        if (!isActive) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deactivates());
        }
        return isActive;
    }

    public boolean isActiveSchool(long school_id) {
        School school = this.schoolService.getSchoolById(school_id);
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.school.is.not.found"));
        }
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        if (district == null) {
            if (school.getLicence_key_expiry_date() != null && DateUtils.checkDateTimeIsPassed((Date)school.getLicence_key_expiry_date())) {
                school = this.activeDeactiveOrganization(school.getSchool_id(), false);
            }
            return school.isActive();
        }
        boolean isActive = this.isActiveDistrict(district.getDistrict_id());
        if (!isActive) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deactivates());
        }
        return isActive;
    }

    public boolean isActiveDistrict(long district_id) {
        District district = this.districtService.getDistrictById(district_id);
        if (district == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.district.is.not.found"));
        }
        if (district.getLicence_key_expiry_date() != null && DateUtils.checkDateTimeIsPassed((Date)district.getLicence_key_expiry_date())) {
            district = this.activeDeactiveLargeOrganization(district.getDistrict_id(), false);
        }
        return district.isActive();
    }

    public OrganizationDetail findByOrganizationTypeAndOrganizationId(String organizationType, long organization_id) {
        OrganizationDetail detail = null;
        if (organizationType.equals(OrganizationType.LARGE_ORGANIZATION.toString())) {
            District district = this.districtService.getDistrictById(organization_id);
            if (district == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.is.not.found"));
            }
            detail = new OrganizationDetail();
            detail.setOrganization_id(district.getDistrict_id());
            detail.setName_of_organization(district.getDistrict_name());
            detail.setOrganization_type(OrganizationType.LARGE_ORGANIZATION);
            detail.setLicense_key(district.getLicense_key());
            detail.setLicence_key_added_date(district.getLicence_key_added_date());
            detail.setLicence_key_expiry_date(district.getLicence_key_expiry_date());
            detail.setActive(district.isActive());
            detail.setAddress(null);
            detail.setCity(district.getCity());
            detail.setState(district.getState());
            detail.setFocus_on(district.getFocus_on());
            detail.setNumber_of_youth(district.getNumber_of_youth());
            AccountView accountView = this.accountService.findAccountById(district.getAccount_id());
            detail.setEmail(accountView.getUsername());
            detail.setCreatedAt(district.getCreatedAt());
        } else if (organizationType.equals(OrganizationType.ORGANIZATION.toString())) {
            School school = this.schoolService.getSchoolById(organization_id);
            if (school == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
            }
            detail = new OrganizationDetail();
            detail.setOrganization_id(school.getSchool_id());
            detail.setName_of_organization(school.getSchool_name());
            detail.setOrganization_type(OrganizationType.ORGANIZATION);
            detail.setLicense_key(school.getLicense_key());
            detail.setLicence_key_added_date(school.getLicence_key_added_date());
            detail.setLicence_key_expiry_date(school.getLicence_key_expiry_date());
            detail.setActive(school.isActive());
            detail.setAddress(school.getAddress());
            detail.setCity(null);
            detail.setState(null);
            detail.setFocus_on(school.getFocus_on());
            detail.setNumber_of_youth(school.getNumber_of_youth());
            AccountView accountView = this.accountService.findAccountById(school.getAccount_id());
            detail.setEmail(accountView.getUsername());
            detail.setCreatedAt(school.getCreatedAt());
        } else if (organizationType.equals(OrganizationType.CORPORATE.toString())) {
            Corporate corporate = this.corporateService.getCorporateById(organization_id);
            if (corporate == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
            }
            detail = new OrganizationDetail();
            detail.setOrganization_id(corporate.getCorporate_id());
            detail.setName_of_organization(corporate.getCorporate_name());
            detail.setOrganization_type(OrganizationType.CORPORATE);
            detail.setLicense_key(corporate.getLicense_key());
            detail.setLicence_key_added_date(corporate.getLicence_key_added_date());
            detail.setLicence_key_expiry_date(corporate.getLicence_key_expiry_date());
            detail.setActive(corporate.isActive());
            detail.setAddress(corporate.getAddress());
            detail.setCity(null);
            detail.setState(null);
            detail.setFocus_on(corporate.getFocus_on());
            detail.setNumber_of_youth(corporate.getNumber_of_youth());
            AccountView accountView = this.accountService.findAccountById(corporate.getAccount_id());
            detail.setEmail(accountView.getUsername());
            detail.setCreatedAt(corporate.getCreatedAt());
        } else {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.type.is.not.found"));
        }
        return detail;
    }

    public District deleteLargeOrganization(long organization_id, boolean deleted) {
        return this.districtService.deleteDistrict(organization_id, deleted, false);
    }

    public School deleteOrganization(long organization_id, boolean deleted) {
        return this.schoolService.deleteSchool(organization_id, deleted, false);
    }

    public District editLargeOrganization(long organization_id, String name_of_organization, FocusOn focus_on, String email, String city, String state, long number_of_youth, Date licence_key_expiry_date) {
        return this.districtService.editDistrict(organization_id, name_of_organization, focus_on, email, city, state, number_of_youth, licence_key_expiry_date);
    }

    public School editOrganization(long organization_id, String name_of_organization, FocusOn focus_on, String email, String address, long number_of_youth, Date licence_key_expiry_date) {
        return this.schoolService.editSchool(organization_id, name_of_organization, focus_on, email, address, number_of_youth, licence_key_expiry_date);
    }

    public boolean isDeletedInstructor(long instructor_id) {
        Instructor instructor = this.instructorService.getInstructorById(instructor_id);
        if (instructor == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.instructor.is.not.found"));
        }
        boolean isDeleted = this.isDeletedSchool(instructor.getSchool_id());
        if (isDeleted) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deletes());
        }
        return false;
    }

    public boolean isDeletedSchool(long school_id) {
        School school = this.schoolService.getSchoolById(school_id);
        if (school == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.school.is.not.found"));
        }
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        if (district == null) {
            return school.isDeleted();
        }
        boolean isDeleted = this.isDeletedDistrict(district.getDistrict_id());
        if (isDeleted) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deletes());
        }
        return false;
    }

    public boolean isDeletedDistrict(long district_id) {
        District district = this.districtService.getDistrictById(district_id);
        if (district == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.district.is.not.found"));
        }
        return district.isDeleted();
    }
}

