/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.accesscode.controller;

import com.infinite.focus.server.accesscode.dto.AccessCodeDTO;
import com.infinite.focus.server.accesscode.entity.AccessCode;
import com.infinite.focus.server.accesscode.request.GetByAccessCodeIdRequest;
import com.infinite.focus.server.accesscode.request.UpdateAccessCodeByAccountIdAndStatusRequest;
import com.infinite.focus.server.accesscode.request.UpdateInstructorIdAndParentIdByStudentIdRequest;
import com.infinite.focus.server.accesscode.service.AccessCodeService;
import com.infinite.focus.server.student.request.GetByStudentIdRequest;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/access-code"})
public class AccessCodeController {
    private final AccessCodeService accessCodeService;

    public AccessCodeController(AccessCodeService accessCodeService) {
        this.accessCodeService = accessCodeService;
    }

    @PostMapping(value={"/update-access-code-by-account-id-and-status"})
    ResponseEntity<AccessCode> updateAccessCodeByAccountIdAndStatus(@RequestBody UpdateAccessCodeByAccountIdAndStatusRequest request) {
        return new ResponseEntity((Object)this.accessCodeService.updateAccessCodeByAccountIdAndStatus(request.getAccount_id(), request.getStatus()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-all"})
    ResponseEntity<List<AccessCodeDTO>> getAll() {
        return new ResponseEntity((Object)this.accessCodeService.getAll(), HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-id"})
    ResponseEntity<AccessCodeDTO> getById(@RequestBody GetByAccessCodeIdRequest request) {
        return new ResponseEntity((Object)this.accessCodeService.getById(request.getAccess_code_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-student-id"})
    ResponseEntity<AccessCodeDTO> getByStudentId(@RequestBody GetByStudentIdRequest request) {
        return new ResponseEntity((Object)this.accessCodeService.getByStudentId(request.getStudent_id()), HttpStatus.OK);
    }

    @PostMapping(value={"/update-instructor-id-and-parent-id-by-student-id"})
    ResponseEntity<Void> updateInstructorIdAndParentIdByStudentId(@RequestHeader(value="Authorization") String token, @RequestBody UpdateInstructorIdAndParentIdByStudentIdRequest request) {
        this.accessCodeService.updateInstructorIdAndParentIdByStudentId(request.getInstructor_id(), request.getParent_id(), request.getStudent_id());
        return new ResponseEntity(HttpStatus.OK);
    }
}

