/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.service;

import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.studentstreak.entity.StudentStreak;
import com.infinite.focus.server.studentstreak.repository.StudentStreakCoreRepository;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import com.infinite.focus.server.studentstreak.service.StudentStreakService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class StudentStreakServiceImpl
implements StudentStreakService {
    private final StreakRepository streakRepository;
    private final StudentStreakRepository studentStreakRepository;
    private final StudentStreakCoreRepository studentStreakCoreRepository;
    private final ConfigurationRepository configurationRepository;

    public StudentStreakServiceImpl(StreakRepository streakRepository, StudentStreakRepository studentStreakRepository, StudentStreakCoreRepository studentStreakCoreRepository, ConfigurationRepository configurationRepository) {
        this.streakRepository = streakRepository;
        this.studentStreakRepository = studentStreakRepository;
        this.studentStreakCoreRepository = studentStreakCoreRepository;
        this.configurationRepository = configurationRepository;
    }

    public List<StreakDTO> getStudentStreaksByStudentId(long student_id) {
        String image_url = this.configurationRepository.getConfiguration().getBaseUrlApi();
        List streaks = this.streakRepository.findByStreaksOrderByStreakIdASC().stream().peek(s -> {
            s.setImage(image_url + s.getImage());
            s.setImage_es(image_url + s.getImage_es());
        }).collect(Collectors.toList());
        block0: for (StudentStreak studentStreak : this.studentStreakRepository.findByStudentId(Long.valueOf(student_id))) {
            for (StreakDTO streak : streaks) {
                if (streak.getStreak_id() != studentStreak.getStreak_id()) continue;
                streak.setReceived(true);
                continue block0;
            }
        }
        return streaks.stream().sorted((c1, c2) -> Boolean.compare(c2.isReceived(), c1.isReceived())).collect(Collectors.toList());
    }

    public List<StreakDTO> getStreaksByStudentId(long student_id) {
        List streaks = this.studentStreakCoreRepository.getByStudentId(student_id);
        return streaks.stream().sorted((c1, c2) -> Boolean.compare(c2.isReceived(), c1.isReceived())).collect(Collectors.toList());
    }
}

