/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosrequest.service;

import com.infinite.focus.server.account.response.GetEmailByAccountIdResponse;
import com.infinite.focus.server.askforhelp.dto.AskForHelpDTO;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.notification.request.SOSAlertNotification;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.sosanswer.dto.SOSAnswerDTO;
import com.infinite.focus.server.sosrequest.dto.SOSRequestDTO;
import com.infinite.focus.server.sosrequest.repository.SOSRequestRepository;
import com.infinite.focus.server.sosrequest.request.SOSAnswerRequest;
import com.infinite.focus.server.sosrequest.service.SOSRequestService;
import com.infinite.focus.server.sosrequest.wrapper.SOSRequestForInstructorWrapper;
import com.infinite.focus.server.sosrequest.wrapper.SOSRequestWrapper;
import com.infinite.focus.server.standard.dto.StandardDTO;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.utils.AppUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SOSRequestServiceImpl
implements SOSRequestService {
    @Autowired
    MessageService messageService;
    @Autowired
    private SOSRequestRepository sosRequestRepository;
    @Autowired
    private RestComponent restComponent;

    public SOSRequestWrapper create(long student_id, long mood_update_id, List<SOSAnswerRequest> answers) {
        AskForHelpDTO askForHelpDTO = mood_update_id > 0L ? this.restComponent.createAskForHelpById(student_id, mood_update_id) : null;
        SOSRequestDTO sosRequestDTO = this.sosRequestRepository.create(student_id, askForHelpDTO != null ? askForHelpDTO.getAsk_for_help_id() : 0L);
        List sosAnswerDTOS = answers.stream().flatMap(sosAnswerRequest -> sosAnswerRequest.getSos_option_ids().stream().map(sos_option_id -> SOSAnswerDTO.builder().sos_answer_id(0L).sos_request_id(sosRequestDTO.getSos_request_id()).sos_question_id(sosAnswerRequest.getSos_question_id()).sos_option_id(sos_option_id.longValue()).build())).collect(Collectors.toList());
        List answerDTOS = this.restComponent.createSOSAnswers(sosAnswerDTOS);
        Optional.ofNullable(askForHelpDTO).ifPresent(dto -> this.restComponent.setSOSRequestId(dto.getAsk_for_help_id(), sosRequestDTO.getSos_request_id()));
        return SOSRequestWrapper.builder().request(sosRequestDTO).answers(answerDTOS).build();
    }

    public SOSRequestDTO getSOSRequestByAskForHelpId(long ask_for_help_id) {
        AskForHelpDTO askForHelpDTO = this.restComponent.getAskForHelpById(ask_for_help_id);
        if (askForHelpDTO != null) {
            return this.sosRequestRepository.findById(askForHelpDTO.getSos_request_id());
        }
        return null;
    }

    @Async
    public void sendSOSNotification(long student_id) {
        this.restComponent.sosAlertNotification(SOSAlertNotification.builder().student_id(student_id).build());
    }

    @Async
    public void setSOSEmailToInstructor(long account_id, String student_name, String grade, long sos_request_id, String language) {
        GetEmailByAccountIdResponse getInstructorEmailResponse = this.restComponent.getEmailByAccountId(account_id);
        this.restComponent.sendSOSEmail(getInstructorEmailResponse.getEmail(), student_name, grade, sos_request_id, false, language);
    }

    @Async
    public void setSOSEmailToParent(long account_id, String email, String student_name, String standard_name, long sos_request_id, String language) {
        if (account_id > 0L) {
            GetEmailByAccountIdResponse getEmailByAccountIdResponse = this.restComponent.getEmailByAccountId(account_id);
            email = getEmailByAccountIdResponse.getEmail();
        }
        this.restComponent.sendSOSEmail(email, student_name, standard_name, sos_request_id, true, language);
    }

    @Async
    public void setSOSEmailToOrganization(long account_id, String student_name, String grade, long sos_request_id, String language) {
        GetEmailByAccountIdResponse getSchoolEmailResponse = this.restComponent.getEmailByAccountId(account_id);
        this.restComponent.sendSOSEmailToOrganization(getSchoolEmailResponse.getEmail(), student_name, grade, sos_request_id, language);
    }

    public int getSOSRequestNotViewedCountByInstructorId(long instructor_id) {
        HashSet student_ids = new HashSet(this.restComponent.getStudentIdsByInstructorId(instructor_id));
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return 0;
        }
        return this.sosRequestRepository.findNotViewedCountByStudentIds(student_ids);
    }

    public Page<SOSRequestForInstructorWrapper> getSOSRequestByInstructorId(long instructor_id, String name, List<Long> students_ids, Integer pageNo, Integer pageSize, String orderBy, String sortBy, Date fromDate, Date toDate) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equalsIgnoreCase("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        HashSet ids = new HashSet();
        if (!AppUtils.isNullOrEmpty((String)name)) {
            ids.addAll(this.restComponent.getStudentsByInstructorIdAndStudentName(instructor_id, name).stream().map(StudentDTO::getStudent_id).collect(Collectors.toList()));
        } else {
            ids.addAll(this.restComponent.getStudentIdsByInstructorId(instructor_id));
        }
        if (!AppUtils.isNullOrEmpty(students_ids)) {
            List filtered = ids.stream().filter(students_ids::contains).collect(Collectors.toList());
            ids.clear();
            ids.addAll(filtered);
        }
        Page pagedResult = this.sosRequestRepository.findPageByStudentIds(ids, fromDate, toDate, (Pageable)paging);
        List standardDTOS = this.restComponent.getAllStandards();
        List studentDTOS = this.restComponent.getStudentsByIds(pagedResult.getContent().stream().map(SOSRequestDTO::getStudent_id).distinct().collect(Collectors.toList()));
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(r -> {
            if (!r.isViewed()) {
                this.sosRequestRepository.updateViewed(r.getSos_request_id(), true);
                r.setViewed(true);
            }
            StudentCoreDTO studentDTO = studentDTOS.stream().filter(s -> s.getStudent_id() == r.getStudent_id()).findAny().get();
            StandardDTO standardDTO = standardDTOS.stream().filter(std -> std.getStandard_id() == studentDTO.getStandard_id()).findAny().get();
            String message = studentDTO.getFirst_name() + " " + studentDTO.getLast_name() + (Language.isSpanish() ? this.messageService.getMessage().getSos_alert_message_es().replace("<grade>", standardDTO.getStandard_name()) : this.messageService.getMessage().getSos_alert_message().replace("<grade>", standardDTO.getStandard_name()));
            return SOSRequestForInstructorWrapper.builder().message(message).sos_request(r).build();
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public int getSOSRequestNotViewedCountBySchoolId(long school_id) {
        Set student_ids = this.restComponent.getStudentIdsBySchoolId(school_id);
        if (AppUtils.isNullOrEmpty((Set)student_ids)) {
            return 0;
        }
        return this.sosRequestRepository.findNotViewedCountForSchoolByStudentIds(student_ids);
    }

    public Page<SOSRequestForInstructorWrapper> getSOSRequestBySchoolIdAndStudentDemographics(long school_id, String name, List<String> genders, List<Integer> ages, List<String> ethnicity, List<Long> gradeIds, List<Long> classIds, Integer pageNo, Integer pageSize, String orderBy, String sortBy, Date fromDate, Date toDate) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equalsIgnoreCase("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Set student_ids = this.restComponent.getStudentIdsBySchoolIdAndStudentDemographics(school_id, name, ages, genders, ethnicity, gradeIds, classIds);
        Page pagedResult = this.sosRequestRepository.findPageByStudentIds(student_ids, fromDate, toDate, (Pageable)paging);
        List studentDTOS = this.restComponent.getStudentsByIds(pagedResult.getContent().stream().map(SOSRequestDTO::getStudent_id).distinct().collect(Collectors.toList()));
        List standardDTOS = this.restComponent.getAllStandards();
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(r -> {
            if (!r.isViewed_by_school()) {
                this.sosRequestRepository.updateViewedForSchool(r.getSos_request_id(), true);
                r.setViewed(true);
            }
            StudentCoreDTO studentDTO = studentDTOS.stream().filter(s -> s.getStudent_id() == r.getStudent_id()).findAny().get();
            StandardDTO standardDTO = standardDTOS.stream().filter(std -> std.getStandard_id() == studentDTO.getStandard_id()).findAny().get();
            String message = studentDTO.getFirst_name() + " " + studentDTO.getLast_name() + (Language.isSpanish() ? this.messageService.getMessage().getSos_alert_message_es().replace("<grade>", standardDTO.getStandard_name()) : this.messageService.getMessage().getSos_alert_message().replace("<grade>", standardDTO.getStandard_name()));
            return SOSRequestForInstructorWrapper.builder().message(message).sos_request(r).build();
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }
}

