/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.postcategory.repository;

import com.infinite.focus.server.postcategory.dto.PostCategoryDTO;
import com.infinite.focus.server.postcategory.repository.PostCategoryRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class PostCategoryRepositoryImpl
implements PostCategoryRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static PostCategoryDTO mapRow(ResultSet rs, int i) throws SQLException {
        return PostCategoryDTO.builder().post_category_id(rs.getLong("post_category_id")).post_id(rs.getLong("post_id")).category_id(rs.getLong("category_id")).build();
    }

    public List<PostCategoryDTO> create(long post_id, Set<Long> category_ids) {
        String INSERT_SQL = "INSERT INTO post_category (post_id, category_id, created_at, updated_at) VALUES (?,?,?,?)";
        Set insertedIds = (Set)this.jdbcTemplate.execute(connection -> connection.prepareStatement("INSERT INTO post_category (post_id, category_id, created_at, updated_at) VALUES (?,?,?,?)", 1), ps -> {
            for (Long category_id : category_ids) {
                ps.setLong(1, post_id);
                ps.setLong(2, category_id);
                ps.setTimestamp(3, Timestamp.valueOf(LocalDateTime.now()));
                ps.setTimestamp(4, Timestamp.valueOf(LocalDateTime.now()));
                ps.addBatch();
            }
            ps.executeBatch();
            ResultSet resultSet = ps.getGeneratedKeys();
            HashSet<Long> ids = new HashSet<Long>();
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            return ids;
        });
        return this.findByIds(insertedIds);
    }

    public List<PostCategoryDTO> findByIds(Set<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<PostCategoryDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM post_category WHERE post_category_id IN(%s) ORDER BY post_category_id ASC";
        List postAndCategoryDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), PostCategoryRepositoryImpl::mapRow);
        return postAndCategoryDTOS;
    }

    public void delete(long post_id) {
        String SQL = "DELETE FROM post_category WHERE post_id = ?";
        this.jdbcTemplate.update("DELETE FROM post_category WHERE post_id = ?", new Object[]{post_id});
    }

    public List<Long> findPostIdsByCategoryIds(Set<Long> category_ids) {
        if (AppUtils.isNullOrEmpty(category_ids)) {
            return new ArrayList<Long>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(category_ids.size(), "?"));
        String SQL = "SELECT DISTINCT(post_id) FROM post_category WHERE category_id IN(%s) ORDER BY post_id ASC";
        List post_ids = this.jdbcTemplate.query(String.format(SQL, inSql), category_ids.toArray(), (rs, i) -> rs.getLong(1));
        return post_ids;
    }

    public List<PostCategoryDTO> findPostCategoryListByPostIds(Set<Long> post_ids) {
        if (AppUtils.isNullOrEmpty(post_ids)) {
            return new ArrayList<PostCategoryDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(post_ids.size(), "?"));
        String SQL = "SELECT * FROM post_category WHERE post_id IN(%s) ORDER BY post_id ASC";
        List postCategoryDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), post_ids.toArray(), PostCategoryRepositoryImpl::mapRow);
        return postCategoryDTOS;
    }
}

