/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.appreciation.service;

import com.infinite.focus.server.appreciation.dto.AppreciationDTO;
import com.infinite.focus.server.appreciation.repository.AppreciationCoreRepository;
import com.infinite.focus.server.appreciation.service.AppreciationService;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class AppreciationServiceImpl
implements AppreciationService {
    private final ConfigurationRepository configurationRepository;
    private final AppreciationCoreRepository appreciationCoreRepository;

    public AppreciationServiceImpl(ConfigurationRepository configurationRepository, AppreciationCoreRepository appreciationCoreRepository) {
        this.configurationRepository = configurationRepository;
        this.appreciationCoreRepository = appreciationCoreRepository;
    }

    public LinkedHashSet<AppreciationDTO> getByGradeId(long grade_id) {
        return this.appreciationCoreRepository.findByGradeIdOrderByAppreciationIdASC(grade_id).stream().peek(appreciation -> appreciation.setImage(this.appreciationImagesPath() + appreciation.getImage())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private String appreciationImagesPath() {
        return this.configurationRepository.getConfiguration().getAppreciation_images_path();
    }
}

