/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.corporate.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.repository.CorporateRepository;
import com.infinite.focus.server.corporate.request.CorporateDataApiRequest;
import com.infinite.focus.server.corporate.request.GetCorporateRequest;
import com.infinite.focus.server.corporate.request.GetParentsRequest;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.corporate.wrapper.LeaderboardWrapper;
import com.infinite.focus.server.corporate.wrapper.ParentWrapper;
import com.infinite.focus.server.data.model.EmotionsByStandards;
import com.infinite.focus.server.data.model.SubMoodByStandardOccurrence;
import com.infinite.focus.server.data.service.DataServiceImpl;
import com.infinite.focus.server.freetrial.entity.FreeTrial;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.freetrial.service.FreeTrialService;
import com.infinite.focus.server.invoice.entity.Invoice;
import com.infinite.focus.server.invoice.model.InvoiceType;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.notification.model.AccountIdAndLanguage;
import com.infinite.focus.server.notification.request.CorporateNotification;
import com.infinite.focus.server.organizationadmin.entity.OrganizationAdmin;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.request.TheDailyClymbRequest;
import com.infinite.focus.server.parent.response.TheDailyClymbResponse;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.rest.RestComponent;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class CorporateServiceImpl
implements CorporateService {
    private final CorporateRepository corporateRepository;
    private final FreeTrialService freeTrialService;
    private final ParentService parentService;
    private final AccountService accountService;
    private final EntityManager entityManager;
    private final MessageService messageService;
    private final RestComponent restComponent;

    public CorporateServiceImpl(CorporateRepository corporateRepository, FreeTrialService freeTrialService, ParentService parentService, AccountService accountService, EntityManager entityManager, MessageService messageService, RestComponent restComponent) {
        this.corporateRepository = corporateRepository;
        this.freeTrialService = freeTrialService;
        this.parentService = parentService;
        this.accountService = accountService;
        this.entityManager = entityManager;
        this.messageService = messageService;
        this.restComponent = restComponent;
    }

    public Corporate getByRegistrationCode(String registration_code) {
        return this.corporateRepository.findByRegistrationCode(registration_code);
    }

    public Corporate save(Corporate corporate) {
        return (Corporate)this.corporateRepository.save((Object)corporate);
    }

    public Corporate findByAccountId(long account_id) {
        List organizationAdmins;
        Corporate corporate = this.corporateRepository.findByAccountId(account_id);
        if (corporate == null && !AppUtils.isNullOrEmpty((List)(organizationAdmins = this.restComponent.getByOrganizationTypeAndAccountId(OrganizationType.CORPORATE.toString(), account_id)))) {
            OrganizationAdmin organizationAdmin = (OrganizationAdmin)organizationAdmins.get(0);
            corporate = this.corporateRepository.findByCorporateId(organizationAdmin.getOrganization_id());
            corporate.setOrganizationAdmin(organizationAdmin);
        }
        return corporate;
    }

    public boolean isDeletedCorporate(long corporate_id) {
        Corporate corporate = this.getCorporateById(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        return corporate.isDeleted();
    }

    public Corporate getCorporateById(long corporate_id) {
        return this.corporateRepository.findByCorporateId(corporate_id);
    }

    public boolean isActiveCorporate(long corporate_id) {
        Corporate corporate = this.getCorporateById(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        if (corporate.getLicence_key_expiry_date() != null && DateUtils.checkDateTimeIsPassed((Date)corporate.getLicence_key_expiry_date())) {
            corporate = this.activeDeactiveCorporate(corporate.getCorporate_id(), false);
        }
        return corporate.isActive();
    }

    public Corporate activeDeactiveCorporate(long corporate_id, boolean active) {
        Corporate corporate = this.getCorporateById(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        corporate.setActive(active);
        return (Corporate)this.corporateRepository.save((Object)corporate);
    }

    public Corporate getCorporateByAccountId(long account_id) {
        return this.findByAccountId(account_id);
    }

    public Date getRenewalDate(long corporate_id) {
        Corporate corporate = this.getCorporateById(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        if (AppUtils.isNotNullOrEmpty((String)corporate.getLicense_key())) {
            return corporate.getLicence_key_expiry_date();
        }
        return this.freeTrialService.getFreeTrialByCorporateId(corporate.getCorporate_id()).getTrial_end_date();
    }

    public Corporate updateNumberOfYouthByCorporateId(long corporate_id, long number_of_youth) {
        Corporate corporate = this.corporateRepository.findByCorporateId(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        corporate.setNumber_of_youth(number_of_youth);
        return (Corporate)this.corporateRepository.save((Object)corporate);
    }

    public Corporate renewSubscriptionByCorporateId(long corporate_id) {
        Corporate corporate = this.corporateRepository.findByCorporateId(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        corporate.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
        corporate.setActive(true);
        return (Corporate)this.corporateRepository.save((Object)corporate);
    }

    public void addLicenseKey(Invoice invoice) {
        Corporate corporate = this.getCorporateById(invoice.getOrganization_id());
        corporate.setLicense_key(invoice.getLicense_key());
        corporate.setLicence_key_added_date(new Date());
        corporate.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
        corporate.setActive(true);
        if (invoice.getInvoice_type().equals((Object)InvoiceType.INCREASE_NO_OF_YOUTH)) {
            corporate.setNumber_of_youth(invoice.getNumber_of_youth());
        }
        this.corporateRepository.save((Object)corporate);
        FreeTrial freeTrial = this.freeTrialService.findByOrganizationTypeAndOrganizationId(OrganizationType.CORPORATE.toString(), corporate.getCorporate_id());
        if (freeTrial != null) {
            this.freeTrialService.deleteById(Long.valueOf(freeTrial.getFree_trial_id()));
        }
    }

    public void updateSubscription(Invoice invoice) {
        if (!AppUtils.isNullOrEmpty((String)invoice.getLicense_key())) {
            this.addLicenseKey(invoice);
        } else if (invoice.getInvoice_type().equals((Object)InvoiceType.INCREASE_NO_OF_YOUTH)) {
            this.updateNumberOfYouthByCorporateId(invoice.getOrganization_id(), invoice.getNumber_of_youth());
        } else if (invoice.getInvoice_type().equals((Object)InvoiceType.RENEW_SUBSCRIPTION)) {
            this.renewSubscriptionByCorporateId(invoice.getOrganization_id());
        }
    }

    public Object happinessAltitude(Corporate corporate, CorporateDataApiRequest request) {
        request.setStudentIds(this.getStudentIdsByCorporateId(corporate.getCorporate_id()));
        if (request.isFrom_mobile()) {
            return this.parentService.filterHappinessAltitudeMoods(this.parentService.getMoodCountAndPercentage(request.getStudentIds(), request.getFromDate(), request.getToDate(), false, false, corporate.getLanguage()), corporate.getLanguage());
        }
        SubMoodByStandardOccurrence subMoodByStandardOccurrence = new SubMoodByStandardOccurrence();
        EmotionsByStandards emotionCountAndAverages = this.restComponent.getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate2(request.getStudentIds(), request.getFromDate(), request.getToDate());
        subMoodByStandardOccurrence.set_k_2(DataServiceImpl.setSubMoodOccurrence((long)request.getStudentIds().size(), (List)emotionCountAndAverages.get_k_2()));
        subMoodByStandardOccurrence.set_3_5(DataServiceImpl.setSubMoodOccurrence((long)request.getStudentIds().size(), (List)emotionCountAndAverages.get_3_5()));
        subMoodByStandardOccurrence.set_6_12(DataServiceImpl.setSubMoodOccurrence((long)request.getStudentIds().size(), (List)emotionCountAndAverages.get_6_12()));
        return this.parentService.filterHappinessAltitudeMoods(subMoodByStandardOccurrence);
    }

    public List<Student> getStudentsByCorporateId(long corporate_id) {
        ArrayList<Student> students = new ArrayList<Student>();
        this.parentService.getParentsCorporateId(corporate_id).forEach(parent -> students.addAll(parent.getStudents()));
        return students;
    }

    public List<Long> getStudentIdsByCorporateId(long corporate_id) {
        return this.getStudentsByCorporateId(corporate_id).stream().map(Student::getStudent_id).collect(Collectors.toList());
    }

    public TheDailyClymbResponse theDailyClymb(Corporate corporate, TheDailyClymbRequest request) {
        List studentIds = this.getStudentIdsByCorporateId(corporate.getCorporate_id());
        TheDailyClymbResponse response = new TheDailyClymbResponse();
        response.setTodaysClymbers(this.parentService.todaysClymbers(studentIds, request.getToday()));
        response.setTotalClymbers((long)studentIds.size());
        response.setAverageClymbDuration(DateUtils.getMinutesAndSecondInString((long)this.parentService.averageClymbDuration(studentIds, request.getToday())));
        response.setTotalHappinessAltitude(this.parentService.totalHappinessAltitude(studentIds, request.getToday(), corporate.getLanguage()));
        response.setHalfOfTheClymbersHaveReachedHappinessAltitude(this.parentService.halfOfTheClymbersHaveReachedHappinessAltitude(studentIds, request.getToday(), corporate.getLanguage()));
        return response;
    }

    public Object comprehensiveReport(Corporate corporate, CorporateDataApiRequest request) {
        request.setStudentIds(this.getStudentIdsByCorporateId(corporate.getCorporate_id()));
        SubMoodByStandardOccurrence subMoodByStandardOccurrence = new SubMoodByStandardOccurrence();
        EmotionsByStandards emotionCountAndAverages = this.restComponent.getSelfAwarenessByStudentIdsAndCreatedBetweenFromDateAndToDate2(request.getStudentIds(), request.getFromDate(), request.getToDate());
        subMoodByStandardOccurrence.set_k_2(DataServiceImpl.setSubMoodOccurrence((long)request.getStudentIds().size(), (List)emotionCountAndAverages.get_k_2()));
        subMoodByStandardOccurrence.set_3_5(DataServiceImpl.setSubMoodOccurrence((long)request.getStudentIds().size(), (List)emotionCountAndAverages.get_3_5()));
        subMoodByStandardOccurrence.set_6_12(DataServiceImpl.setSubMoodOccurrence((long)request.getStudentIds().size(), (List)emotionCountAndAverages.get_6_12()));
        return subMoodByStandardOccurrence;
    }

    public Page<ParentWrapper> getParentsByCorporateId(long corporate_id, GetParentsRequest request) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Parent.class);
        Root root = query.from(Parent.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(qb.equal((Expression)root.get("corporate_id"), (Object)corporate_id));
        predicates.add(qb.equal((Expression)root.get("deleted"), (Object)false));
        query.where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        PageRequest pageable = null;
        if (request.getOrderBy().equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)root.get(request.getSortBy()))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)root.get(request.getSortBy()))});
        }
        pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(Parent.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        ArrayList<ParentWrapper> resultSet = new ArrayList<ParentWrapper>();
        for (Parent parent : result) {
            ParentWrapper wrapper = new ParentWrapper();
            wrapper.setParent_id(parent.getParent_id());
            wrapper.setFirst_name(parent.getFirst_name());
            wrapper.setLast_name(parent.getLast_name());
            wrapper.setNumber_of_youth((long)parent.getStudents().size());
            wrapper.setEmail(parent.getUsername());
            resultSet.add(wrapper);
        }
        PageImpl pagedResult = new PageImpl(resultSet, (Pageable)pageable, count.longValue());
        return pagedResult;
    }

    public LinkedList<LeaderboardWrapper> leaderboard(long corporate_id, Date fromDate, Date toDate) {
        LinkedList leaderboardWrappers = new LinkedList();
        this.parentService.getParentsCorporateId(corporate_id).forEach(parent -> {
            LeaderboardWrapper wrapper = new LeaderboardWrapper();
            wrapper.setParent_id(parent.getParent_id());
            wrapper.setFull_name(parent.getFirst_name() + " " + parent.getLast_name());
            List studentIds = parent.getStudents().stream().map(Student::getStudent_id).collect(Collectors.toList());
            if (!AppUtils.isNullOrEmpty(studentIds)) {
                long time = this.parentService.averageClymbDuration(studentIds, fromDate, toDate);
                wrapper.setHousehold_average_in_mins(DateUtils.getMinutesAndSecondInString((long)time));
                wrapper.setHousehold_average(time);
            } else {
                wrapper.setHousehold_average_in_mins(DateUtils.getMinutesAndSecondInString((long)0L));
                wrapper.setHousehold_average(0L);
            }
            leaderboardWrappers.add(wrapper);
        });
        return leaderboardWrappers.stream().sorted((c1, c2) -> Long.compare(c2.getHousehold_average(), c1.getHousehold_average())).limit(25L).collect(Collectors.toCollection(LinkedList::new));
    }

    public void setCorporateNewNotifications(long corporate_id, boolean new_available) {
        try {
            Corporate corporate = this.corporateRepository.findByCorporateId(corporate_id);
            corporate.setNew_notifications(new_available);
            this.corporateRepository.save((Object)corporate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Page<Corporate> getActiveCorporates(GetCorporateRequest request) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Corporate.class);
        Root corporateRoot = query.from(Corporate.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (AppUtils.isNotNullOrEmpty((String)request.getCorporate_name())) {
            predicates.add(qb.like(qb.lower((Expression)corporateRoot.get("corporate_name")), "%" + request.getCorporate_name().toLowerCase() + "%"));
        }
        Predicate licenceKeyNotNullPredicate = qb.isNotNull((Expression)corporateRoot.get("license_key"));
        predicates.add(licenceKeyNotNullPredicate);
        Predicate licenceKeyNotEmptyPredicate = qb.notEqual((Expression)corporateRoot.get("license_key"), (Object)"");
        predicates.add(licenceKeyNotEmptyPredicate);
        predicates.add(qb.greaterThanOrEqualTo((Expression)corporateRoot.get("licence_key_expiry_date"), (Comparable)new Date()));
        Predicate isActivePredicate = qb.equal((Expression)corporateRoot.get("active"), (Object)true);
        predicates.add(isActivePredicate);
        Predicate isDeletedPredicate = qb.equal((Expression)corporateRoot.get("deleted"), (Object)false);
        predicates.add(isDeletedPredicate);
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getActiveCorporates FromDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getFromDate()) + " - ToDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getToDate()));
            predicates.add(qb.between((Expression)corporateRoot.get("licence_key_added_date"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        query.where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        PageRequest pageable = null;
        if (request.getOrderBy().equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)corporateRoot.get(request.getSortBy()))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)corporateRoot.get(request.getSortBy()))});
        }
        pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(Corporate.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result, (Pageable)pageable, count.longValue());
        return pagedResult;
    }

    public Page<Corporate> getInactiveCorporates(GetCorporateRequest request) {
        if (request.isMoreThan30Days()) {
            request.setFromDate(DateUtils.subtractDaysInDate((Date)request.getFromDate(), (int)30));
            request.setToDate(DateUtils.subtractDaysInDate((Date)request.getToDate(), (int)30));
        }
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Corporate.class);
        Root corporateRoot = query.from(Corporate.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (AppUtils.isNotNullOrEmpty((String)request.getCorporate_name())) {
            predicates.add(qb.like(qb.lower((Expression)corporateRoot.get("corporate_name")), "%" + request.getCorporate_name().toLowerCase() + "%"));
        }
        Predicate licenceKeyNotNullPredicate = qb.isNotNull((Expression)corporateRoot.get("license_key"));
        predicates.add(licenceKeyNotNullPredicate);
        Predicate licenceKeyNotEmptyPredicate = qb.notEqual((Expression)corporateRoot.get("license_key"), (Object)"");
        predicates.add(licenceKeyNotEmptyPredicate);
        predicates.add(qb.lessThanOrEqualTo((Expression)corporateRoot.get("licence_key_expiry_date"), (Comparable)new Date()));
        predicates.add(qb.equal((Expression)corporateRoot.get("active"), (Object)true));
        predicates.add(qb.equal((Expression)corporateRoot.get("deleted"), (Object)false));
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getInactiveCorporates FromDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getFromDate()) + " - ToDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getToDate()));
            predicates.add(qb.between((Expression)corporateRoot.get("licence_key_expiry_date"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        ArrayList<Predicate> predicates2 = new ArrayList<Predicate>();
        if (AppUtils.isNotNullOrEmpty((String)request.getCorporate_name())) {
            predicates2.add(qb.like(qb.lower((Expression)corporateRoot.get("corporate_name")), "%" + request.getCorporate_name().toLowerCase() + "%"));
        }
        Predicate licenceKeyNotNullPredicate2 = qb.isNotNull((Expression)corporateRoot.get("license_key"));
        predicates2.add(licenceKeyNotNullPredicate2);
        Predicate licenceKeyNotEmptyPredicate2 = qb.notEqual((Expression)corporateRoot.get("license_key"), (Object)"");
        predicates2.add(licenceKeyNotEmptyPredicate2);
        predicates2.add(qb.lessThanOrEqualTo((Expression)corporateRoot.get("licence_key_expiry_date"), (Comparable)new Date()));
        predicates2.add(qb.equal((Expression)corporateRoot.get("active"), (Object)false));
        predicates2.add(qb.equal((Expression)corporateRoot.get("deleted"), (Object)false));
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getInactiveCorporates FromDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getFromDate()) + " - ToDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getToDate()));
            predicates2.add(qb.between((Expression)corporateRoot.get("licence_key_expiry_date"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        ArrayList<Predicate> predicates3 = new ArrayList<Predicate>();
        if (AppUtils.isNotNullOrEmpty((String)request.getCorporate_name())) {
            predicates3.add(qb.like(qb.lower((Expression)corporateRoot.get("corporate_name")), "%" + request.getCorporate_name().toLowerCase() + "%"));
        }
        Predicate licenceKeyNotNullPredicate3 = qb.isNotNull((Expression)corporateRoot.get("license_key"));
        predicates3.add(licenceKeyNotNullPredicate3);
        Predicate licenceKeyNotEmptyPredicate3 = qb.notEqual((Expression)corporateRoot.get("license_key"), (Object)"");
        predicates3.add(licenceKeyNotEmptyPredicate3);
        predicates3.add(qb.greaterThanOrEqualTo((Expression)corporateRoot.get("licence_key_expiry_date"), (Comparable)new Date()));
        predicates3.add(qb.equal((Expression)corporateRoot.get("active"), (Object)false));
        predicates3.add(qb.equal((Expression)corporateRoot.get("deleted"), (Object)false));
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getInactiveCorporates FromDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getFromDate()) + " - ToDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(request.getToDate()));
            predicates3.add(qb.between((Expression)corporateRoot.get("licence_key_expiry_date"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        query.where((Expression)qb.or(new Predicate[]{qb.and(predicates.toArray(new Predicate[predicates.size()])), qb.and(predicates2.toArray(new Predicate[predicates2.size()])), qb.and(predicates3.toArray(new Predicate[predicates3.size()]))}));
        PageRequest pageable = null;
        if (request.getOrderBy().equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)corporateRoot.get(request.getSortBy()))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)corporateRoot.get(request.getSortBy()))});
        }
        pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(Corporate.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.or(new Predicate[]{qb.and(predicates.toArray(new Predicate[predicates.size()])), qb.and(predicates2.toArray(new Predicate[predicates2.size()])), qb.and(predicates3.toArray(new Predicate[predicates3.size()]))}));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result, (Pageable)pageable, count.longValue());
        return pagedResult;
    }

    public List<Corporate> getCorporates() {
        return this.corporateRepository.getCorporates();
    }

    public long getStudentsCountByCorporateId(long corporate_id) {
        return this.getStudentsByCorporateId(corporate_id).size();
    }

    public Corporate deleteCorporate(long corporate_id, boolean deleted, boolean isFromFreeTrial) {
        Corporate corporate = this.corporateRepository.findByCorporateId(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        corporate.setDeleted(deleted);
        if (!isFromFreeTrial && AppUtils.isNullOrEmpty((String)corporate.getLicense_key())) {
            FreeTrial freeTrial = this.freeTrialService.deleteFreeTrial(corporate.getCorporate_id(), OrganizationType.CORPORATE, deleted);
        }
        return (Corporate)this.corporateRepository.save((Object)corporate);
    }

    public Corporate editCorporate(long corporate_id, String corporate_name, FocusOn focus_on, String email, String address, long number_of_youth, Date licence_key_expiry_date) {
        Corporate corporate = this.corporateRepository.findByCorporateId(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)corporate_name)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("corporate.name.is.null.or.empty"));
        }
        if (AppUtils.isNullOrEmpty((String)address)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, this.messageService.getMessage("address.is.null.or.empty"));
        }
        Account account = this.accountService.changeEmail(corporate.getAccount_id(), email);
        corporate.setCorporate_name(corporate_name);
        corporate.setFocus_on(focus_on);
        corporate.setAddress(address);
        corporate.setNumber_of_youth(number_of_youth);
        if (AppUtils.isNullOrEmpty((String)corporate.getLicense_key())) {
            this.freeTrialService.editFreeTrial(corporate.getCorporate_id(), OrganizationType.CORPORATE, corporate_name, focus_on, licence_key_expiry_date);
        } else {
            corporate.setLicence_key_expiry_date(licence_key_expiry_date);
        }
        return (Corporate)this.corporateRepository.save((Object)corporate);
    }

    public void sendNotificationToAllParents(long corporate_id, String text, String text_es) {
        HashMap<Long, AccountIdAndLanguage> parent_ids_and_account_ids = new HashMap<Long, AccountIdAndLanguage>();
        for (Parent parent : this.parentService.getParentsCorporateId(corporate_id)) {
            parent_ids_and_account_ids.put(parent.getParent_id(), AccountIdAndLanguage.builder().account_id(parent.getAccount_id()).language(parent.getLanguage()).demo(false).build());
        }
        CorporateNotification corporateNotification = CorporateNotification.builder().parent_ids_and_account_ids(parent_ids_and_account_ids).text(text).text_es(text_es).build();
        this.restComponent.corporateNotification(corporateNotification);
    }
}

