/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.auth.service.InstructorAuthService;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.freetrial.request.FreeTrialAccountRequest;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.standard.entity.Standard;
import com.infinite.focus.server.standard.repository.StandardJPARepository;
import com.infinite.focus.server.utils.AppUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class InstructorAuthServiceImpl
implements InstructorAuthService {
    @Autowired
    MessageService messageService;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    SchoolRepository schoolRepository;
    @Autowired
    StandardJPARepository standardRepository;

    public Instructor createInstructorTrialAccount(long school_id, FreeTrialAccountRequest request) {
        if (AppUtils.isNullOrEmpty((String)request.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)request.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account a = this.accountRepository.findByUsername(request.getEmail());
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.instructor.s.email.is.already.exist"));
        }
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.create.account.at.the.moment.please.try.after.some.time"));
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)request.getPassword()));
        account.setUsername(request.getEmail());
        account.setRole_in_organization(request.getRole_in_organization());
        a = (Account)this.accountRepository.save((Object)account);
        Instructor instructor = new Instructor();
        instructor.setAuto_approve_wall_posts(school.isAuto_approve_wall_posts());
        instructor.setFirst_name(request.getFirst_name());
        instructor.setLast_name(request.getLast_name());
        instructor.setAccount(a);
        instructor.setSchool_id(school_id);
        instructor.getStandards().add((Standard)this.standardRepository.findAll().get(0));
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = KeyGenerator.generateUniqueAuthCode();
            Instructor x = this.instructorRepository.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                instructor.setRegistration_code(possible_code);
                continue;
            }
            isUnique = false;
        }
        instructor.setLanguage(Language.getLanguage());
        Instructor i = (Instructor)this.instructorRepository.save((Object)instructor);
        return i;
    }
}

