/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.largeorganizationsurveychoice.service;

import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.repository.DistrictRepository;
import com.infinite.focus.server.largeorganizationsurveychoice.entity.LargeOrganizationSurveyChoice;
import com.infinite.focus.server.largeorganizationsurveychoice.repository.LargeOrganizationSurveyChoiceRepository;
import com.infinite.focus.server.largeorganizationsurveychoice.service.LargeOrganizationSurveyChoiceService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.survey.entity.Survey;
import com.infinite.focus.server.survey.model.LabelAndCountAndAverage;
import com.infinite.focus.server.survey.model.QuestionAndData;
import com.infinite.focus.server.survey.repository.SurveyRepository;
import com.infinite.focus.server.survey.wrapper.SurveyWrapper;
import com.infinite.focus.server.surveychoice.entity.SurveyChoice;
import com.infinite.focus.server.surveychoice.repository.SurveyChoiceRepository;
import com.infinite.focus.server.surveyquestion.entity.SurveyQuestion;
import com.infinite.focus.server.surveyquestion.model.SurveyChoiceType;
import com.infinite.focus.server.surveyquestion.model.SurveyType;
import com.infinite.focus.server.surveyquestion.repository.SurveyQuestionRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class LargeOrganizationSurveyChoiceServiceImpl
implements LargeOrganizationSurveyChoiceService {
    @Autowired
    DistrictRepository districtRepository;
    @Autowired
    SurveyRepository surveyRepository;
    @Autowired
    SurveyQuestionRepository surveyQuestionRepository;
    @Autowired
    SurveyChoiceRepository surveyChoiceRepository;
    @Autowired
    LargeOrganizationSurveyChoiceRepository largeOrganizationSurveyChoiceRepository;
    @Autowired
    MessageService messageService;

    @Async
    public void assignSurveyToLargeOrganization(Date date) {
        Survey survey = this.surveyRepository.findSurveyByDate(date);
        if (survey == null) {
            System.out.println(this.messageService.getMessage("survey.is.not.found.for.the.date"));
            return;
        }
        System.out.println("GetSurveyByDate: " + survey.getSurvey_id());
        long days = DateUtils.getDayCountByFromDateAndToDate((Date)date, (Date)survey.getEnd_time(), (TimeZone)TimeZone.getTimeZone(ZoneId.systemDefault()));
        System.out.println("countDaysBetweenFromDateAndToDate: " + days);
        Set largeOrganizationIds = this.districtRepository.getAllDistricts().stream().map(District::getDistrict_id).collect(Collectors.toSet());
        System.out.println("All Large-Organizations: " + largeOrganizationIds.size());
        Set largeOrganizationIdsFromLargeOrganizationSurveyChoice = this.getAllBySurveyId(survey.getSurvey_id()).stream().map(LargeOrganizationSurveyChoice::getLarge_organization_id).collect(Collectors.toSet());
        System.out.println("AllBySurveyId: " + largeOrganizationIdsFromLargeOrganizationSurveyChoice.size());
        largeOrganizationIds.removeAll(largeOrganizationIdsFromLargeOrganizationSurveyChoice);
        System.out.println("All Large-Organizations - AllBySurveyId = " + largeOrganizationIds.size());
        if (!largeOrganizationIds.isEmpty() && days > 0L) {
            int countToAssign = 0;
            try {
                countToAssign = (int)((long)largeOrganizationIds.size() / days);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            if (countToAssign == 0) {
                countToAssign = 1;
            }
            System.out.println("countToAssign: " + countToAssign);
            largeOrganizationIds = AppUtils.getRandomStreamSubset(largeOrganizationIds.stream(), (int)countToAssign).collect(Collectors.toSet());
            System.out.println("LargeOrganizationIds to assign: " + largeOrganizationIds.size());
            SurveyQuestion surveyQuestion = this.surveyQuestionRepository.findBySurveyQuestionIndexAndType(survey.getQuestion_index(), SurveyType.LARGE_ORGANIZATION.toString());
            List surveyChoices = this.surveyChoiceRepository.findBySurveyQuestionIdOrderBySortIndexASC(Long.valueOf(surveyQuestion.getSurvey_question_id()));
            System.out.println("SurveyChoices: " + surveyChoices.size());
            this.create(survey.getSurvey_id(), surveyQuestion.getChoice_type() == SurveyChoiceType.SINGLE ? 1L : (long)surveyChoices.size(), new ArrayList(largeOrganizationIds));
        }
    }

    @Async
    public void create(long survey_id, long surveyChoicesSize, List<Long> largeOrganizationIds) {
        if (!largeOrganizationIds.isEmpty()) {
            for (long large_organization_Id : largeOrganizationIds) {
                int i = 0;
                while ((long)i < surveyChoicesSize) {
                    LargeOrganizationSurveyChoice largeOrganizationSurveyChoice = new LargeOrganizationSurveyChoice();
                    largeOrganizationSurveyChoice.setLarge_organization_id(large_organization_Id);
                    largeOrganizationSurveyChoice.setSurvey_id(survey_id);
                    this.largeOrganizationSurveyChoiceRepository.save((Object)largeOrganizationSurveyChoice);
                    ++i;
                }
            }
        }
    }

    public List<LargeOrganizationSurveyChoice> getAllBySurveyId(long surveyId) {
        return this.largeOrganizationSurveyChoiceRepository.findBySurveyId(Long.valueOf(surveyId));
    }

    public LinkedHashSet<SurveyWrapper> getSurveyWrappersForLargeOrganization(long large_organization_id) {
        LinkedHashSet<SurveyWrapper> surveyWrappers = new LinkedHashSet<SurveyWrapper>();
        List largeOrganizationSurveyChoices = this.largeOrganizationSurveyChoiceRepository.findByLargeOrganizationId(large_organization_id);
        if (!largeOrganizationSurveyChoices.isEmpty()) {
            Map<Long, LinkedHashSet> largeOrganizationSurveyChoiceBySurveyId = largeOrganizationSurveyChoices.stream().collect(Collectors.groupingBy(LargeOrganizationSurveyChoice::getSurvey_id, Collectors.toCollection(LinkedHashSet::new)));
            Set<Long> surveyIds = largeOrganizationSurveyChoiceBySurveyId.keySet();
            for (long surveyId : surveyIds) {
                LinkedHashSet largeOrganizationSurveyChoicesFilled = largeOrganizationSurveyChoiceBySurveyId.get(surveyId).stream().filter(largeOrganizationSurveyChoice -> largeOrganizationSurveyChoice.getSurvey_choice_id() > 0L).collect(Collectors.toCollection(LinkedHashSet::new));
                if (!largeOrganizationSurveyChoicesFilled.isEmpty()) continue;
                Survey survey = this.surveyRepository.findBySurveyId(Long.valueOf(surveyId));
                SurveyQuestion surveyQuestion = this.surveyQuestionRepository.findBySurveyQuestionIndexAndType(survey.getQuestion_index(), SurveyType.LARGE_ORGANIZATION.toString());
                surveyWrappers.add(new SurveyWrapper(surveyQuestion, new LinkedHashSet(this.surveyChoiceRepository.findBySurveyQuestionIdOrderBySortIndexASC(Long.valueOf(surveyQuestion.getSurvey_question_id())))));
            }
        }
        return surveyWrappers;
    }

    public void updateLargeOrganizationSurveyChoice(long large_organization_id, long survey_id, Set<Long> survey_choices) {
        List largeOrganizationSurveyChoices = this.largeOrganizationSurveyChoiceRepository.findBySurveyIdAndLargeOrganizationIdOrderByLargeOrganizationSurveyChoiceASC(survey_id, large_organization_id);
        ArrayList<Long> surveyChoices = new ArrayList<Long>(survey_choices);
        if (!AppUtils.isNullOrEmpty(survey_choices)) {
            for (int i = 0; i < surveyChoices.size(); ++i) {
                LargeOrganizationSurveyChoice largeOrganizationSurveyChoice = (LargeOrganizationSurveyChoice)largeOrganizationSurveyChoices.get(i);
                largeOrganizationSurveyChoice.setSurvey_choice_id(((Long)surveyChoices.get(i)).longValue());
                this.largeOrganizationSurveyChoiceRepository.save((Object)largeOrganizationSurveyChoice);
            }
        }
    }

    public QuestionAndData getDataAnalytics(String fromDate, String toDate, String fromTimeZone, String toTimeZone) {
        Survey survey = this.surveyRepository.findSurveyByDate(fromDate, fromTimeZone, toTimeZone);
        if (survey == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("survey.is.not.found.for.the.date"));
        }
        SurveyQuestion surveyQuestion = this.surveyQuestionRepository.findBySurveyQuestionIndexAndType(survey.getQuestion_index(), SurveyType.LARGE_ORGANIZATION.toString());
        List surveyChoices = this.surveyChoiceRepository.findBySurveyQuestionIdOrderBySortIndexASC(Long.valueOf(surveyQuestion.getSurvey_question_id()));
        LinkedHashSet<LabelAndCountAndAverage> labelAndCountAndAverages = new LinkedHashSet<LabelAndCountAndAverage>();
        for (SurveyChoice surveyChoice : surveyChoices) {
            LabelAndCountAndAverage labelAndValueAndAverage = new LabelAndCountAndAverage(surveyChoice.getChoice(), surveyChoice.getChoice_es(), 0L);
            labelAndCountAndAverages.add(labelAndValueAndAverage);
        }
        List largeOrganizationSurveyChoices = this.largeOrganizationSurveyChoiceRepository.findByCreatedAtBetweenFromDateAndEndDateOrderByDESC(fromDate, toDate);
        Map<Long, LinkedHashSet> largeOrganizationSurveyChoiceBySurveyChoiceId = largeOrganizationSurveyChoices.stream().filter(largeOrganizationSurveyChoice -> largeOrganizationSurveyChoice.getSurvey_choice_id() > 0L).collect(Collectors.groupingBy(LargeOrganizationSurveyChoice::getSurvey_choice_id, Collectors.toCollection(LinkedHashSet::new)));
        Set<Long> surveyChoiceIds = largeOrganizationSurveyChoiceBySurveyChoiceId.keySet();
        long totalCount = 0L;
        for (long survey_choice_id : surveyChoiceIds) {
            SurveyChoice surveyChoice = this.surveyChoiceRepository.findSurveyChoiceById(survey_choice_id);
            LinkedHashSet largeOrganizationSurveyChoiceList = largeOrganizationSurveyChoiceBySurveyChoiceId.get(survey_choice_id);
            totalCount += (long)largeOrganizationSurveyChoiceList.size();
            for (LabelAndCountAndAverage labelAndValueAndAverage : labelAndCountAndAverages) {
                if (!labelAndValueAndAverage.getLabel().equals(surveyChoice.getChoice())) continue;
                labelAndValueAndAverage.setCount((long)largeOrganizationSurveyChoiceList.size());
            }
        }
        for (LabelAndCountAndAverage labelAndCountAndAverage : labelAndCountAndAverages) {
            labelAndCountAndAverage.setAverage(DigitUtils.getPercentageInTwoDigit((Long)labelAndCountAndAverage.getCount(), (Long)totalCount).doubleValue());
        }
        QuestionAndData questionAndData = new QuestionAndData();
        questionAndData.setSurveyQuestion(surveyQuestion);
        questionAndData.setLabelAndCountAndAverages(labelAndCountAndAverages);
        questionAndData.setTotal_survey_sent(this.largeOrganizationSurveyChoiceRepository.countByCreatedAtBetweenFromDateAndEndDate(fromDate, toDate));
        questionAndData.setActive_users_who_received_survey((Object)"N/A");
        questionAndData.setFilled_survey(this.largeOrganizationSurveyChoiceRepository.countFilledByCreatedAtBetweenFromDateAndEndDate(fromDate, toDate));
        return questionAndData;
    }

    public void syncLargeOrganizationSurvey() {
        List largeOrganizationSurveyChoices = this.largeOrganizationSurveyChoiceRepository.findAll();
        for (LargeOrganizationSurveyChoice largeOrganizationSurveyChoice : largeOrganizationSurveyChoices) {
            List items = this.largeOrganizationSurveyChoiceRepository.findBySurveyIdAndLargeOrganizationIdOrderByLargeOrganizationSurveyChoiceASC(largeOrganizationSurveyChoice.getSurvey_id(), largeOrganizationSurveyChoice.getLarge_organization_id());
            if (!AppUtils.isNullOrEmpty((List)items)) {
                LargeOrganizationSurveyChoice firstItem = (LargeOrganizationSurveyChoice)items.get(0);
                for (LargeOrganizationSurveyChoice item : items) {
                    item.setCreatedAt(firstItem.getCreatedAt());
                }
            }
            this.largeOrganizationSurveyChoiceRepository.saveAll((Iterable)items);
        }
    }
}

