/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.auth.service.DistrictAuthService;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.repository.DistrictRepository;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.freetrial.request.FreeTrialAccountRequest;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.utils.AppUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class DistrictAuthServiceImpl
implements DistrictAuthService {
    @Autowired
    MessageService messageService;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    DistrictRepository districtRepository;
    @Autowired
    ConfigurationService configurationService;

    public District createDistrictTrialAccount(FreeTrialAccountRequest large_organization, FocusOn focus_on) {
        if (AppUtils.isNullOrEmpty((String)large_organization.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)large_organization.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account a = this.accountRepository.findByUsername(large_organization.getEmail());
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.district.s.email.is.already.exist"));
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)large_organization.getPassword()));
        account.setUsername(large_organization.getEmail());
        account.setRole_in_organization(large_organization.getRole_in_organization());
        a = (Account)this.accountRepository.save((Object)account);
        District d = new District();
        d.setDistrict_name(large_organization.getName());
        d.setCity(large_organization.getCity());
        d.setState(large_organization.getState());
        d.setAccount_id(a.getAccount_id());
        d.setNumber_of_youth((long)this.configurationService.getConfiguration().getFree_trial_number_of_youth());
        d.setActive(true);
        d.setFocus_on(focus_on);
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = KeyGenerator.generateUniqueAuthCode();
            District x = this.districtRepository.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                d.setRegistration_code(possible_code);
                continue;
            }
            isUnique = false;
        }
        d.setLanguage(Language.getLanguage());
        this.districtRepository.save((Object)d);
        return d;
    }
}

