/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.client;

import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.request.GetByStudentIdRequest;
import com.infinite.focus.server.student.request.GetStudentByInstructorIdAndStudentNameRequest;
import com.infinite.focus.server.student.request.GetStudentByInstructorRequest;
import com.infinite.focus.server.student.request.GetStudentIdsByDemographicsRequest;
import com.infinite.focus.server.student.request.GetStudentRequest;
import com.infinite.focus.server.student.request.GetStudentsByIdsRequest;
import com.infinite.focus.server.student.request.GetStudentsBySchoolIdRequest;
import com.infinite.focus.server.student.request.SetNewNotificationsRequest;
import com.infinite.focus.server.student.request.SetShouldForceSocioEmotionalAssessmentRequest;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

@FeignClient(name="student-service", url="${base.url}", path="/api/student")
public interface StudentClient {
    @PostMapping(value={"/get-student-by-id"})
    public Student getStudentById(@RequestBody GetStudentRequest var1);

    @PostMapping(value={"/set-new-notifications"})
    public void setNewNotifications(@RequestBody SetNewNotificationsRequest var1);

    @PostMapping(value={"/set-new-notifications"})
    public void setNewNotifications(@RequestHeader(value="Authorization") String var1, @RequestBody SetNewNotificationsRequest var2);

    @PostMapping(value={"/set-should-force-socio-emotional-assessment"})
    public void setShouldForceSocioEmotionalAssessment(@RequestBody SetShouldForceSocioEmotionalAssessmentRequest var1);

    @PostMapping(value={"/get-student-ids-by-instructor-id"})
    public List<Long> getStudentIdsByInstructorId(@RequestBody GetStudentByInstructorRequest var1);

    @PostMapping(value={"/get-student-ids-by-school-id"})
    public List<Long> getStudentIdsBySchoolId(@RequestBody GetStudentsBySchoolIdRequest var1);

    @PostMapping(value={"/get-student-ids-by-student-demographics"})
    public List<Long> getStudentIdsByDemographics(@RequestBody GetStudentIdsByDemographicsRequest var1);

    @PostMapping(value={"/get-students-by-ids"})
    public List<StudentCoreDTO> getStudentsByIds(@RequestBody GetStudentsByIdsRequest var1);

    @PostMapping(value={"/get-students-by-instructor-id-and-student-name"})
    public List<StudentDTO> getStudentByInstructorIdAndStudentName(@RequestBody GetStudentByInstructorIdAndStudentNameRequest var1);

    @PostMapping(value={"/get-by-student-id"})
    public StudentCoreDTO getByStudentId(@RequestBody GetByStudentIdRequest var1);
}

