/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.fcm.service;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class FCMInitializer {
    @Value(value="${app.firebase-configuration-file}")
    private String firebaseConfigPath;
    Logger logger = LoggerFactory.getLogger(FCMInitializer.class);

    @PostConstruct
    public void initialize() {
        try {
            GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)new ClassPathResource(this.firebaseConfigPath).getInputStream());
            FirebaseOptions options = FirebaseOptions.builder().setCredentials(googleCredentials).setConnectTimeout(2000).setReadTimeout(3000).build();
            if (FirebaseApp.getApps().isEmpty()) {
                FirebaseApp.initializeApp((FirebaseOptions)options);
                this.logger.info("Firebase application has been initialized {}", (Object)this.firebaseConfigPath);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
    }
}

