/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.controller;

import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.request.GetByStudentIdRequest;
import com.infinite.focus.server.studentstreak.service.StudentStreakService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/student-streak"})
public class StudentStreakController {
    private final AuthService authService;
    private final StudentStreakService studentStreakService;

    public StudentStreakController(AuthService authService, StudentStreakService studentStreakService) {
        this.authService = authService;
        this.studentStreakService = studentStreakService;
    }

    @GetMapping(value={"/get/streaks/for/student"})
    public ResponseEntity<List<StreakDTO>> getBadgesForStudent(@RequestHeader(value="Authorization") String token) {
        Student student = this.authService.isStudent(token);
        return new ResponseEntity((Object)this.studentStreakService.getStudentStreaksByStudentId(student.getStudent_id()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-student-id"})
    public ResponseEntity<List<StreakDTO>> getStreaksByStudentId(@RequestHeader(value="Authorization") String token, @RequestBody GetByStudentIdRequest request) {
        return new ResponseEntity((Object)this.studentStreakService.getStreaksByStudentId(request.getStudent_id()), (HttpStatusCode)HttpStatus.OK);
    }
}

