/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.fcm.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.client.StudentClient;
import com.infinite.focus.server.fcm.dto.PushNotificationDTO;
import com.infinite.focus.server.fcm.request.SendFirebasePushNotificationRequest;
import com.infinite.focus.server.fcm.request.SendPushNotificationRequest;
import com.infinite.focus.server.fcm.service.PushNotificationService;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.notification.model.NotificationType;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestService;
import com.infinite.focus.server.standard.entity.Standard;
import com.infinite.focus.server.standard.repository.StandardJPARepository;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.request.SetNewNotificationsRequest;
import com.infinite.focus.server.student.request.SetShouldForceSocioEmotionalAssessmentRequest;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.studentpushnotification.entity.StudentPushNotification;
import com.infinite.focus.server.studentpushnotification.repository.StudentPushNotificationRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/fcm"})
public class PushNotificationController {
    @Value(value="${app.firebase.topic}")
    private String appFirebaseTopic;
    private final PushNotificationService pushNotificationService;
    private final StudentPushNotificationRepository studentPushNotificationRepository;
    private final RealTimeMessageService realTimeMessageService;
    private final StudentRepository studentRepository;
    private final SocioEmotionalTestService socioEmotionalTestService;
    private final ClassService classService;
    private final MessageService messageService;
    private final StandardJPARepository standardRepository;
    private final AuthService authService;
    private final StudentClient studentClient;

    public PushNotificationController(PushNotificationService pushNotificationService, StudentPushNotificationRepository studentPushNotificationRepository, RealTimeMessageService realTimeMessageService, StudentRepository studentRepository, SocioEmotionalTestService socioEmotionalTestService, ClassService classService, MessageService messageService, StandardJPARepository standardRepository, AuthService authService, StudentClient studentClient) {
        this.pushNotificationService = pushNotificationService;
        this.studentPushNotificationRepository = studentPushNotificationRepository;
        this.realTimeMessageService = realTimeMessageService;
        this.studentRepository = studentRepository;
        this.socioEmotionalTestService = socioEmotionalTestService;
        this.classService = classService;
        this.messageService = messageService;
        this.standardRepository = standardRepository;
        this.authService = authService;
        this.studentClient = studentClient;
    }

    @PostMapping(value={"/send/firebase/notification"})
    public ResponseEntity<Message> sendFirebasePushNotification(@RequestHeader(value="Authorization") String token, @RequestBody SendFirebasePushNotificationRequest request) {
        if (AppUtils.isNullOrEmpty((List)request.getPush_notifications())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Push Notification List Not Found!");
        }
        for (PushNotificationDTO pushNotification : request.getPush_notifications()) {
            String topic = "CLYMB_" + pushNotification.getAccount_id() + "_NOTIFICATION" + this.appFirebaseTopic;
            pushNotification.setTopic(topic);
        }
        this.pushNotificationService.sendPushNotifications(request.getPush_notifications());
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/student/send/notification"})
    public ResponseEntity<Message> sendDataNotification(@RequestHeader(value="Authorization") String token, @RequestBody SendPushNotificationRequest request) {
        this.authService.isAuthenticated(token);
        List studentViews = request.getClass_id() != null ? this.classService.findStudentsByClassId(request.getClass_id().longValue()) : (request.getInstructor_id() != null ? this.studentRepository.findByInstructorId(request.getInstructor_id()) : (request.getIds() == null || request.getIds().isEmpty() ? this.studentRepository.findAllOrderById() : this.studentRepository.findByStudentIds(request.getIds())));
        if (AppUtils.isNullOrEmpty((List)studentViews)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("students.are.not.found"));
        }
        if (request.getPush_notification() != null && request.getPush_notification().getScreen_type() != null && request.getPush_notification().getScreen_type().equals((Object)NotificationType.SOCIO_EMOTIONAL_TEST)) {
            if ((studentViews = studentViews.stream().filter(studentView -> {
                Standard standard = this.standardRepository.findByStandardId(studentView.getStandard_id());
                return standard != null && studentView.getStandard_id() > 0L && !this.socioEmotionalTestService.getStandardNamesWhichNotNeedSocioEmotionalTest().contains(standard.getStandard_name());
            }).collect(Collectors.toList())).isEmpty()) {
                Message message = new Message();
                message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
            }
            this.studentClient.setShouldForceSocioEmotionalAssessment(SetShouldForceSocioEmotionalAssessmentRequest.builder().student_ids(studentViews.stream().map(StudentView::getStudent_id).collect(Collectors.toList())).should_force_socio_emotional_assessment(true).build());
        }
        ArrayList<PushNotificationDTO> pushNotificationDTOS = new ArrayList<PushNotificationDTO>();
        if (request.isSaveToDB()) {
            if (AppUtils.isNullOrEmpty((List)request.getIds()) && request.getInstructor_id() == null && request.getPush_notification() != null && request.getPush_notification().getScreen_type() != null && !request.getPush_notification().getScreen_type().equals((Object)NotificationType.SOCIO_EMOTIONAL_TEST)) {
                StudentPushNotification studentPushNotification = PushNotificationController.getStudentPushNotification((long)0L, (SendPushNotificationRequest)request);
                this.studentPushNotificationRepository.save((Object)studentPushNotification);
                List studentViewList = this.studentRepository.findAllOrderById();
                this.sendRealTimeNotificationToAllStudents(studentViewList, studentPushNotification.getTitle(), studentPushNotification.getMessage());
                Set account_ids = studentViewList.stream().map(StudentView::getAccount_id).collect(Collectors.toSet());
                for (StudentView studentView2 : studentViewList) {
                    PushNotificationDTO push_notification = PushNotificationDTO.builder().push_notification_id(0L).account_id(studentView2.getAccount_id().longValue()).notification_id(studentPushNotification.getStudent_push_notification_id()).topic("CLYMB_" + studentView2.getAccount_id() + "_NOTIFICATION" + this.appFirebaseTopic).title(studentPushNotification.getTitle()).message(studentPushNotification.getMessage()).title_es(studentPushNotification.getTitle_es()).message_es(studentPushNotification.getMessage_es()).screen_type(studentPushNotification.getNotification_type()).language(studentView2.getLanguage()).createdAt(studentPushNotification.getCreatedAt()).build();
                    pushNotificationDTOS.add(push_notification);
                }
            } else {
                for (StudentView studentView3 : studentViews) {
                    StudentPushNotification studentPushNotification = PushNotificationController.getStudentPushNotification((long)studentView3.getStudent_id(), (SendPushNotificationRequest)request);
                    this.studentPushNotificationRepository.save((Object)studentPushNotification);
                    PushNotificationDTO push_notification = PushNotificationDTO.builder().push_notification_id(0L).account_id(studentView3.getAccount_id().longValue()).notification_id(studentPushNotification.getStudent_push_notification_id()).topic("CLYMB_" + studentView3.getAccount_id() + "_NOTIFICATION" + this.appFirebaseTopic).title(studentPushNotification.getTitle()).message(studentPushNotification.getMessage()).title_es(studentPushNotification.getTitle_es()).message_es(studentPushNotification.getMessage_es()).screen_type(studentPushNotification.getNotification_type()).language(studentView3.getLanguage()).createdAt(studentPushNotification.getCreatedAt()).build();
                    pushNotificationDTOS.add(push_notification);
                }
                this.sendRealTimeNotificationToAllStudents(studentViews, request.getPush_notification().getTitle(), request.getPush_notification().getMessage());
            }
            this.studentClient.setNewNotifications(SetNewNotificationsRequest.builder().student_ids(studentViews.stream().map(StudentView::getStudent_id).collect(Collectors.toList())).new_notifications(true).build());
        } else {
            for (StudentView studentView4 : studentViews) {
                PushNotificationDTO push_notification = PushNotificationDTO.builder().push_notification_id(0L).account_id(studentView4.getAccount_id().longValue()).notification_id(0L).topic("CLYMB_" + studentView4.getAccount_id() + "_NOTIFICATION" + this.appFirebaseTopic).title(request.getPush_notification().getTitle()).message(request.getPush_notification().getMessage()).title_es(request.getPush_notification().getTitle_es()).message_es(request.getPush_notification().getMessage_es()).screen_type(request.getPush_notification().getScreen_type()).language(studentView4.getLanguage()).createdAt(request.getPush_notification().getCreatedAt()).build();
                pushNotificationDTOS.add(push_notification);
            }
        }
        try {
            this.pushNotificationService.sendPushNotifications(pushNotificationDTOS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("notification.has.been.sent"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    private static StudentPushNotification getStudentPushNotification(long student_id, SendPushNotificationRequest request) {
        StudentPushNotification studentNotificationTemplate = new StudentPushNotification();
        studentNotificationTemplate.setStudent_id(student_id);
        studentNotificationTemplate.setNotification_type(request.getPush_notification().getScreen_type());
        studentNotificationTemplate.setTitle(request.getPush_notification().getTitle());
        studentNotificationTemplate.setMessage(request.getPush_notification().getMessage());
        studentNotificationTemplate.setMessage(request.getPush_notification().getMessage());
        studentNotificationTemplate.setMessage_es(request.getPush_notification().getMessage_es());
        return studentNotificationTemplate;
    }

    private void sendRealTimeNotificationToAllStudents(List<StudentView> studentViews, String title, String message) {
        try {
            for (StudentView studentView : studentViews) {
                this.realTimeMessageService.sendTitleAndMessage(studentView.getStudent_id().longValue(), title, message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

