/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.account.repository;

import com.infinite.focus.server.account.dto.AccountDTO;
import com.infinite.focus.server.account.repository.AccountCoreRepository;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class AccountCoreRepositoryImpl
implements AccountCoreRepository {
    private final JdbcTemplate jdbcTemplate;

    public AccountCoreRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static AccountDTO mapRow(ResultSet rs, int i) throws SQLException {
        return AccountDTO.builder().account_id(rs.getLong("account_id")).username(rs.getString("username")).username2(rs.getString("username2")).role_in_organization(rs.getString("role_in_organization")).createdAt((Date)rs.getTimestamp("created_at")).build();
    }

    public AccountDTO findByAccountId(long account_id) {
        String SQL = "SELECT * FROM account a WHERE account_id = ? ";
        try {
            AccountDTO accountDTO = (AccountDTO)this.jdbcTemplate.queryForObject(SQL, AccountCoreRepositoryImpl::mapRow, new Object[]{account_id});
            return accountDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AccountDTO findByUsernameOrUsername2(String user) {
        String SQL = "SELECT * FROM account a WHERE a.username = ? OR a.username2 = ? ";
        try {
            AccountDTO accountDTO = (AccountDTO)this.jdbcTemplate.queryForObject(SQL, AccountCoreRepositoryImpl::mapRow, new Object[]{user, user});
            return accountDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

