/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.toppicks.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.toppicks.dto.TopPicksDTO;
import com.infinite.focus.server.toppicks.request.DeleteByIdRequest;
import com.infinite.focus.server.toppicks.request.GetByIdRequest;
import com.infinite.focus.server.toppicks.service.TopPicksService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/top-picks"})
public class TopPicksController {
    @Autowired
    private AuthService authService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopPicksService topPicksService;

    @PostMapping(value={"/create"})
    @ResponseBody
    public ResponseEntity<TopPicksDTO> create(@RequestHeader(value="Authorization") String token, @RequestBody TopPicksDTO request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.topPicksService.create(request.getQuote(), request.getQuote_es()), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public ResponseEntity<TopPicksDTO> update(@RequestHeader(value="Authorization") String token, @RequestBody TopPicksDTO request) {
        this.authService.isAuthenticated(token);
        TopPicksDTO topPicksDTO = this.topPicksService.getById(request.getTop_picks_id());
        if (topPicksDTO == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.top.picks.not.found"));
        }
        return new ResponseEntity((Object)this.topPicksService.update(request.getTop_picks_id(), request.getQuote(), request.getQuote_es()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-top-picks-by-id"})
    public ResponseEntity<TopPicksDTO> getTopPicksById(@RequestHeader(value="Authorization") String token, @RequestBody GetByIdRequest request) {
        this.authService.isAuthenticated(token);
        TopPicksDTO topPicksDTO = this.topPicksService.getById(request.getId());
        if (topPicksDTO == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.top.picks.not.found"));
        }
        return new ResponseEntity((Object)topPicksDTO, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get-all-top-picks"})
    public ResponseEntity<List<TopPicksDTO>> getAllTopPicks(@RequestHeader(value="Authorization") String token) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.topPicksService.getAll(), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/make-daily-top-picks"})
    @ResponseBody
    public ResponseEntity<TopPicksDTO> makeDailyTopPicks() {
        this.topPicksService.updateAllIsDailyTopPicksToFalse();
        TopPicksDTO topPicksDTO = this.topPicksService.getRandomTopPicks();
        topPicksDTO.setIsDailyTopPicks(Boolean.valueOf(true));
        return new ResponseEntity((Object)this.topPicksService.updateIsDailyTopPicks(topPicksDTO.getTop_picks_id(), topPicksDTO.getIsDailyTopPicks()), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get-daily-top-picks"})
    public ResponseEntity<TopPicksDTO> getDailyTopPicks(@RequestHeader(value="Authorization") String token) {
        this.authService.isAuthenticated(token);
        TopPicksDTO topPicksDTO = this.topPicksService.getDailyTopPicks();
        if (topPicksDTO == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.daily.top.picks.not.found"));
        }
        return new ResponseEntity((Object)topPicksDTO, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/delete-top-picks-by-id"})
    public ResponseEntity<Message> deleteTopPicksById(@RequestHeader(value="Authorization") String token, @RequestBody DeleteByIdRequest request) {
        this.authService.isAuthenticated(token);
        TopPicksDTO topPicksDTO = this.topPicksService.getById(request.getId());
        if (topPicksDTO == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.top.picks.not.found"));
        }
        if (topPicksDTO.getIsDailyTopPicks().booleanValue()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.top.picks.is.a.daily.toppicks.the.daily.toppicks.can.not.be.deleted"));
        }
        this.topPicksService.deleteById(request.getId());
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("the.top.picks.is.deleted.successfully"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }
}

