/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.school.controller;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.request.SchoolSignUpRequest;
import com.infinite.focus.server.auth.request.SearchSchoolRequest;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.clever.model.AccessToken;
import com.infinite.focus.server.clever.model.CleverSchool;
import com.infinite.focus.server.clever.service.CleverService;
import com.infinite.focus.server.clever.service.data.CleverDataService;
import com.infinite.focus.server.clever.service.school.CleverSchoolService;
import com.infinite.focus.server.clever.service.school.CleverSchoolSyncService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.request.AutoApproveWallPostsRequest;
import com.infinite.focus.server.school.request.EnableJournalRequest;
import com.infinite.focus.server.school.request.EnableWallPostsRequest;
import com.infinite.focus.server.school.request.GetSchoolByIdRequest;
import com.infinite.focus.server.school.request.GetSchoolByStudentIdRequest;
import com.infinite.focus.server.school.request.GetSchoolEmailRequest;
import com.infinite.focus.server.school.response.GetSchoolEmailResponse;
import com.infinite.focus.server.school.service.GetStudentsBySchoolRequest;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.school.wrapper.SchoolSettingsWrapper;
import com.infinite.focus.server.security.helper.JwtHelper;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.wallpost.component.WallPostBadWordFilterComponent;
import com.infinite.focus.server.wallpost.entity.WallPost;
import com.infinite.focus.server.wallpost.request.RespondRequest;
import com.infinite.focus.server.wallpost.service.WallPostService;
import com.infinite.focus.server.wallpostrequest.repository.WallPostRequestRepository;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/school"})
public class SchoolController {
    private final AuthService authService;
    private final DistrictService districtService;
    private final SchoolService schoolService;
    private final CleverService cleverService;
    private final CleverSchoolService cleverSchoolService;
    private final AccountService accountService;
    private final CleverSchoolSyncService cleverSchoolSyncService;
    private final CleverDataService cleverDataService;
    private final WallPostService wallPostService;
    private final WallPostRequestRepository wallPostRequestRepository;
    private final WallPostBadWordFilterComponent badWordFilterComponent;
    private final StudentRepository studentRepository;
    private final MessageService messageService;
    private final JwtHelper jwtHelper;

    public SchoolController(AuthService authService, DistrictService districtService, SchoolService schoolService, CleverService cleverService, CleverSchoolService cleverSchoolService, AccountService accountService, CleverSchoolSyncService cleverSchoolSyncService, CleverDataService cleverDataService, WallPostService wallPostService, WallPostRequestRepository wallPostRequestRepository, WallPostBadWordFilterComponent badWordFilterComponent, StudentRepository studentRepository, MessageService messageService, JwtHelper jwtHelper) {
        this.authService = authService;
        this.districtService = districtService;
        this.schoolService = schoolService;
        this.cleverService = cleverService;
        this.cleverSchoolService = cleverSchoolService;
        this.accountService = accountService;
        this.cleverSchoolSyncService = cleverSchoolSyncService;
        this.cleverDataService = cleverDataService;
        this.wallPostService = wallPostService;
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.badWordFilterComponent = badWordFilterComponent;
        this.studentRepository = studentRepository;
        this.messageService = messageService;
        this.jwtHelper = jwtHelper;
    }

    @PostMapping(value={"/get-settings-by-id"})
    public ResponseEntity<SchoolSettingsWrapper> getSettingsById(@RequestHeader(value="Authorization") String token, @RequestBody GetSchoolByIdRequest request) {
        return new ResponseEntity((Object)this.schoolService.getSettingsById(request.getSchool_id()), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/schools"})
    public ResponseEntity<Page<School>> getSchools(@RequestHeader(value="Authorization") String token, @RequestParam(value="school_name", defaultValue="") String schoolName, @RequestParam(value="pageNo", defaultValue="0") Integer pageNo, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="sortBy", defaultValue="school_id") String sortBy, @RequestParam(value="orderBy", defaultValue="asc") String orderBy) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.schoolService.getSchools(schoolName, pageNo, pageSize, sortBy, orderBy), (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/school/{school_id}"})
    public ResponseEntity<School> getTierById(@PathVariable(value="school_id") Long school_id) {
        return new ResponseEntity((Object)this.schoolService.getSchoolById(school_id.longValue()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-school-by-id"})
    public ResponseEntity<School> getSchoolById(@RequestBody GetSchoolByIdRequest request) {
        return new ResponseEntity((Object)this.schoolService.getSchoolById(request.getSchool_id()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-school-by-student-id"})
    public ResponseEntity<School> getSchoolByStudentId(@RequestBody GetSchoolByStudentIdRequest request) {
        return new ResponseEntity((Object)this.schoolService.getSchoolByStudentId(request.getStudent_id()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/school/email"})
    public ResponseEntity<GetSchoolEmailResponse> getSchoolEmail(@RequestHeader(value="Authorization") String token, @RequestBody GetSchoolEmailRequest request) {
        return new ResponseEntity((Object)GetSchoolEmailResponse.builder().email(this.schoolService.getSchoolEmailBySchoolId(request.getSchool_id(), token)).build(), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/students/count/{school_id}"})
    public ResponseEntity<Long> getStudentsCountBySchoolId(@PathVariable(value="school_id") Long school_id) {
        return new ResponseEntity((Object)this.schoolService.getStudentsCountBySchoolId(school_id.longValue()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/students/by/school"})
    @ResponseBody
    public ResponseEntity<Page<Object>> getStudentsBySchool(@RequestHeader(value="Authorization") String token, @RequestBody GetStudentsBySchoolRequest request) {
        List schools = this.authService.isSchool(token);
        School school = null;
        if (!AppUtils.isNullOrEmpty((List)schools)) {
            school = schools.stream().filter(item -> item.getSchool_id() == request.getSchool_id()).findFirst().orElse(null);
        }
        if (school == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
        }
        return new ResponseEntity((Object)this.schoolService.getStudentsBySchool(school.getSchool_id(), request), (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/edit/profile"})
    public ResponseEntity<School> editProfile(@RequestHeader(value="Authorization") String token, @RequestBody SchoolSignUpRequest request) {
        List schools = this.authService.isSchool(token);
        School s = null;
        if (!AppUtils.isNullOrEmpty((List)schools)) {
            s = schools.stream().filter(item -> item.getSchool_id() == request.getSchool().getSchool_id()).findFirst().orElse(null);
        }
        if (s == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.school.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getSchool().getSchool_name())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.school.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getSchool().getAddress())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.address.is.required"));
        }
        s.setSchool_name(request.getSchool().getSchool_name());
        s.setAddress(request.getSchool().getAddress());
        if (!AppUtils.isNullOrEmpty((String)request.getSchool().getClever_id())) {
            this.cleverDataService.isCleverIdAlreadyInUse(request.getSchool().getClever_id());
            District district = this.districtService.getDistrictById(s.getDistrict_id());
            if (district == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.district.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)district.getClever_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.district.has.no.valid.clever.id"));
            }
            AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
            if (accessToken == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.clever.id.is.not.valid"));
            }
            CleverSchool cleverSchool = this.cleverSchoolService.getCleverSchoolById(accessToken.getAccess_token(), request.getSchool().getClever_id());
            if (cleverSchool == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.clever.id.is.not.valid"));
            }
            if (!cleverSchool.getDistrict().equals(district.getClever_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("your.clever.district.is.different.than.clymb.district"));
            }
            s.setClever_id(cleverSchool.getId());
            s.setSchool_name(cleverSchool.getName());
            s.setAddress(cleverSchool.getLocation().getAddress() + ", " + cleverSchool.getLocation().getCity() + ", " + cleverSchool.getLocation().getState() + " " + cleverSchool.getLocation().getZip());
        }
        Account account = this.accountService.changeEmail(s.getAccount_id(), request.getUsername());
        School school = this.schoolService.save(s);
        try {
            if (!AppUtils.isNullOrEmpty((String)school.getClever_id())) {
                this.cleverSchoolSyncService.syncSchool(school.getSchool_id());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String newToken = this.jwtHelper.generateToken(account.getUsername());
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Authorization", newToken);
        responseHeaders.set("Authorization_Refresh_Token", this.jwtHelper.generateRefreshToken(account.getUsername()));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)school);
    }

    @PostMapping(value={"/auto/approve/wall/posts"})
    public ResponseEntity<School> autoApproveWallPosts(@RequestHeader(value="Authorization") String token, @RequestBody AutoApproveWallPostsRequest request) {
        List schools = this.authService.isSchool(token);
        School s = null;
        if (!AppUtils.isNullOrEmpty((List)schools)) {
            s = schools.stream().filter(item -> item.getSchool_id() == request.getSchool_id()).findFirst().orElse(null);
        }
        if (s == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.school.is.not.found"));
        }
        s.setAuto_approve_wall_posts(request.isAuto_approve_wall_posts());
        School finalS = s = this.schoolService.save(s);
        new Thread(() -> this.approveWallPostsBySchool(finalS)).start();
        return new ResponseEntity((Object)s, (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/enable/wall/posts"})
    public ResponseEntity<School> enableWallPosts(@RequestHeader(value="Authorization") String token, @RequestBody EnableWallPostsRequest request) {
        List schools = this.authService.isSchool(token);
        School s = null;
        if (!AppUtils.isNullOrEmpty((List)schools)) {
            s = schools.stream().filter(item -> item.getSchool_id() == request.getSchool_id()).findFirst().orElse(null);
        }
        if (s == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.school.is.not.found"));
        }
        s.setEnable_wow(request.isEnable_wow());
        return new ResponseEntity((Object)this.schoolService.save(s), (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/enable/journal"})
    public ResponseEntity<School> enableJournal(@RequestHeader(value="Authorization") String token, @RequestBody EnableJournalRequest request) {
        List schools = this.authService.isSchool(token);
        School s = null;
        if (!AppUtils.isNullOrEmpty((List)schools)) {
            s = schools.stream().filter(item -> item.getSchool_id() == request.getSchool_id()).findFirst().orElse(null);
        }
        if (s == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.school.is.not.found"));
        }
        s.setEnable_journal(request.isEnable_journal());
        return new ResponseEntity((Object)this.schoolService.save(s), (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/auto/approve/wall/posts/for/all/school"})
    public ResponseEntity<Message> autoApproveWallPostsForAllSchool(@RequestHeader(value="Authorization") String token, @RequestBody AutoApproveWallPostsRequest request) {
        this.authService.isAdmin(token);
        for (School s : this.schoolService.findAllSchoolsOrderBySchoolIdASC()) {
            if (s == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.school.is.not.found"));
            }
            s.setAuto_approve_wall_posts(request.isAuto_approve_wall_posts());
            School finalS = s = this.schoolService.save(s);
            new Thread(() -> this.approveWallPostsBySchool(finalS)).start();
        }
        Message message = new Message(this.messageService.getMessage("auto.approved.set.to.true.for.all.schools.in.database"));
        return new ResponseEntity((Object)message, (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    private void approveWallPostsBySchool(School school) {
        if (school != null && school.isAuto_approve_wall_posts()) {
            Set studentIds = this.studentRepository.findBySchoolIdOrderByStudentIdASC(Long.valueOf(school.getSchool_id())).stream().map(Student::getStudent_id).collect(Collectors.toSet());
            List list = this.wallPostRequestRepository.findAll().stream().filter(wallPostRequest -> {
                WallPost wallPost = this.wallPostService.getByWallPostId(wallPostRequest.getWall_post_id());
                return wallPost != null && studentIds.contains(wallPost.getStudent_id()) && this.badWordFilterComponent.isThereAnyBadWordInText(wallPost.getText()) == false;
            }).map(wallPostRequest -> {
                RespondRequest respondRequest = new RespondRequest();
                respondRequest.setWall_post_request_id(Long.valueOf(wallPostRequest.getWall_post_request_id()));
                respondRequest.setResponse(Boolean.valueOf(true));
                try {
                    return this.wallPostService.approveRejectWallPost(respondRequest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    @PostMapping(value={"/get/instructors/by/school"})
    @ResponseBody
    public ResponseEntity<List<Instructor>> getInstructorsBySchool(@RequestHeader(value="Authorization") String token, @RequestBody GetStudentsBySchoolRequest request) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.schoolService.getInstructorsBySchool(request.getSchool_id(), request), (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/search/school"})
    public ResponseEntity<School> searchForSchool(@RequestBody SearchSchoolRequest request) {
        School s = this.schoolService.getSchoolByRegistrationCode(request.getCode());
        if (s == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)s, (HttpStatusCode)HttpStatus.OK);
    }
}

