/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sharedyouth.service;

import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.sharedyouth.entity.SharedYouth;
import com.infinite.focus.server.sharedyouth.repository.SharedYouthRepository;
import com.infinite.focus.server.sharedyouth.service.SharedYouthService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SharedYouthServiceImpl
implements SharedYouthService {
    private final InstructorService instructorService;
    private final SharedYouthRepository sharedYouthRepository;

    public SharedYouthServiceImpl(InstructorService instructorService, SharedYouthRepository sharedYouthRepository) {
        this.instructorService = instructorService;
        this.sharedYouthRepository = sharedYouthRepository;
    }

    public List<Instructor> getColleagueInstructorsByInstructorId(long instructor_id) {
        Instructor instructor = this.instructorService.getInstructorById(instructor_id);
        List instructors = this.instructorService.getInstructorsBySchoolId(instructor.getSchool_id());
        return instructors.stream().filter(i -> i.getInstructor_id() != instructor_id).collect(Collectors.toList());
    }

    public List<SharedYouth> getSharedYouthByInstructorId(long instructor_id) {
        return this.sharedYouthRepository.findByInstructorId(instructor_id);
    }

    public void deleteSharedYouthByStudentId(long student_id) {
        List sharedYouths = this.sharedYouthRepository.findByStudentId(student_id);
        this.sharedYouthRepository.deleteAll((Iterable)sharedYouths);
    }

    public List<SharedYouth> shareStudentWithInstructors(long student_id, List<Long> instructor_ids) {
        this.deleteSharedYouthByStudentId(student_id);
        for (long instructor_id : instructor_ids) {
            SharedYouth sharedYouth = new SharedYouth();
            sharedYouth.setStudent_id(student_id);
            sharedYouth.setInstructor_id(instructor_id);
            this.sharedYouthRepository.save((Object)sharedYouth);
        }
        return this.sharedYouthRepository.findByStudentId(student_id);
    }

    public boolean isStudentSharedWithInstructor(long student_id, long instructor_id) {
        SharedYouth sharedYouth = this.sharedYouthRepository.findByStudentIdAndInstructorId(student_id, instructor_id);
        return sharedYouth != null;
    }
}

