/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.favorite.service;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.favorite.dto.FavoriteDTO;
import com.infinite.focus.server.favorite.repository.FavoriteRepository;
import com.infinite.focus.server.favorite.service.FavoriteService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.service.PostService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class FavoriteServiceImpl
implements FavoriteService {
    @Autowired
    PostService postService;
    @Autowired
    private FavoriteRepository favoriteRepository;
    @Autowired
    MessageService messageService;

    public FavoriteDTO findByPostIdAndStudentId(long post_id, long student_id) {
        return this.favoriteRepository.findByPostIdAndStudentId(post_id, student_id);
    }

    public Message addRemoveFavorite(long post_id, long student_id) {
        PostDTO post = this.postService.findByPostId(post_id);
        if (post == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.post.is.not.found"));
        }
        FavoriteDTO favorite = this.findByPostIdAndStudentId(post_id, student_id);
        Message message = new Message();
        if (favorite == null) {
            this.favoriteRepository.create(post_id, student_id);
            message.setMessage(this.messageService.getMessage().getAdded_to_favorite());
        } else {
            this.favoriteRepository.deleteById(favorite.getFavorite_id());
            message.setMessage(this.messageService.getMessage().getRemoved_from_favorite());
        }
        return message;
    }

    public List<Long> getPostIdsByStudentId(long student_id) {
        return this.favoriteRepository.findPostIdsByStudentId(student_id);
    }
}

