/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.security.filter;

import com.infinite.focus.server.security.helper.JwtHelper;
import com.infinite.focus.server.utils.AppUtils;
import io.jsonwebtoken.ExpiredJwtException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.HandlerExceptionResolver;

public class JWTAuthorizationFilter
extends OncePerRequestFilter {
    @Autowired
    private JwtHelper jwtHelper;
    @Autowired
    private UserDetailsService userDetailsService;
    private HandlerExceptionResolver exceptionResolver;

    public JWTAuthorizationFilter(HandlerExceptionResolver exceptionResolver) {
        this.exceptionResolver = exceptionResolver;
    }

    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String header = req.getHeader("Authorization");
        String header_refresh_token = req.getHeader("Authorization_Refresh_Token");
        if (header == null || !header.startsWith("Bearer ") || !AppUtils.isNullOrEmpty((String)header_refresh_token)) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        try {
            UsernamePasswordAuthenticationToken authentication = this.getAuthentication(req);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
        catch (ExpiredJwtException ex) {
            this.exceptionResolver.resolveException(req, res, null, (Exception)((Object)ex));
        }
    }

    private UsernamePasswordAuthenticationToken getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token == null || Objects.equals(token, "") || token.contains("undefined")) {
            return null;
        }
        String fullURL = request.getRequestURL().toString();
        if (fullURL.contains("get/data")) {
            Boolean isExpired = this.jwtHelper.isTokenExpired(token);
            String user = null;
            user = isExpired != false ? this.jwtHelper.extractUsernameForExpiredToken(token) : this.jwtHelper.extractUsername(token);
            if (user != null) {
                return new UsernamePasswordAuthenticationToken((Object)user, null, new ArrayList());
            }
        } else {
            String user = this.jwtHelper.extractUsername(token);
            if (user != null) {
                return new UsernamePasswordAuthenticationToken((Object)user, null, new ArrayList());
            }
        }
        return null;
    }
}

